/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.win32;

import com.installshield.util.LibraryLoader;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.service.ServiceBuilderSupport;
import com.installshield.wizard.service.WizardServices;
import java.io.IOException;
import java.net.URL;

public class Win32Utils {
    public static final String JVM_VERIFY_CLASS_NAME = "Verify.class";
    public static final String LAUNCHER_NAME = "LauncherMain.exe";

    public static void addHelperClassesToArchive(ServiceBuilderSupport serviceBuilderSupport) throws IOException {
        serviceBuilderSupport.putClass("com.installshield.wizard.platform.win32.Win32Platform");
        serviceBuilderSupport.putClass("com.installshield.wizard.platform.win32.Win32Utils");
    }

    public static void addNativeSupportToArchive(ServiceBuilderSupport serviceBuilderSupport, WizardServices wizardServices) throws IOException {
        String[] stringArray = new String[]{"win32ppk.dll", "isjecln.exe", JVM_VERIFY_CLASS_NAME};
        int n = 0;
        while (n < stringArray.length) {
            String string = String.valueOf(Win32Utils.getWin32PPKSubdir()) + stringArray[n];
            URL uRL = wizardServices.getResource(string);
            serviceBuilderSupport.putResource(uRL, string);
            ++n;
        }
    }

    public static String getJNIDLLName() {
        return "win32ppk.dll";
    }

    public static String getJNIDLLResourceName() {
        return String.valueOf(Win32Utils.getWin32PPKSubdir()) + Win32Utils.getJNIDLLName();
    }

    public static String getPlatformLauncherResource() {
        return String.valueOf(Win32Utils.getWin32PPKSubdir()) + LAUNCHER_NAME;
    }

    public static String getVerifyClassResource() {
        return String.valueOf(Win32Utils.getWin32PPKSubdir()) + JVM_VERIFY_CLASS_NAME;
    }

    public static String getWin32PPKSubdir() {
        return "win32ppk/";
    }

    public static void loadDLL(URL uRL, String string) {
        try {
            LibraryLoader.loadLibrary(uRL, string);
        }
        catch (Throwable throwable) {
            System.out.println(LocalizedStringResolver.resolve("com.installshield.wizard.platform.win32.i18n.Win32Resources", "Win32Utils.cannotLoadJniDll", new String[]{uRL.toString()}));
            throwable.printStackTrace();
        }
    }
}

