/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.service;

import com.installshield.qjml.PropertyAccessible;
import com.installshield.util.GenericProgress;
import com.installshield.util.LibraryLoader;
import com.installshield.util.Progress;
import com.installshield.wizard.service.AsynchronousOperation;
import com.installshield.wizard.service.OperationKey;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.ServiceImplementor;
import com.installshield.wizard.service.WizardServices;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;

public abstract class AbstractServiceImplementor
implements ServiceImplementor,
PropertyAccessible {
    private Properties properties = new Properties();
    private WizardServices services = null;
    private LibraryLoader libraryLoader = null;
    private Hashtable operations = new Hashtable();
    private Hashtable finishedOperations = new Hashtable();

    public void cancelOperation(OperationKey operationKey) throws ServiceException {
        this.getOperation(operationKey).cancel();
    }

    public void cleanup() throws ServiceException {
    }

    protected AsynchronousOperation getOperation(OperationKey operationKey) throws ServiceException {
        AsynchronousOperation asynchronousOperation = (AsynchronousOperation)this.operations.get(operationKey);
        if (asynchronousOperation == null) {
            asynchronousOperation = (AsynchronousOperation)this.finishedOperations.get(operationKey);
        }
        if (asynchronousOperation == null) {
            throw new ServiceException(316, operationKey.getName());
        }
        return asynchronousOperation;
    }

    public Progress getOperationProgress(OperationKey operationKey) throws ServiceException {
        return new GenericProgress(this.getOperation(operationKey).getProgress());
    }

    public Properties getProperties() {
        return this.properties;
    }

    public URL getResource(String string) throws IOException {
        return this.getServices().getResource(string);
    }

    public WizardServices getServices() {
        return this.services;
    }

    public abstract int getSystemCompatibility();

    public void initialize(Properties properties, WizardServices wizardServices) {
        this.properties = properties;
        this.services = wizardServices;
        this.initialized();
    }

    protected void initialized() {
    }

    protected boolean isEventLogged(String string) {
        return this.getServices().getWizardLog().isEventLogged(string);
    }

    public boolean isOperationCanceled(OperationKey operationKey) throws ServiceException {
        return this.getOperation(operationKey).isCanceled();
    }

    public boolean isOperationEnded(OperationKey operationKey) throws ServiceException {
        return this.finishedOperations.containsKey(operationKey);
    }

    public boolean isOperationSuspended(OperationKey operationKey) throws ServiceException {
        return this.getOperation(operationKey).isSuspended();
    }

    public void log(Object object, String string, Object object2) {
        if (this.services == null) {
            throw new IllegalStateException("service manager not initialized");
        }
        this.services.logEvent(object, string, object2);
    }

    protected void logEvent(Object object, String string, Object object2) {
        this.getServices().logEvent(object, string, object2);
    }

    public void operationStateChanged(AsynchronousOperation asynchronousOperation) {
        OperationKey operationKey = asynchronousOperation.getKey();
        if (asynchronousOperation.isEnded()) {
            this.finishedOperations.put(operationKey, asynchronousOperation);
            this.operations.remove(operationKey);
        }
        OperationKey operationKey2 = operationKey;
        synchronized (operationKey2) {
            operationKey.notifyAll();
        }
    }

    public void resumeOperation(OperationKey operationKey) throws ServiceException {
        this.getOperation(operationKey).resume();
    }

    protected void startOperation(AsynchronousOperation asynchronousOperation) {
        Thread thread = new Thread(asynchronousOperation);
        this.operations.put(asynchronousOperation.getKey(), asynchronousOperation);
        thread.start();
    }

    public void suspendOperation(OperationKey operationKey) throws ServiceException {
        this.getOperation(operationKey).suspend();
    }
}

