/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.service;

import com.installshield.util.Progress;
import com.installshield.wizard.service.AbstractServiceImplementor;
import com.installshield.wizard.service.MutableOperationState;
import com.installshield.wizard.service.OperationKey;

public abstract class AsynchronousOperation
implements Runnable,
Progress,
MutableOperationState {
    private OperationKey key;
    private AbstractServiceImplementor service;
    private boolean suspended = false;
    private boolean canceled = false;
    private boolean ended = false;
    private String title = "";
    private float percentComplete = 0.0f;
    private String statusDescription = "";
    private String statusDetail = "";
    private int estimatedTimeToComplete = 0;
    private float timeCompleted = 0.0f;
    private long updateCounter = 0L;
    private String lastMessage = null;

    public AsynchronousOperation(String string) {
        this(string, null);
    }

    public AsynchronousOperation(String string, AbstractServiceImplementor abstractServiceImplementor) {
        this.key = new OperationKey(string);
        this.service = abstractServiceImplementor;
    }

    public void cancel() {
        this.suspended = false;
        this.canceled = true;
        AsynchronousOperation asynchronousOperation = this;
        synchronized (asynchronousOperation) {
            this.notifyAll();
        }
        if (this.service != null) {
            this.service.operationStateChanged(this);
        }
    }

    protected abstract void execute();

    public int getEstimatedTimeToComplete() {
        return this.estimatedTimeToComplete;
    }

    public OperationKey getKey() {
        return this.key;
    }

    public String getLastMessage() {
        return this.lastMessage;
    }

    public int getPercentComplete() {
        return Math.round(this.percentComplete);
    }

    public Progress getProgress() {
        return this;
    }

    public String getStatusDescription() {
        return this.statusDescription;
    }

    public String getStatusDetail() {
        return this.statusDetail;
    }

    public String getTitle() {
        return this.title;
    }

    public long getUpdateCounter() {
        return this.updateCounter;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public boolean isEnded() {
        return this.ended;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void resetUpdateCounter() {
        this.updateCounter = 0L;
    }

    public void resume() {
        this.suspended = false;
        AsynchronousOperation asynchronousOperation = this;
        synchronized (asynchronousOperation) {
            this.notifyAll();
        }
        if (this.service != null) {
            this.service.operationStateChanged(this);
        }
    }

    public final void run() {
        this.execute();
        this.ended = true;
        AsynchronousOperation asynchronousOperation = this;
        synchronized (asynchronousOperation) {
            this.notifyAll();
        }
        if (this.service != null) {
            this.service.operationStateChanged(this);
        }
    }

    public void setEstimatedTimeToComplete(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("tenthsOfSeconds cannot be negative");
        }
        this.estimatedTimeToComplete = n;
    }

    public void setLastMessage(String string) {
        this.lastMessage = string;
    }

    public void setPercentComplete(int n) {
        this.percentComplete = n;
        this.timeCompleted = this.estimatedTimeToComplete > 0 ? (float)(n / 100 * this.estimatedTimeToComplete) : 0.0f;
    }

    public void setStatusDescription(String string) {
        this.statusDescription = string;
    }

    public void setStatusDetail(String string) {
        this.statusDetail = string;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void suspend() {
        this.suspended = true;
        AsynchronousOperation asynchronousOperation = this;
        synchronized (asynchronousOperation) {
            this.notifyAll();
        }
        if (this.service != null) {
            this.service.operationStateChanged(this);
        }
    }

    public void updatePercentComplete(int n, long l, long l2) {
        if (this.estimatedTimeToComplete > 0 && l2 > 0L) {
            this.timeCompleted += (float)n * ((float)l / (float)l2);
            this.percentComplete = 100.0f * (this.timeCompleted / (float)this.estimatedTimeToComplete);
            this.updateCounter += l;
        }
    }
}

