/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.actions;

import com.installshield.wizard.WizardAction;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.WizardException;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;
import com.installshield.wizard.service.system.SystemUtilService;
import com.installshield.wizardx.ascii.AsciiFileUpdateSupport;
import com.installshield.wizardx.ascii.ModifyFile;
import com.installshield.wizardx.ascii.Update;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class AsciiFileUpdateWizardAction
extends WizardAction
implements AsciiFileUpdateSupport {
    private String asciiFile = "";
    private String commentChars = "";
    private boolean rebootRequired = false;
    private Vector actionsList = new Vector();
    private Update[] actions = null;
    private boolean backupAsciiFile = true;
    private boolean overwriteExistingFile = false;
    static /* synthetic */ Class class$com$installshield$wizardx$actions$AsciiFileUpdateWizardActionBeanInfo;

    public void addAction(Update update) {
        this.actionsList.addElement(update);
    }

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        try {
            wizardBuilderSupport.putPackage("com.installshield.wizardx.ascii");
            wizardBuilderSupport.putClass((class$com$installshield$wizardx$actions$AsciiFileUpdateWizardActionBeanInfo != null ? class$com$installshield$wizardx$actions$AsciiFileUpdateWizardActionBeanInfo : (class$com$installshield$wizardx$actions$AsciiFileUpdateWizardActionBeanInfo = AsciiFileUpdateWizardAction.class$("com.installshield.wizardx.actions.AsciiFileUpdateWizardActionBeanInfo"))).getName());
            wizardBuilderSupport.putRequiredService("fileService");
            wizardBuilderSupport.putRequiredService("systemUtilService");
        }
        catch (IOException iOException) {
            wizardBuilderSupport.logEvent(this, "err", iOException);
        }
        if (this.asciiFile == null || this.asciiFile.trim().length() <= 0) {
            wizardBuilderSupport.logEvent(this, "wrn", "Ascii File property is required for " + this.getDisplayName() + ".");
        }
        if (this.actionsList.isEmpty()) {
            wizardBuilderSupport.logEvent(this, "wrn", "There must be at least one entry in the Actions list for " + this.getDisplayName() + ".");
        }
        Enumeration enumeration = this.actionsList.elements();
        while (enumeration.hasMoreElements()) {
            Update update = (Update)enumeration.nextElement();
            update.verify(this);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void execute(WizardBeanEvent wizardBeanEvent) {
        try {
            Object object;
            ModifyFile modifyFile = new ModifyFile(this);
            modifyFile.setFile(this.resolveString(this.getAsciiFile()));
            modifyFile.setCommentChar(this.resolveString(this.getCommentChars()));
            modifyFile.setFileService((FileService)this.getService("fileService"));
            modifyFile.setOverwriteExisting(this.getOverwriteExistingFile());
            boolean bl = modifyFile.loadFile();
            if (bl && this.getBackupAsciiFile()) {
                modifyFile.backupFile();
            }
            boolean bl2 = false;
            Enumeration enumeration = this.actionsList.elements();
            while (enumeration.hasMoreElements()) {
                object = (Update)enumeration.nextElement();
                bl2 |= object.execute(modifyFile);
            }
            modifyFile.logChanges();
            if (bl2) {
                modifyFile.writeFile();
                if (this.isRebootRequired()) {
                    object = (SystemUtilService)this.getService("systemUtilService");
                    object.setRebootRequired(true);
                }
            }
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
        }
        catch (WizardException wizardException) {
            this.logEvent(this, "err", wizardException);
        }
    }

    public Update[] getActions() {
        this.actions = this.getActionsFromList();
        return this.actions;
    }

    private Update[] getActionsFromList() {
        Update[] updateArray = new Update[this.actionsList.size()];
        int n = 0;
        while (n < this.actionsList.size()) {
            updateArray[n] = (Update)this.actionsList.elementAt(n);
            ++n;
        }
        return updateArray;
    }

    public Vector getActionsList() {
        return this.actionsList;
    }

    public String getAsciiFile() {
        return this.asciiFile;
    }

    public boolean getBackupAsciiFile() {
        return this.backupAsciiFile;
    }

    public String getCommentChars() {
        return this.commentChars;
    }

    public boolean getOverwriteExistingFile() {
        return this.overwriteExistingFile;
    }

    public boolean isRebootRequired() {
        return this.rebootRequired;
    }

    public void logEvent(Object object, String string, Object object2) {
        super.logEvent(object, string, object2);
    }

    public String resolveString(String string) {
        return super.resolveString(string);
    }

    public void setActions(Update[] updateArray) {
        this.actionsList.removeAllElements();
        int n = 0;
        while (n < updateArray.length) {
            this.actionsList.addElement(updateArray[n]);
            ++n;
        }
        this.actions = this.getActionsFromList();
    }

    public void setActionsList(Vector vector) {
        this.actionsList = vector;
    }

    public void setAsciiFile(String string) {
        if (string == null) {
            throw new IllegalArgumentException("asciiFileName cannot be null");
        }
        this.asciiFile = string;
    }

    public void setBackupAsciiFile(boolean bl) {
        this.backupAsciiFile = bl;
    }

    public void setCommentChars(String string) {
        if (string == null) {
            throw new IllegalArgumentException("commentChars cannot be null");
        }
        this.commentChars = string;
    }

    public void setOverwriteExistingFile(boolean bl) {
        this.overwriteExistingFile = bl;
    }

    public void setRebootRequired(boolean bl) {
        this.rebootRequired = bl;
    }
}

