/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.ascii;

import com.installshield.qjml.PropertyAccessible;
import com.installshield.wizardx.ascii.AbstractUpdate;
import com.installshield.wizardx.ascii.AsciiFileUpdateSupport;
import com.installshield.wizardx.ascii.ModifyFile;
import com.installshield.wizardx.ascii.Update;

public class ReplaceLine
extends AbstractUpdate
implements Update,
Cloneable,
PropertyAccessible {
    private int replaceOption = 1;
    private String oldLine = new String();
    private String[] newLines = new String[0];
    public static final String TYPE_DESCRIPTION = "Replace Line/Text";
    public static final int LINE = 0;
    public static final int TEXT = 1;

    public Object clone() {
        ReplaceLine replaceLine = (ReplaceLine)super.clone();
        replaceLine.replaceOption = this.replaceOption;
        replaceLine.oldLine = this.oldLine;
        replaceLine.newLines = this.newLines;
        return replaceLine;
    }

    public boolean execute(ModifyFile modifyFile) {
        boolean bl = false;
        if (this.getNewLines() == null || this.getNewLines().length == 0 || this.getNewLines().length == 1 && this.getNewLines()[0].length() == 0) {
            modifyFile.getLogAdd().addElement("Replace Line/Text requires New Line(s).");
        } else if (this.getReplaceOption() == 1 && (this.getOldLine() == null || this.getOldLine().length() == 0)) {
            modifyFile.getLogAdd().addElement("Replace Line/Text requires Old Lines if replacing Text.");
        } else if (modifyFile.getASCIISearchResults() != null && modifyFile.getASCIISearchResults().length > 0) {
            String[] stringArray = new String[this.getNewLines().length];
            int n = 0;
            while (n < this.getNewLines().length) {
                stringArray[n] = modifyFile.resolveString(this.getNewLines()[n]);
                ++n;
            }
            if (this.getReplaceOption() == 1) {
                bl = modifyFile.replaceText(modifyFile.resolveString(this.getOldLine()), stringArray);
            } else {
                modifyFile.replaceLine(stringArray);
                bl = true;
            }
            modifyFile.setASCIISearchResults(null);
        }
        return bl;
    }

    private String formatNewLines() {
        String[] stringArray = this.getNewLines();
        if (stringArray == null || stringArray.length <= 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 30;
        int n2 = 0;
        while (n > 0 && n2 < stringArray.length) {
            String string;
            if (n2 > 0) {
                stringBuffer.append(", ");
            }
            if ((string = stringArray[n2]).length() > n) {
                stringBuffer.append(String.valueOf(string.substring(0, n)) + "...");
            } else {
                stringBuffer.append(string);
            }
            n -= string.length();
            ++n2;
        }
        return stringBuffer.toString();
    }

    public String[] getNewLines() {
        return this.newLines;
    }

    public String getOldLine() {
        return this.oldLine;
    }

    public int getReplaceOption() {
        return this.replaceOption;
    }

    public String getShortDescription() {
        String string = new String();
        string = this.getReplaceOption() == 1 ? "Replace Old Text: " + this.getOldLine() + " with New Text: " : "Replace Old Line with New Line(s): ";
        return string.concat(this.formatNewLines());
    }

    public String getTypeDescription() {
        return TYPE_DESCRIPTION;
    }

    public void setNewLines(String[] stringArray) {
        this.newLines = stringArray;
    }

    public void setOldLine(String string) {
        this.oldLine = string;
    }

    public void setReplaceOption(int n) {
        this.replaceOption = n;
    }

    public void verify(AsciiFileUpdateSupport asciiFileUpdateSupport) {
        if (this.getNewLines() == null || this.getNewLines().length == 0 || this.getNewLines().length == 1 && this.getNewLines()[0].length() == 0) {
            asciiFileUpdateSupport.logEvent(this, "wrn", "Replace Line/Text requires New Line(s).");
        }
        if (this.getReplaceOption() == 1 && (this.getOldLine() == null || this.getOldLine().length() == 0)) {
            asciiFileUpdateSupport.logEvent(this, "wrn", "Replace Line/Text requires Old Line if replacing Text.");
        }
    }
}

