/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.panels;

import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.awt.AWTWizardUI;
import com.installshield.wizard.awt.ColumnLayout;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizardx.panels.TextDisplayPanel;
import com.installshield.wizardx.ui.ChoiceComponent;
import com.installshield.wizardx.ui.ChoiceComponentEvent;
import com.installshield.wizardx.ui.ChoiceComponentListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;

public class ApprovalPanel
extends TextDisplayPanel
implements ChoiceComponentListener {
    public static final int DROP_DOWN_TYPE = 1;
    public static final int RADIO_BUTTON_TYPE = 3;
    public static final int DISABLE_NEXT_BUTTON = 1;
    public static final int SHOW_WARNING_MESSAGE = 2;
    public static final int LEFT_ALIGN = 1;
    public static final int RIGHT_ALIGN = 2;
    public static final int CENTER_ALIGN = 3;
    public static final int UNSET = 0;
    public static final int APPROVE = 1;
    public static final int DISAPPROVE = 2;
    private String approveCaption = "";
    private String disapproveCaption = "";
    private int selection = 1;
    private int uiType = 3;
    private int uiAlignment = 1;
    private int onDisapprove = 1;
    private String warningMessage = "";
    private ChoiceComponent choiceComponent = new ChoiceComponent();
    private Container uiTypePanel;
    private boolean isApproved = false;
    private AWTWizardUI ui = null;

    public ApprovalPanel() {
        this.setDescription("");
        this.setText("");
        this.setApproveCaption("$L(com.installshield.wizardx.i18n.WizardXResources, ApprovalPanel.approval)");
        this.setDisapproveCaption("$L(com.installshield.wizardx.i18n.WizardXResources, ApprovalPanel.disapproval)");
    }

    public void choiceComponentStateChanged(ChoiceComponentEvent choiceComponentEvent) {
        String string = choiceComponentEvent.getItem();
        if (string.equals(this.resolveString(this.getApproveCaption()))) {
            this.isApproved = true;
            this.choiceComponent.setContinue(this.isApproved);
        } else {
            this.isApproved = false;
            this.choiceComponent.setContinue(this.isApproved);
        }
        this.refreshNavigationStates();
    }

    protected void createUI(WizardBeanEvent wizardBeanEvent) {
        super.createUI(wizardBeanEvent);
        this.choiceComponent.createComponentUI();
        this.selectState(this.selection);
    }

    public boolean entered(WizardBeanEvent wizardBeanEvent) {
        if (wizardBeanEvent.getUserInterface() instanceof AWTWizardUI) {
            this.ui = (AWTWizardUI)wizardBeanEvent.getUserInterface();
            this.refreshNavigationStates();
        }
        return true;
    }

    private int getApprovalAlignmentLayout() {
        switch (this.getUiAlignment()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 1;
            }
        }
        return 0;
    }

    public String getApproveCaption() {
        return this.approveCaption;
    }

    public String getDisapproveCaption() {
        return this.disapproveCaption;
    }

    public int getOnDisapprove() {
        return this.onDisapprove;
    }

    public int getSelection() {
        return this.selection;
    }

    public int getUiAlignment() {
        return this.uiAlignment;
    }

    public int getUiType() {
        return this.uiType;
    }

    public String getWarningMessage() {
        return this.warningMessage;
    }

    protected void initialize() {
        super.initialize();
        String[] stringArray = new String[]{this.resolveString(this.getApproveCaption()), this.resolveString(this.getDisapproveCaption())};
        this.choiceComponent.setOptions(stringArray);
        this.choiceComponent.setComponentType(this.getUiType());
        this.choiceComponent.addChoiceComponentListener(this);
        if (this.getSelection() != 0) {
            int n = this.getSelection() == 1 ? 0 : 1;
            this.choiceComponent.setSelectedIndex(n);
        }
        this.choiceComponent.setMultipleSelection(false);
        this.uiTypePanel = super.getPane();
        this.uiTypePanel.setLayout(new FlowLayout(this.getApprovalAlignmentLayout()));
        this.getContentPane().add((Component)this.uiTypePanel, "South");
        Container container = this.getPane();
        container.setLayout(new ColumnLayout());
        this.uiTypePanel.add(container);
        container.add(this.choiceComponent);
    }

    private boolean isApproved() {
        return this.isApproved;
    }

    public boolean queryExit(WizardBeanEvent wizardBeanEvent) {
        if (!this.isApproved()) {
            if (this.onDisapprove == 2) {
                try {
                    this.getWizard().getServices().displayUserMessage(this.resolveString(this.getTitle()), this.resolveString(this.getWarningMessage()), 4);
                }
                catch (ServiceException serviceException) {
                    this.logEvent(this, "wrn", serviceException);
                }
            }
            return false;
        }
        return true;
    }

    private void refreshAlignment() {
        if (this.uiTypePanel != null) {
            this.uiTypePanel.setLayout(new FlowLayout(this.getUiAlignment()));
            this.uiTypePanel.invalidate();
            this.uiTypePanel.validate();
        }
    }

    private void refreshNavigationStates() {
        if (this.onDisapprove == 1 && this.ui != null) {
            this.ui.getNavigationController().next().setEnabled(this.isApproved());
        }
    }

    private void refreshUiType() {
        if (this.choiceComponent != null) {
            this.choiceComponent.setComponentType(this.getUiType());
        }
    }

    private void selectComponentIndex(String string) {
        if (this.choiceComponent != null) {
            String[] stringArray = this.choiceComponent.getOptions();
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals(string)) {
                    this.choiceComponent.setSelectedIndex(n);
                }
                ++n;
            }
        }
    }

    private void selectState(int n) {
        if (n == 1) {
            this.selectComponentIndex(this.getApproveCaption());
            this.isApproved = true;
        } else if (n == 2) {
            this.isApproved = false;
            this.selectComponentIndex(this.getDisapproveCaption());
        }
        if (this.choiceComponent != null) {
            this.choiceComponent.setContinue(this.isApproved);
        }
    }

    public void setApproveCaption(String string) {
        this.approveCaption = string;
    }

    public void setDisapproveCaption(String string) {
        this.disapproveCaption = string;
    }

    public void setOnDisapprove(int n) {
        this.onDisapprove = n;
    }

    public void setSelection(int n) {
        this.selection = n;
        this.selectState(n);
    }

    public void setUiAlignment(int n) {
        if (n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException("Invalid alignment type " + n);
        }
        this.uiAlignment = n;
        this.refreshAlignment();
    }

    public void setUiType(int n) {
        if (n != 3 && n != 1) {
            throw new IllegalArgumentException("invalid uiType : " + n);
        }
        this.uiType = n;
        this.refreshUiType();
    }

    public void setWarningMessage(String string) {
        this.warningMessage = string;
    }
}

