/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.panels;

import com.installshield.util.FileUtils;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizardx.panels.ExtendedWizardPanel;
import com.installshield.wizardx.ui.TextDisplayComponent;
import java.awt.Component;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;

public class TextDisplayPanel
extends ExtendedWizardPanel {
    public static final int TEXT_CONTENT_TYPE = 1;
    public static final int HTML_CONTENT_TYPE = 2;
    public static final int TEXT_PROPERTY = 1;
    public static final int LOCAL_FILE = 2;
    private String text = "$L(com.installshield.wizardx.i18n.WizardXResources, TextDisplayPanel.text)";
    private int textSource = 1;
    private String fileName = "";
    private boolean includeLocalizedFiles = false;
    private int contentType = 2;
    private boolean showBorder = false;
    private TextDisplayComponent displayComponent = null;

    public TextDisplayPanel() {
        this.setDescription("$L(com.installshield.wizardx.i18n.WizardXResources, TextDisplayPanel.description)");
    }

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        super.build(wizardBuilderSupport);
        if (this.getTextSource() == 2) {
            this.buildFile(wizardBuilderSupport, this.fileName, null);
            if (this.includeLocalizedFiles) {
                Locale[] localeArray = wizardBuilderSupport.getSelectedLocales();
                int n = 0;
                while (n < localeArray.length) {
                    this.buildFile(wizardBuilderSupport, this.fileName, localeArray[n]);
                    ++n;
                }
            }
        }
    }

    private void buildFile(WizardBuilderSupport wizardBuilderSupport, String string, Locale locale) {
        try {
            File file = locale != null ? new File(this.createLocalizedName(string, locale)) : new File(string);
            if (file.exists()) {
                FileInputStream fileInputStream = new FileInputStream(file);
                wizardBuilderSupport.putResource(fileInputStream, this.createStorageName(string, locale));
            } else {
                wizardBuilderSupport.logEvent(this, locale == null ? "err" : "wrn", String.valueOf(String.valueOf(file)) + " does not exist");
            }
        }
        catch (IOException iOException) {
            this.logEvent(this, "wrn", iOException);
        }
    }

    private String createLocalizedName(String string, Locale locale) {
        String string2;
        String string3;
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string3 = string.substring(0, n);
            string2 = string.substring(n);
        } else {
            string3 = string;
            string2 = "";
        }
        return String.valueOf(string3) + "_" + locale.toString() + string2;
    }

    private String createStorageName(String string, Locale locale) {
        if (locale != null) {
            string = this.createLocalizedName(string, locale);
        }
        return String.valueOf(this.getBeanId()) + "_" + FileUtils.getName(string);
    }

    protected void createUI(WizardBeanEvent wizardBeanEvent) {
        super.createUI(wizardBeanEvent);
        this.displayComponent.createComponentUI();
    }

    private byte[] examineBytes(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            if (byArray[n2] == 13 && n2 + 1 < byArray.length && byArray[n2 + 1] == 10) {
                ++n2;
            }
            byArray2[n++] = byArray[n2];
            ++n2;
        }
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray2, 0, byArray3, 0, n);
        return byArray3;
    }

    public int getContentType() {
        return this.contentType;
    }

    public String getFileName() {
        return this.fileName;
    }

    private InputStream getFileResource() throws IOException {
        if (this.includeLocalizedFiles) {
            String string = this.createStorageName(this.fileName, Locale.getDefault());
            try {
                return this.getResource(string).openStream();
            }
            catch (IOException iOException) {
                this.logEvent(this, "wrn", "could not open resource for " + string);
            }
        }
        return this.getResource(this.createStorageName(this.fileName, null)).openStream();
    }

    public boolean getIncludeLocalizedFiles() {
        return this.includeLocalizedFiles;
    }

    public String getText() {
        return this.text;
    }

    public int getTextSource() {
        return this.textSource;
    }

    protected void initialize() {
        super.initialize();
        if (this.contentType == 2) {
            this.displayComponent = new TextDisplayComponent();
            this.displayComponent.setDisplayType(1);
            this.displayComponent.setShowBorder(this.showBorder);
        } else {
            this.displayComponent = new TextDisplayComponent(this.resolveString(this.getText()), false);
            this.displayComponent.setDisplayType(2);
        }
        if (this.getTextSource() == 2) {
            if (this.fileName != null && !this.fileName.equals("")) {
                try {
                    InputStream inputStream = this.getFileResource();
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    FileUtils.copy(inputStream, byteArrayOutputStream);
                    String string = new String(this.examineBytes(byteArrayOutputStream.toByteArray()));
                    this.displayComponent.setText(string);
                    inputStream.close();
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {
                    this.logEvent(this, "wrn", iOException);
                }
            }
        } else {
            this.displayComponent.setText(this.resolveString(this.getText()));
        }
        this.getContentPane().add((Component)this.displayComponent, "Center");
    }

    public boolean isShowBorder() {
        return this.showBorder;
    }

    public void setContentType(int n) {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("invalid content type");
        }
        this.contentType = n;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setIncludeLocalizedFiles(boolean bl) {
        this.includeLocalizedFiles = bl;
    }

    public void setShowBorder(boolean bl) {
        this.showBorder = bl;
    }

    public void setText(String string) {
        this.text = string;
        if (this.displayComponent != null) {
            this.displayComponent.setText(this.resolveString(string));
        }
    }

    public void setTextSource(int n) {
        this.textSource = n;
    }
}

