/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.ActiveBox;
import ice.htmlbrowser.Box;
import ice.htmlbrowser.BoxTableCell;
import ice.htmlbrowser.BoxWord;
import ice.htmlbrowser.CellInfo;
import ice.htmlbrowser.DocContainer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;

class BoxTable
extends Box
implements ActiveBox {
    private int startDragCell = -1;
    private int prevDragCell = -1;
    private Box prevSearchBox;
    private int prevSearchCell;
    private Point searchPosition;
    private Vector cellInfos;
    private CellInfo caption;
    private int capVAlign;
    private int capY;
    private int capHeight;
    private int cur_row;
    private int cur_col;
    private int numRows;
    private int numCols;
    private BoxTableCell cur_cell;
    private Color cur_bgColor;
    private int row_align = 1;
    private int row_valign = 2;
    private Color bgColor;
    private Color rowBgColor;
    private int table_width;
    private int border_size;
    private int cell_spacing = 3;
    private int cell_padding = 1;
    private int[] colCoord;
    private int[] rowCoord;
    private int[] colWidth;
    private int[] rowHeight;
    private Dimension tableMinMax;
    private int[] colMinWidth;
    private int[] colMaxWidth;
    static final int ALIGN_TOP = 0;
    static final int ALIGN_BOTTOM = 1;
    static final int ALIGN_MIDDLE = 2;

    BoxTable(DocContainer docContainer, int n, int n2, Color color) {
        super(docContainer);
        this.table_width = n;
        this.border_size = n2;
        this.cur_row = -1;
        this.cur_col = 0;
        this.numCols = 0;
        this.numRows = 0;
        this.cur_cell = null;
        this.cur_bgColor = null;
        this.cellInfos = new Vector();
        this.tableMinMax = null;
        this.caption = null;
        this.capY = 0;
        this.capHeight = 0;
        this.bgColor = color;
    }

    void setRowAlign(int n) {
        this.row_align = n;
    }

    void addTableRow() {
        ++this.cur_row;
        this.cur_col = 0;
        this.cur_cell = null;
        this.cur_bgColor = null;
        this.row_align = 1;
        this.row_valign = 2;
        this.rowBgColor = this.bgColor;
    }

    int getRowAlign() {
        return this.row_align;
    }

    void setRowVAlign(int n) {
        this.row_valign = n;
    }

    void setRowBgColor(Color color) {
        this.rowBgColor = color;
    }

    void setCellVAlign(int n) {
        if (this.cur_cell != null) {
            int n2 = this.cellInfos.size() - 1;
            ((CellInfo)this.cellInfos.elementAt((int)n2)).valign = n;
        }
    }

    void setCellBgColor(Color color) {
        if (this.cur_cell != null) {
            int n = this.cellInfos.size() - 1;
            ((CellInfo)this.cellInfos.elementAt((int)n)).bgColor = color;
            this.cur_bgColor = color;
        }
    }

    void setCellSpacing(int n) {
        this.cell_spacing = n;
    }

    void setCellPadding(int n) {
        this.cell_padding = n;
    }

    void addTableCell(int n, int n2, int n3, int n4) {
        CellInfo cellInfo;
        if (this.cur_row < 0) {
            this.cur_row = 0;
        }
        int n5 = this.cellInfos.size();
        int n6 = -1;
        int n7 = 0;
        while (n7 < n5) {
            cellInfo = (CellInfo)this.cellInfos.elementAt(n7);
            if (cellInfo.row < this.cur_row && cellInfo.row + cellInfo.rowspan > this.cur_row && cellInfo.col >= this.cur_col && this.cur_col + n > cellInfo.col && n6 < cellInfo.col) {
                this.cur_col = cellInfo.col + cellInfo.colspan;
                n6 = cellInfo.col;
                n7 = 0;
            }
            ++n7;
        }
        this.cur_cell = new BoxTableCell();
        cellInfo = new CellInfo(this.cur_cell, this.cur_col, this.cur_row, n, n2, n3, n4);
        this.cellInfos.addElement(cellInfo);
        this.setCellVAlign(this.row_valign);
        if (this.rowBgColor != null) {
            this.setCellBgColor(this.rowBgColor);
        }
        this.numRows = this.cur_row + 1;
        if (this.cur_col + 1 > this.numCols) {
            this.numCols = this.cur_col + 1;
        }
        this.cur_col += n;
    }

    void addCaption(int n) {
        this.capVAlign = n;
        this.cur_bgColor = null;
        this.cur_cell = new BoxTableCell();
        this.caption = new CellInfo(this.cur_cell, 0, 0, 1, 1, -1, -1);
    }

    void finishTable() {
        this.colWidth = new int[this.numCols];
        this.rowHeight = new int[this.numRows];
        this.colCoord = new int[this.numCols];
        this.rowCoord = new int[this.numRows];
        this.colMinWidth = new int[this.numCols];
        this.colMaxWidth = new int[this.numCols];
    }

    void addBox(Box box) {
        if (this.cur_cell == null) {
            this.addTableCell(1, 1, 0, 0);
        }
        this.cur_cell.addBox(box);
        if (this.cur_bgColor != null) {
            box.setBackColor(this.cur_bgColor);
        }
    }

    Dimension minMaxLayout() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        CellInfo cellInfo;
        if (this.tableMinMax != null) {
            return this.tableMinMax;
        }
        int n6 = this.cellInfos.size();
        int n7 = 0;
        while (n7 < n6) {
            cellInfo = (CellInfo)this.cellInfos.elementAt(n7);
            n5 = cellInfo.colspan;
            if (cellInfo.col + n5 > this.numCols) {
                n5 = this.numCols - cellInfo.col;
            }
            if (n5 <= 1) {
                cellInfo.cell.minMaxLayout();
                n4 = cellInfo.cell.minWidth;
                n3 = cellInfo.cell.maxWidth;
                if (cellInfo.set_width > 0) {
                    n3 = cellInfo.set_width >= n4 ? cellInfo.set_width : n4;
                }
                if (this.colMinWidth[cellInfo.col] < n4) {
                    this.colMinWidth[cellInfo.col] = n4;
                }
                if (this.colMaxWidth[cellInfo.col] < n3) {
                    this.colMaxWidth[cellInfo.col] = n3;
                }
            }
            ++n7;
        }
        n7 = 0;
        while (n7 < n6) {
            cellInfo = (CellInfo)this.cellInfos.elementAt(n7);
            n5 = cellInfo.colspan;
            if (cellInfo.col + n5 > this.numCols) {
                n5 = this.numCols - cellInfo.col;
            }
            if (n5 > 1) {
                cellInfo.cell.minMaxLayout();
                n4 = cellInfo.cell.minWidth;
                n3 = cellInfo.cell.maxWidth;
                if (cellInfo.set_width > 0) {
                    n3 = cellInfo.set_width >= n4 ? cellInfo.set_width : n4;
                }
                n2 = 0;
                n = 0;
                int n8 = 0;
                while (n8 < n5) {
                    n2 += this.colMinWidth[cellInfo.col + n8];
                    n += this.colMaxWidth[cellInfo.col + n8];
                    ++n8;
                }
                if (n2 < n4) {
                    if (n2 > 0) {
                        if (n >= n4) {
                            int n9 = n4 - n2;
                            int n10 = n - n2;
                            n8 = 0;
                            while (n8 < n5) {
                                int n11 = this.colMinWidth[cellInfo.col + n8];
                                int n12 = this.colMaxWidth[cellInfo.col + n8];
                                if (n10 > 0) {
                                    int n13 = cellInfo.col + n8;
                                    this.colMinWidth[n13] = this.colMinWidth[n13] + (n12 - n11) * n9 / n10;
                                }
                                n10 += -n12 + n11;
                                n9 += -this.colMinWidth[cellInfo.col + n8] + n11;
                                ++n8;
                            }
                        } else {
                            n8 = 0;
                            while (n8 < n5) {
                                this.colMinWidth[cellInfo.col + n8] = this.colMaxWidth[cellInfo.col + n8] * n4 / n;
                                ++n8;
                            }
                        }
                    } else {
                        n4 /= n5;
                        n8 = 0;
                        while (n8 < n5) {
                            this.colMinWidth[cellInfo.col + n8] = n4;
                            ++n8;
                        }
                    }
                }
                if (n < n3) {
                    if (n > 0) {
                        n8 = 0;
                        while (n8 < n5) {
                            int n14 = cellInfo.col + n8;
                            this.colMaxWidth[n14] = this.colMaxWidth[n14] + (n3 - n) * this.colMaxWidth[cellInfo.col + n8] / n;
                            ++n8;
                        }
                    } else {
                        n3 /= n5;
                        n8 = 0;
                        while (n8 < n5) {
                            this.colMaxWidth[cellInfo.col + n8] = n3;
                            ++n8;
                        }
                    }
                }
            }
            ++n7;
        }
        n3 = n4 = this.border_size * 2 + this.cell_spacing * (this.numCols + 1) + this.cell_padding * 2 * this.numCols + (this.border_size > 0 ? this.numCols - 1 : 0);
        n7 = 0;
        while (n7 < this.numCols) {
            n4 += this.colMinWidth[n7];
            n3 += this.colMaxWidth[n7];
            ++n7;
        }
        if (this.table_width > 0 && n4 <= this.table_width) {
            if (this.table_width >= n3) {
                int n15 = this.border_size * 2 + this.cell_spacing * (this.numCols + 1) + this.cell_padding * 2 * this.numCols + (this.border_size > 0 ? this.numCols - 1 : 0);
                n5 = this.table_width - n15;
                n2 = n3 - n15;
                n7 = 0;
                while (n7 < this.numCols) {
                    n = this.colMaxWidth[n7];
                    if (n2 > 0) {
                        this.colMaxWidth[n7] = n * n5 / n2;
                        this.colMinWidth[n7] = this.colMaxWidth[n7];
                    }
                    n5 -= this.colMaxWidth[n7];
                    n2 -= n;
                    ++n7;
                }
            } else {
                int n16 = this.table_width - n4;
                n5 = n3 - n4;
                n7 = 0;
                while (n7 < this.numCols) {
                    n2 = this.colMinWidth[n7];
                    n = this.colMaxWidth[n7];
                    if (n5 > 0) {
                        int n17 = n7;
                        this.colMinWidth[n17] = this.colMinWidth[n17] + (n - n2) * n16 / n5;
                        this.colMaxWidth[n7] = this.colMinWidth[n7];
                    }
                    n5 += -n + n2;
                    n16 += -this.colMaxWidth[n7] + n2;
                    ++n7;
                }
            }
            n4 = n3 = this.table_width;
        }
        this.tableMinMax = new Dimension(n4, n3);
        return this.tableMinMax;
    }

    void layout(int n, boolean bl) {
        int n2;
        CellInfo cellInfo;
        int n3;
        int n4;
        int n5;
        int n6;
        if (bl) {
            return;
        }
        if (this.tableMinMax == null) {
            this.minMaxLayout();
        }
        int n7 = 0;
        while (n7 < this.numCols) {
            this.colWidth[n7] = 0;
            this.colCoord[n7] = 0;
            ++n7;
        }
        n7 = 0;
        while (n7 < this.numRows) {
            this.rowHeight[n7] = 0;
            this.rowCoord[n7] = 0;
            ++n7;
        }
        if (this.table_width < 0) {
            n = -n * this.table_width / 100;
        } else if (this.table_width > 0) {
            n = this.table_width;
        }
        if (n >= this.tableMinMax.height) {
            if (this.table_width == 0 || n == this.tableMinMax.height) {
                n7 = 0;
                while (n7 < this.numCols) {
                    this.colWidth[n7] = this.colMaxWidth[n7];
                    ++n7;
                }
            } else {
                n6 = this.border_size * 2 + this.cell_spacing * (this.numCols + 1) + this.cell_padding * 2 * this.numCols + (this.border_size > 0 ? this.numCols - 1 : 0);
                n5 = n - n6;
                n4 = this.tableMinMax.height - n6;
                n7 = 0;
                while (n7 < this.numCols) {
                    this.colWidth[n7] = n4 <= 0 ? this.colMaxWidth[n7] : this.colMaxWidth[n7] * n5 / n4;
                    n5 -= this.colWidth[n7];
                    n4 -= this.colMaxWidth[n7];
                    ++n7;
                }
            }
        } else if (n <= this.tableMinMax.width) {
            n7 = 0;
            while (n7 < this.numCols) {
                this.colWidth[n7] = this.colMinWidth[n7];
                ++n7;
            }
        } else {
            n6 = n - this.tableMinMax.width;
            n5 = this.tableMinMax.height - this.tableMinMax.width;
            n7 = 0;
            while (n7 < this.numCols) {
                n4 = this.colMinWidth[n7];
                n3 = this.colMaxWidth[n7];
                this.colWidth[n7] = n5 > 0 ? n4 + (n3 - n4) * n6 / n5 : this.colMinWidth[n7];
                n5 += -n3 + n4;
                n6 += -this.colWidth[n7] + n4;
                ++n7;
            }
        }
        n6 = this.cellInfos.size();
        n7 = 0;
        while (n7 < n6) {
            cellInfo = (CellInfo)this.cellInfos.elementAt(n7);
            n5 = cellInfo.colspan;
            if (cellInfo.col + n5 > this.numCols) {
                n5 = this.numCols - cellInfo.col;
            }
            n4 = 0;
            n2 = 0;
            while (n2 < n5) {
                n4 += this.colWidth[cellInfo.col + n2];
                ++n2;
            }
            cellInfo.cell.layout(n4, n4);
            ++n7;
        }
        n7 = 0;
        while (n7 < n6) {
            cellInfo = (CellInfo)this.cellInfos.elementAt(n7);
            n5 = cellInfo.rowspan;
            if (cellInfo.row + n5 > this.numRows) {
                n5 = this.numRows - cellInfo.row;
            }
            if (n5 <= 1) {
                n4 = cellInfo.cell.size().height;
                if (cellInfo.set_height > n4) {
                    n4 = cellInfo.set_height;
                }
                if (n4 > this.rowHeight[cellInfo.row]) {
                    this.rowHeight[cellInfo.row] = n4;
                }
            }
            ++n7;
        }
        n7 = 0;
        while (n7 < n6) {
            cellInfo = (CellInfo)this.cellInfos.elementAt(n7);
            n5 = cellInfo.rowspan;
            if (cellInfo.row + n5 > this.numRows) {
                n5 = this.numRows - cellInfo.row;
            }
            if (n5 > 1) {
                n4 = cellInfo.cell.size().height;
                if (cellInfo.set_height > n4) {
                    n4 = cellInfo.set_height;
                }
                n3 = 0;
                n2 = 0;
                while (n2 < n5) {
                    n3 += this.rowHeight[cellInfo.row + n2];
                    ++n2;
                }
                if (n3 < n4) {
                    if (n3 > 0) {
                        n2 = 0;
                        while (n2 < n5) {
                            int n8 = cellInfo.row + n2;
                            this.rowHeight[n8] = this.rowHeight[n8] + (n4 - n3) * this.rowHeight[cellInfo.row + n2] / n3;
                            ++n2;
                        }
                    } else {
                        n4 /= n5;
                        n2 = 0;
                        while (n2 < n5) {
                            int n9 = cellInfo.row + n2;
                            this.rowHeight[n9] = this.rowHeight[n9] + n4;
                            ++n2;
                        }
                    }
                }
            }
            ++n7;
        }
        n5 = this.border_size + this.cell_spacing;
        n7 = 0;
        while (n7 < this.numCols) {
            this.colCoord[n7] = n5;
            int n10 = n7;
            this.colWidth[n10] = this.colWidth[n10] + (this.cell_spacing + this.cell_padding * 2 + (this.border_size > 0 ? 1 : 0));
            n5 += this.colWidth[n7];
            ++n7;
        }
        n5 += this.border_size - (this.border_size > 0 ? 1 : 0);
        this.capHeight = 0;
        if (this.caption != null) {
            this.caption.cell.layout(n5 - this.cell_padding * 2, n5 - this.cell_padding * 2);
            this.capHeight = this.caption.cell.size().height + this.cell_spacing + this.cell_padding * 2;
        }
        n4 = this.border_size + this.cell_spacing;
        if (this.capVAlign == 0) {
            this.capY = 0;
            n4 += this.capHeight;
        }
        n7 = 0;
        while (n7 < this.numRows) {
            this.rowCoord[n7] = n4;
            int n11 = n7;
            this.rowHeight[n11] = this.rowHeight[n11] + (this.cell_spacing + this.cell_padding * 2 + (this.border_size > 0 ? 1 : 0));
            n4 += this.rowHeight[n7];
            ++n7;
        }
        n4 += this.border_size - (this.border_size > 0 ? 1 : 0);
        if (this.capVAlign != 0) {
            this.capY = n4;
            n4 += this.capHeight;
        }
        this.resize(n5, n4);
        n7 = 0;
        while (n7 < n6) {
            cellInfo = (CellInfo)this.cellInfos.elementAt(n7);
            n4 = -this.cell_spacing - this.cell_padding * 2 - (this.border_size > 0 ? 1 : 0);
            n2 = 0;
            while (n2 < cellInfo.rowspan) {
                if (cellInfo.row + n2 >= this.numRows) break;
                n4 += this.rowHeight[cellInfo.row + n2];
                ++n2;
            }
            n3 = cellInfo.cell.size().height;
            cellInfo.add_y = cellInfo.valign == 2 ? (n4 - n3) / 2 : (cellInfo.valign == 1 ? n4 - n3 : 0);
            ++n7;
        }
    }

    void move(int n, int n2) {
        super.move(n, n2);
        int n3 = this.cellInfos.size();
        int n4 = 0;
        while (n4 < n3) {
            CellInfo cellInfo = (CellInfo)this.cellInfos.elementAt(n4);
            int n5 = this.colCoord[cellInfo.col] + n + this.cell_padding;
            int n6 = this.rowCoord[cellInfo.row] + n2 + this.cell_padding;
            cellInfo.cell.translate(n5, n6 + cellInfo.add_y);
            ++n4;
        }
        if (this.caption != null) {
            this.caption.cell.translate(n + this.cell_padding, n2 + this.cell_padding + this.capY);
        }
    }

    void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        CellInfo cellInfo;
        int n5;
        Rectangle rectangle = graphics.getClipBounds();
        int n6 = this.cellInfos.size();
        graphics.setColor(this.color);
        if (this.capVAlign == 0) {
            n5 = 0;
            while (n5 < this.border_size) {
                graphics.draw3DRect(n5, this.capHeight + n5, this.width - n5 * 2 - 1, this.height - this.capHeight - n5 * 2 - 1, true);
                ++n5;
            }
        } else {
            n5 = 0;
            while (n5 < this.border_size) {
                graphics.draw3DRect(n5, n5, this.width - n5 * 2 - 1, this.height - this.capHeight - n5 * 2 - 1, true);
                ++n5;
            }
        }
        n5 = 0;
        while (n5 < n6) {
            cellInfo = (CellInfo)this.cellInfos.elementAt(n5);
            if (!cellInfo.cell.isEmpty()) {
                n4 = this.colCoord[cellInfo.col];
                n3 = this.rowCoord[cellInfo.row];
                n2 = -this.cell_spacing - (this.border_size > 0 ? 1 : 0);
                n = -this.cell_spacing - (this.border_size > 0 ? 1 : 0);
                int n7 = 0;
                while (n7 < cellInfo.colspan) {
                    if (cellInfo.col + n7 >= this.numCols) break;
                    n2 += this.colWidth[cellInfo.col + n7];
                    ++n7;
                }
                n7 = 0;
                while (n7 < cellInfo.rowspan) {
                    if (cellInfo.row + n7 >= this.numRows) break;
                    n += this.rowHeight[cellInfo.row + n7];
                    ++n7;
                }
                if (rectangle.x <= n4 + n2 && rectangle.y <= n3 + n && n4 <= rectangle.x + rectangle.width && n3 <= rectangle.y + rectangle.height) {
                    if (cellInfo.bgColor != null) {
                        graphics.setColor(cellInfo.bgColor);
                        graphics.fillRect(n4, n3, n2, n);
                    }
                    graphics.setColor(this.color);
                    if (this.border_size > 0) {
                        graphics.draw3DRect(n4 - 1, n3 - 1, n2 + 1, n + 1, false);
                    }
                    graphics.translate(n4 += this.cell_padding, (n3 += this.cell_padding) + cellInfo.add_y);
                    cellInfo.cell.paint(graphics);
                    graphics.translate(-n4, -n3 - cellInfo.add_y);
                }
            }
            ++n5;
        }
        if (this.caption != null) {
            cellInfo = this.caption;
            n4 = 0;
            n3 = this.capY;
            n2 = cellInfo.cell.size().width;
            n = cellInfo.cell.size().height;
            if (rectangle.x > n4 + n2 || rectangle.y > n3 + n || n4 > rectangle.x + rectangle.width || n3 > rectangle.y + rectangle.height) {
                return;
            }
            graphics.translate(n4 += this.cell_padding, (n3 += this.cell_padding) + cellInfo.add_y);
            cellInfo.cell.paint(graphics);
            graphics.translate(-n4, -n3 - cellInfo.add_y);
        }
    }

    Box mouseClicked(int n, int n2) {
        return this.mouseEvent(n, n2, 0);
    }

    Box mouseMoved(int n, int n2) {
        return this.mouseEvent(n, n2, 1);
    }

    void mouseDragged(int n, int n2) {
        this.mouseEvent(n, n2, 2);
    }

    private Box mouseEvent(int n, int n2, int n3) {
        int n4 = this.cellInfos.size();
        if (n3 != 2) {
            this.startDragCell = -1;
        }
        int n5 = 0;
        while (n5 <= n4) {
            int n6;
            int n7;
            CellInfo cellInfo;
            if (n5 < n4) {
                cellInfo = (CellInfo)this.cellInfos.elementAt(n5);
                n7 = this.colCoord[cellInfo.col] + this.cell_padding;
                n6 = this.rowCoord[cellInfo.row] + this.cell_padding + cellInfo.add_y;
            } else {
                if (this.caption == null) break;
                cellInfo = this.caption;
                n7 = this.cell_padding;
                n6 = this.capY + this.cell_padding;
            }
            int n8 = cellInfo.cell.size().width;
            int n9 = cellInfo.cell.size().height;
            if (n >= n7 && n < n7 + n8 && n2 >= n6 && n2 < n6 + n9) {
                if (n3 == 0) {
                    return cellInfo.cell.mouseClicked(n - n7, n2 - n6);
                }
                if (n3 == 1) {
                    return cellInfo.cell.mouseMoved(n - n7, n2 - n6);
                }
                if (n5 == n4) {
                    return null;
                }
                if (this.startDragCell < 0) {
                    this.startDragCell = this.prevDragCell = n5;
                    cellInfo.cell.mouseDragged(n - n7, n2 - n6);
                    return null;
                }
                if (this.prevDragCell == n5) {
                    cellInfo.cell.mouseDragged(n - n7, n2 - n6);
                    return null;
                }
                CellInfo cellInfo2 = (CellInfo)this.cellInfos.elementAt(this.prevDragCell);
                if (this.startDragCell < n5 && this.startDragCell <= this.prevDragCell || this.startDragCell <= n5 && this.startDragCell < this.prevDragCell) {
                    if (this.prevDragCell < n5) {
                        if (this.prevDragCell == this.startDragCell) {
                            cellInfo2.cell.mouseDragged(cellInfo2.cell.size().width - 1, cellInfo2.cell.size().height - 1);
                            ++this.prevDragCell;
                        }
                        int n10 = this.prevDragCell;
                        while (n10 < n5) {
                            cellInfo2 = (CellInfo)this.cellInfos.elementAt(n10);
                            cellInfo2.cell.setSelected(true);
                            ++n10;
                        }
                        cellInfo.cell.setDragStart(true);
                        cellInfo.cell.mouseDragged(n - n7, n2 - n6);
                    } else if (this.startDragCell == n5) {
                        cellInfo2.cell.setSelected(false);
                        int n11 = n5 + 1;
                        while (n11 < this.prevDragCell) {
                            cellInfo2 = (CellInfo)this.cellInfos.elementAt(n11);
                            cellInfo2.cell.setSelected(false);
                            ++n11;
                        }
                        cellInfo.cell.mouseDragged(n - n7, n2 - n6);
                    } else if (this.startDragCell < n5) {
                        cellInfo2.cell.setSelected(false);
                        int n12 = n5;
                        while (n12 < this.prevDragCell) {
                            cellInfo2 = (CellInfo)this.cellInfos.elementAt(n12);
                            cellInfo2.cell.setSelected(false);
                            ++n12;
                        }
                        cellInfo.cell.setDragStart(true);
                        cellInfo.cell.mouseDragged(n - n7, n2 - n6);
                    }
                } else if (this.startDragCell > n5 && this.startDragCell >= this.prevDragCell || this.startDragCell >= n5 && this.startDragCell > this.prevDragCell) {
                    if (this.prevDragCell > n5) {
                        if (this.prevDragCell == this.startDragCell) {
                            cellInfo2.cell.mouseDragged(0, 0);
                            --this.prevDragCell;
                        }
                        int n13 = this.prevDragCell;
                        while (n13 > n5) {
                            cellInfo2 = (CellInfo)this.cellInfos.elementAt(n13);
                            cellInfo2.cell.setSelected(true);
                            --n13;
                        }
                        cellInfo.cell.setDragStart(false);
                        cellInfo.cell.mouseDragged(n - n7, n2 - n6);
                    } else if (this.startDragCell == n5) {
                        int n14 = this.prevDragCell;
                        while (n14 < n5) {
                            cellInfo2 = (CellInfo)this.cellInfos.elementAt(n14);
                            cellInfo2.cell.setSelected(false);
                            ++n14;
                        }
                        cellInfo.cell.mouseDragged(n - n7, n2 - n6);
                    } else if (this.startDragCell > n5) {
                        int n15 = this.prevDragCell;
                        while (n15 < n5) {
                            cellInfo2 = (CellInfo)this.cellInfos.elementAt(n15);
                            cellInfo2.cell.setSelected(false);
                            ++n15;
                        }
                        cellInfo.cell.setDragStart(false);
                        cellInfo.cell.mouseDragged(n - n7, n2 - n6);
                    }
                } else if (this.startDragCell > this.prevDragCell && this.startDragCell < n5) {
                    int n16 = this.prevDragCell;
                    while (n16 < this.startDragCell) {
                        cellInfo2 = (CellInfo)this.cellInfos.elementAt(n16);
                        cellInfo2.cell.setSelected(false);
                        ++n16;
                    }
                    cellInfo2 = (CellInfo)this.cellInfos.elementAt(this.startDragCell);
                    cellInfo2.cell.mouseDragged(cellInfo2.cell.size().width - 1, cellInfo2.cell.size().height - 1);
                    int n17 = this.startDragCell + 1;
                    while (n17 < n5 - 1) {
                        cellInfo2 = (CellInfo)this.cellInfos.elementAt(n17);
                        cellInfo2.cell.setSelected(true);
                        ++n17;
                    }
                    cellInfo.cell.setDragStart(true);
                    cellInfo.cell.mouseDragged(n - n7, n2 - n6);
                } else if (this.startDragCell < this.prevDragCell && this.startDragCell > n5) {
                    int n18 = this.prevDragCell;
                    while (n18 > this.startDragCell) {
                        cellInfo2 = (CellInfo)this.cellInfos.elementAt(n18);
                        cellInfo2.cell.setSelected(false);
                        --n18;
                    }
                    cellInfo2 = (CellInfo)this.cellInfos.elementAt(this.startDragCell);
                    cellInfo2.cell.mouseDragged(0, 0);
                    int n19 = n5 + 1;
                    while (n19 < this.startDragCell) {
                        cellInfo2 = (CellInfo)this.cellInfos.elementAt(n19);
                        cellInfo2.cell.setSelected(true);
                        ++n19;
                    }
                    cellInfo.cell.setDragStart(false);
                    cellInfo.cell.mouseDragged(n - n7, n2 - n6);
                }
                this.prevDragCell = n5;
                return null;
            }
            ++n5;
        }
        return null;
    }

    void selectTo(boolean bl) {
        CellInfo cellInfo = bl ? (CellInfo)this.cellInfos.elementAt(this.cellInfos.size() - 1) : (CellInfo)this.cellInfos.elementAt(0);
        int n = this.colCoord[cellInfo.col] + this.cell_padding;
        int n2 = this.rowCoord[cellInfo.row] + this.cell_padding + cellInfo.add_y;
        int n3 = cellInfo.cell.size().width;
        int n4 = cellInfo.cell.size().height;
        if (bl) {
            this.mouseEvent(n + n3 - 1, n2 + n4 - 1, 2);
            return;
        }
        this.mouseEvent(n, n2, 2);
    }

    void setSelected(boolean bl) {
        super.setSelected(bl);
        int n = this.cellInfos.size();
        int n2 = 0;
        while (n2 < n) {
            CellInfo cellInfo = (CellInfo)this.cellInfos.elementAt(n2);
            cellInfo.cell.setSelected(bl);
            cellInfo.cell.mouseMoved(-1, -1);
            ++n2;
        }
        if (this.caption != null) {
            this.caption.cell.setSelected(bl);
        }
        this.startDragCell = -1;
    }

    public void activeShow() {
        int n = this.cellInfos.size();
        int n2 = 0;
        while (n2 < n) {
            CellInfo cellInfo = (CellInfo)this.cellInfos.elementAt(n2);
            cellInfo.cell.activeShow();
            ++n2;
        }
        if (this.caption != null) {
            this.caption.cell.activeShow();
        }
    }

    public void activeHide() {
        int n = this.cellInfos.size();
        int n2 = 0;
        while (n2 < n) {
            CellInfo cellInfo = (CellInfo)this.cellInfos.elementAt(n2);
            cellInfo.cell.activeHide();
            ++n2;
        }
        if (this.caption != null) {
            this.caption.cell.activeHide();
        }
    }

    public void activeInterrupt() {
        int n = this.cellInfos.size();
        int n2 = 0;
        while (n2 < n) {
            CellInfo cellInfo = (CellInfo)this.cellInfos.elementAt(n2);
            cellInfo.cell.activeInterrupt();
            ++n2;
        }
        if (this.caption != null) {
            this.caption.cell.activeInterrupt();
        }
    }

    String getSelectedText() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.cellInfos.size();
        int n2 = 0;
        while (n2 < n) {
            CellInfo cellInfo = (CellInfo)this.cellInfos.elementAt(n2);
            string = DocContainer.doGetSelectedText(cellInfo.cell.getBoxListHead());
            if (string.length() > 1) {
                stringBuffer.append(String.valueOf(string) + "\n");
            }
            ++n2;
        }
        if (this.caption != null && (string = DocContainer.doGetSelectedText(this.caption.cell.getBoxListHead())).length() > 1) {
            stringBuffer.append(String.valueOf(string) + "\n");
        }
        return stringBuffer.toString();
    }

    void setColor(Color color) {
        if (color.equals(Color.white)) {
            color = color.darker().darker();
        }
        if (color.equals(Color.black)) {
            color = Color.white;
        }
        super.setColor(color);
    }

    Box getAnchorBox(String string) {
        Box box = super.getAnchorBox(string);
        if (box != null) {
            return box;
        }
        int n = this.cellInfos.size();
        int n2 = 0;
        while (n2 < n && box == null) {
            CellInfo cellInfo = (CellInfo)this.cellInfos.elementAt(n2);
            box = cellInfo.cell.getAnchorBox(string);
            ++n2;
        }
        if (box == null && this.caption != null) {
            box = this.caption.cell.getAnchorBox(string);
        }
        return box;
    }

    Point getSearchPosition() {
        return this.searchPosition;
    }

    boolean search(String[] stringArray) {
        int n;
        Box box = null;
        if (this.prevSearchBox != null) {
            box = this.prevSearchBox;
            if (box instanceof BoxWord) {
                box = box.getNext();
            }
            if ((box = DocContainer.doSearch(box, stringArray)) == null) {
                ++this.prevSearchCell;
                this.prevSearchBox = null;
            }
        } else {
            this.prevSearchCell = 0;
        }
        if (box == null) {
            int n2 = this.cellInfos.size();
            n = this.prevSearchCell;
            while (n < n2) {
                CellInfo cellInfo = (CellInfo)this.cellInfos.elementAt(n);
                box = DocContainer.doSearch(cellInfo.cell.getBoxListHead(), stringArray);
                if (box != null) {
                    this.prevSearchCell = n;
                    break;
                }
                ++n;
            }
        }
        if (box != null) {
            this.prevSearchBox = box;
            if (box instanceof BoxWord) {
                this.searchPosition = box.location();
                n = 0;
                while (n < stringArray.length && box != null) {
                    box.setSelected(true);
                    box = box.getNext();
                    ++n;
                }
            } else if (box instanceof BoxTable) {
                this.searchPosition = ((BoxTable)box).getSearchPosition();
            }
            return true;
        }
        return false;
    }

    int findPageBreak(int n) {
        n -= this.location().y;
        int n2 = 0;
        while (n2 < this.numRows) {
            if (this.rowCoord[n2] + this.rowHeight[n2] > n) break;
            ++n2;
        }
        if (n2 > 0 && n2 < this.numRows) {
            return this.rowCoord[n2] + this.location().y;
        }
        return -1;
    }
}

