/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.ActiveBox;
import ice.htmlbrowser.Box;
import ice.htmlbrowser.BoxImage;
import ice.htmlbrowser.BoxLineBreak;
import ice.htmlbrowser.BoxTable;
import ice.htmlbrowser.BoxWord;
import ice.htmlbrowser.BrowserURLLoader;
import ice.htmlbrowser.DocumentFrame;
import ice.htmlbrowser.FontInfo;
import ice.htmlbrowser.FrameInfo;
import ice.htmlbrowser.ImageMap;
import ice.htmlbrowser.Parser;
import ice.htmlbrowser.ProcessURL;
import ice.htmlbrowser.Tag;
import ice.htmlbrowser.VisDocument;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

class DocContainer
extends Panel
implements MouseListener,
MouseMotionListener {
    private boolean started = false;
    private boolean ended = true;
    private Box prevPageBreakBox;
    private Box prevSearchBox;
    private ProcessURL loader;
    private Parser parser;
    private FontInfo fi;
    private Image backImage;
    private boolean backImageComplete = false;
    private Color selColor = Color.white;
    private Color selBackColor = Color.black;
    private Box boxListHead;
    private Box boxListTail;
    private int boxListCount;
    private Vector ImageMaps;
    private MediaTracker tracker;
    private Vector imagesCache;
    private Vector compBoxes;
    private Vector compComponents;
    private Box sel_box;
    private VisDocument vis_doc;
    private DocumentFrame docFrame;
    private FrameInfo frame;
    private int newScrollX;
    private int newScrollY;
    private int scrollX;
    private int scrollY;
    private int mouseScrollX = -10000;
    private int mouseScrollY;
    private Stack Tables;
    private BoxTable box_table;
    private Box last_box;
    private Cursor cursorLink;
    private Cursor cursorNormal;
    private Cursor cursorWait;
    private Cursor cursorDefault;
    private boolean parsingDone = false;
    private Object parse_lock = new Object();

    DocContainer(FrameInfo frameInfo, DocumentFrame documentFrame) {
        this.setLayout(null);
        this.frame = frameInfo;
        this.docFrame = documentFrame;
        this.fi = frameInfo.getFontInfo();
        this.cursorLink = new Cursor(12);
        this.cursorNormal = new Cursor(0);
        this.cursorWait = new Cursor(3);
        this.cursorDefault = this.cursorNormal;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.htmlBeginDocument();
    }

    void htmlBeginDocument() {
        if (this.started || !this.ended) {
            return;
        }
        this.started = true;
        this.ended = false;
        this.boxListHead = null;
        this.boxListTail = null;
        this.boxListCount = 0;
        this.last_box = null;
        this.sel_box = null;
        this.backImage = null;
        this.backImageComplete = false;
        this.ImageMaps = new Vector();
        this.Tables = new Stack();
        this.box_table = null;
        this.compBoxes = new Vector();
        this.compComponents = new Vector();
        this.tracker = new MediaTracker(this);
        this.imagesCache = new Vector();
        this.newScrollY = 0;
        this.newScrollX = 0;
        this.scrollY = 0;
        this.scrollX = 0;
        this.parser = new Parser(this.frame, this);
        this.vis_doc = new VisDocument(this.docFrame, this.frame.getMarginWidth(), this.frame.getMarginHeight());
        this.loader = null;
        this.setParsingDone(true, false);
    }

    void htmlEndDocument() {
        Object object;
        if (!this.started || this.ended) {
            return;
        }
        this.started = false;
        this.ended = true;
        if (this.backImage != null && this.backImageComplete) {
            this.backImageComplete = false;
            this.backImage.flush();
        }
        int n = 0;
        while (n < this.imagesCache.size()) {
            object = (Image)this.imagesCache.elementAt(n);
            this.tracker.removeImage((Image)object);
            ((Image)object).flush();
            ++n;
        }
        this.imagesCache.removeAllElements();
        if (this.loader != null) {
            this.loader.stopThread();
            this.loader = null;
        }
        this.vis_doc.stopThread();
        this.setParsingDone(true, false);
        this.parser.stopThread();
        object = this.boxListHead;
        while (object != null) {
            if (object instanceof ActiveBox) {
                ((ActiveBox)object).activeHide();
            }
            object = ((Box)object).getNext();
        }
        this.removeAll();
    }

    void htmlWait(boolean bl) {
        while (!this.isParsingDone()) {
            Object object = this.parse_lock;
            synchronized (object) {
                try {
                    this.parse_lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (bl) {
            try {
                this.tracker.waitForAll();
                return;
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    void htmlAppendReader(Reader reader, String string, int n) {
        try {
            this.setParsingDone(false, false);
            Tag tag = new Tag(string.replace(';', ' '));
            String string2 = tag.getStringParam("charset");
            if (string2 == null) {
                string2 = this.frame.getEncoding();
            }
            this.parser.setLexReader(reader, string, null, n, string2);
        }
        catch (IOException iOException) {
            this.setParsingDone(true, false);
        }
        this.vis_doc.prepareFullLayout();
        this.doLayout();
    }

    void htmlAppendURL(URL uRL, String string) {
        this.setParsingDone(false, false);
        this.cursorDefault = this.cursorWait;
        if (this.getCursor() != this.cursorDefault) {
            this.setCursor(this.cursorDefault);
        }
        this.loader = new ProcessURL(this.frame, this, this.parser, uRL, string);
        if (this.isVisible()) {
            this.loader.startThread();
        }
    }

    void htmlInterrupt() {
        if (this.loader != null) {
            this.loader.stopThread();
            this.loader = null;
        }
        this.parser.stopParsing();
        this.setParsingDone(true, false);
        Box box = this.boxListHead;
        while (box != null) {
            if (box instanceof ActiveBox) {
                ((ActiveBox)((Object)box)).activeInterrupt();
            }
            box = box.getNext();
        }
    }

    boolean isParsingDone() {
        return this.parsingDone;
    }

    void setParsingDone(boolean bl, boolean bl2) {
        this.parsingDone = bl;
        if (this.parsingDone) {
            this.cursorDefault = this.cursorNormal;
            if (this.getCursor() != this.cursorDefault) {
                this.setCursor(this.cursorDefault);
            }
            Object object = this.vis_doc;
            synchronized (object) {
                this.vis_doc.notifyAll();
            }
            object = this.parse_lock;
            synchronized (object) {
                this.parse_lock.notifyAll();
            }
            if (bl2) {
                object = this.boxListHead;
                while (object != null) {
                    if (object instanceof ActiveBox) {
                        ((ActiveBox)object).activeShow();
                    }
                    object = ((Box)object).getNext();
                }
            }
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this.loader != null) {
            this.loader.startThread();
        }
    }

    private void setLinkCursor() {
        if (this.getCursor() != this.cursorLink) {
            this.setCursor(this.cursorLink);
        }
    }

    private void setDefaultCursor() {
        if (this.getCursor() != this.cursorDefault) {
            this.setCursor(this.cursorDefault);
        }
    }

    void redirectTo(BoxTable boxTable) {
        if (boxTable == null) {
            if (!this.Tables.empty()) {
                this.box_table = (BoxTable)this.Tables.pop();
                return;
            }
            this.box_table = null;
            return;
        }
        this.Tables.push(this.box_table);
        this.box_table = boxTable;
    }

    BoxTable getRedirect() {
        return this.box_table;
    }

    void addBox(Box box) {
        if (this.box_table != null) {
            this.box_table.addBox(box);
        } else if (this.boxListHead == null) {
            this.boxListHead = this.boxListTail = box;
            this.boxListCount = 1;
            if (this.isVisible()) {
                this.vis_doc.prepareFullLayout();
                this.doLayout();
            }
        } else {
            this.boxListTail.setNext(box);
            this.boxListTail = box;
            ++this.boxListCount;
            if ((this.boxListCount & 0x100) == 256) {
                VisDocument visDocument = this.vis_doc;
                synchronized (visDocument) {
                    this.vis_doc.notifyAll();
                }
            }
        }
        this.last_box = box;
    }

    Box lastBox() {
        return this.last_box;
    }

    void setAWTComponent(Box box, Component component) {
        if (component != null) {
            this.add(component);
            this.compBoxes.addElement(box);
            this.compComponents.addElement(component);
            component.setLocation(box.location().x - this.scrollX, box.location().y - this.scrollY);
        }
    }

    ImageMap newImageMap(String string) {
        try {
            URL uRL = new URL(this.getDocumentBase(), "#" + string);
            ImageMap imageMap = new ImageMap(uRL);
            this.ImageMaps.addElement(imageMap);
            return imageMap;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    ImageMap getImageMap(String string) {
        URL uRL;
        try {
            uRL = new URL(this.getDocumentBase(), string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        int n = this.ImageMaps.size();
        int n2 = 0;
        while (n2 < n) {
            ImageMap imageMap = (ImageMap)this.ImageMaps.elementAt(n2);
            if (uRL.equals(imageMap.getURL())) {
                return imageMap;
            }
            ++n2;
        }
        return null;
    }

    void setBackgroundImage(String string) {
        try {
            URL uRL = new URL(this.getDocumentBase(), string);
            BrowserURLLoader browserURLLoader = new BrowserURLLoader(uRL);
            this.backImage = browserURLLoader.getImage();
            this.backImageComplete = false;
            this.registerImage(this.backImage);
            this.prepareImage(this.backImage, this);
            return;
        }
        catch (Exception exception) {
            this.backImage = null;
            return;
        }
    }

    Image getBackgroundImage() {
        return this.backImage;
    }

    void registerImage(Image image) {
        this.imagesCache.addElement(image);
        this.tracker.addImage(image, 0);
    }

    void doFullLayout() {
        this.vis_doc.prepareFullLayout();
        this.doLayout();
    }

    public void doLayout() {
        super.doLayout();
        int n = this.docFrame.getViewportSize().width;
        this.vis_doc.doLayout(this.boxListHead, this.boxListCount, n, n);
    }

    private Dimension visSize() {
        return this.docFrame.getViewportSize();
    }

    Dimension getHTMLDocumentSize() {
        Dimension dimension = new Dimension(this.vis_doc.docSize());
        return dimension;
    }

    URL getDocumentBase() {
        return this.frame.getDocumentBase();
    }

    Font getFont(int n) {
        return this.fi.getFont(n);
    }

    public FontMetrics getFontMetrics(int n) {
        return this.fi.getFontMetrics(n);
    }

    Color getSelColor() {
        return this.selColor;
    }

    Color getSelBackColor() {
        return this.selBackColor;
    }

    Point getAnchorPosition(URL uRL) {
        if (!uRL.sameFile(this.getDocumentBase())) {
            return null;
        }
        String string = uRL.getRef();
        if (string == null) {
            return null;
        }
        Box box = null;
        Box box2 = this.boxListHead;
        while (box2 != null && box == null) {
            box = box2.getAnchorBox(string);
            box2 = box2.getNext();
        }
        if (box != null) {
            return box.location();
        }
        return new Point(0, 0);
    }

    void moveComponentBoxes() {
        int n = this.compBoxes.size();
        int n2 = 0;
        while (n2 < n) {
            Box box = (Box)this.compBoxes.elementAt(n2);
            Component component = (Component)this.compComponents.elementAt(n2);
            component.setLocation(box.location().x - this.scrollX, box.location().y - this.scrollY);
            ++n2;
        }
    }

    Point getScrollPosition() {
        return new Point(this.scrollX, this.scrollY);
    }

    void scrollTo(int n, int n2) {
        if (this.docFrame.isScrollPane()) {
            return;
        }
        if (this.scrollX != n || this.scrollY != n2) {
            this.newScrollX = n;
            this.newScrollY = n2;
            this.repaint();
        }
    }

    void scrollJumpTo(int n, int n2) {
        if (this.docFrame.isScrollPane()) {
            return;
        }
        this.newScrollX = this.scrollX = n;
        this.newScrollY = this.scrollY = n2;
        this.repaint();
        this.moveComponentBoxes();
        this.frame.passScrollPosition();
    }

    public void update(Graphics graphics) {
        if (this.docFrame.isScrollPane()) {
            this.paint(graphics);
            return;
        }
        int n = this.docFrame.getViewportSize().width;
        int n2 = this.docFrame.getViewportSize().height;
        boolean bl = false;
        if (this.newScrollY != this.scrollY) {
            if (this.newScrollY > this.scrollY) {
                int n3 = this.newScrollY - this.scrollY;
                if (n3 < n2) {
                    graphics.copyArea(0, n3, n, n2 - n3, 0, -n3);
                    graphics.setClip(new Rectangle(0, n2 - n3, n, n3));
                }
            } else {
                int n4 = this.scrollY - this.newScrollY;
                if (n4 < n2) {
                    graphics.copyArea(0, 0, n, n2 - n4, 0, n4);
                    graphics.setClip(new Rectangle(0, 0, n, n4));
                }
            }
            this.scrollY = this.newScrollY;
            bl = true;
        } else if (this.newScrollX != this.scrollX) {
            if (this.newScrollX > this.scrollX) {
                int n5 = this.newScrollX - this.scrollX;
                if (n5 < n) {
                    graphics.copyArea(n5, 0, n - n5, n2, -n5, 0);
                    graphics.setClip(new Rectangle(n - n5, 0, n5, n2));
                }
            } else {
                int n6 = this.scrollX - this.newScrollX;
                if (n6 < n) {
                    graphics.copyArea(0, 0, n - n6, n2, n6, 0);
                    graphics.setClip(new Rectangle(0, 0, n6, n2));
                }
            }
            this.scrollX = this.newScrollX;
            bl = true;
        }
        this.paint(graphics);
        if (bl) {
            this.moveComponentBoxes();
            this.frame.passScrollPosition();
        }
    }

    public void paint(Graphics graphics) {
        this.clearBackground(graphics);
        this.vis_doc.paint(graphics, this.scrollX, this.scrollY);
    }

    private void clearBackground(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        if (this.backImage != null && this.backImageComplete) {
            int n = this.backImage.getWidth(this);
            int n2 = this.backImage.getHeight(this);
            int n3 = (-this.scrollX - rectangle.x) % n + rectangle.x;
            int n4 = (-this.scrollY - rectangle.y) % n2 + rectangle.y;
            while (n4 < rectangle.y + rectangle.height) {
                int n5 = n3;
                while (n5 < rectangle.x + rectangle.width) {
                    graphics.drawImage(this.backImage, n5, n4, this.getBackground(), this);
                    n5 += n;
                }
                n4 += n2;
            }
            return;
        }
        try {
            if (rectangle != null) {
                graphics.clearRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                return;
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    public synchronized boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if (image == this.backImage && (n & 0x20) != 0) {
            this.backImage = this.tileImage(image);
            if (this.backImage != null) {
                this.backImageComplete = true;
            }
            this.repaint();
        }
        return (n & 0xE0) == 0;
    }

    private Image tileImage(Image image) {
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        if (n <= 0 || n2 <= 0) {
            return null;
        }
        if (n > 64 && n2 > 64) {
            return image;
        }
        int n3 = 1;
        int n4 = 1;
        if (n < 64) {
            n3 = 1 + 63 / n;
        }
        if (n2 < 64) {
            n4 = 1 + 63 / n2;
        }
        Image image2 = this.createImage(n3 * n, n4 * n2);
        Graphics graphics = image2.getGraphics();
        int n5 = 0;
        while (n5 < n4) {
            int n6 = 0;
            while (n6 < n3) {
                graphics.drawImage(image, n6 * n, n5 * n2, null);
                ++n6;
            }
            ++n5;
        }
        graphics.dispose();
        image.flush();
        return image2;
    }

    void repaintBox(Box box) {
        try {
            if (!this.isVisible()) {
                return;
            }
            Point point = box.location();
            Dimension dimension = box.size();
            int n = point.x - this.scrollX;
            int n2 = point.y - this.scrollY;
            if (n < this.docFrame.getViewportSize().width && n2 < this.docFrame.getViewportSize().height && n + dimension.width > 0 && n2 + dimension.height > 0) {
                Graphics graphics = this.getGraphics();
                graphics.setClip(n, n2, dimension.width, dimension.height);
                if (this.backImage != null || box instanceof BoxWord) {
                    this.clearBackground(graphics);
                }
                graphics.translate(n, n2);
                box.paint(graphics);
                graphics.dispose();
                return;
            }
        }
        catch (NullPointerException nullPointerException) {}
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        int n = color.getRed();
        n = Math.max(n, color.getGreen());
        n = Math.max(n, color.getBlue());
        if (n > 128) {
            this.selColor = Color.white;
            this.selBackColor = Color.black;
            return;
        }
        this.selColor = Color.black;
        this.selBackColor = Color.white;
    }

    int findPageBreak(int n, int n2) {
        if (n == 0 || this.prevPageBreakBox == null) {
            this.prevPageBreakBox = this.boxListHead;
        }
        Box box = this.prevPageBreakBox;
        int n3 = -1;
        int n4 = n;
        int n5 = -1;
        while (box != null) {
            Point point = box.location();
            Dimension dimension = box.size();
            if (n5 > point.x) {
                if (n3 > n4) {
                    n4 = n3;
                }
                n3 = -1;
            }
            if (point.y + dimension.height > n3 || n3 < 0) {
                n3 = point.y + dimension.height;
                if (n4 == n) {
                    n4 = n3;
                }
            }
            if (n3 > n + n2) {
                BoxTable boxTable;
                int n6;
                if (box instanceof BoxTable && (n6 = (boxTable = (BoxTable)box).findPageBreak(n + n2)) > n && n6 < n + n2) {
                    n4 = n6;
                    break;
                }
                if (n4 > n + n2 / 2) break;
            }
            n5 = point.x;
            box = box.getNext();
        }
        this.prevPageBreakBox = box;
        if (box == null || n4 < 0 || n4 > n + n2) {
            n4 = n + n2;
        }
        return n4;
    }

    String getSelectedText() {
        return DocContainer.doGetSelectedText(this.boxListHead);
    }

    static String doGetSelectedText(Box box) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        int n = -1;
        while (box != null) {
            if (box instanceof BoxTable) {
                stringBuffer.append(((BoxTable)box).getSelectedText());
                if (stringBuffer.length() > 1) {
                    bl = true;
                }
                bl2 = false;
            }
            if (box.isSelected()) {
                bl = true;
                if (!bl2 && (n > box.location().x || box instanceof BoxLineBreak)) {
                    stringBuffer.append("\n");
                    if (box instanceof BoxLineBreak && ((BoxLineBreak)box).getPara() == 2) {
                        stringBuffer.append("\n");
                    }
                    bl2 = true;
                }
                if (box instanceof BoxWord) {
                    stringBuffer.append(((BoxWord)box).getSelectedText());
                    bl2 = false;
                }
            } else if (bl) break;
            n = box.location().x;
            box = box.getNext();
        }
        return stringBuffer.toString();
    }

    static Box doSearch(Box box, String[] stringArray) {
        while (box != null) {
            if (!(box instanceof BoxWord) ? box instanceof BoxTable && ((BoxTable)box).search(stringArray) : DocContainer.doesMatch((BoxWord)box, stringArray)) break;
            box = box.getNext();
        }
        return box;
    }

    private static boolean doesMatch(BoxWord boxWord, String[] stringArray) {
        String string;
        if (stringArray.length == 1 && (string = boxWord.getSelectedText().trim().toLowerCase()).indexOf(stringArray[0]) >= 0) {
            return true;
        }
        int n = 0;
        while (n < stringArray.length) {
            string = boxWord.getSelectedText().trim().toLowerCase();
            if (n == 0 ? !string.endsWith(stringArray[n]) : (n == stringArray.length - 1 ? !string.startsWith(stringArray[n]) : !string.equals(stringArray[n]))) {
                return false;
            }
            if (boxWord.getNext() == null) {
                return false;
            }
            if (!(boxWord.getNext() instanceof BoxWord)) {
                return false;
            }
            boxWord = (BoxWord)boxWord.getNext();
            ++n;
        }
        return true;
    }

    int search(int n, String string) {
        this.selectAll(false);
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens() && n2 < stringArray.length) {
            stringArray[n2] = stringTokenizer.nextToken().trim().toLowerCase();
            ++n2;
        }
        if (n2 < 1) {
            return -1;
        }
        if (n <= 0 || this.prevSearchBox == null || this.prevSearchBox.hashCode() != n) {
            n = 0;
            this.prevSearchBox = null;
        }
        Box box = null;
        if (this.prevSearchBox != null) {
            box = this.prevSearchBox;
            if (box instanceof BoxWord) {
                box = box.getNext();
            }
            box = DocContainer.doSearch(box, stringArray);
        }
        if (box == null) {
            box = DocContainer.doSearch(this.boxListHead, stringArray);
        }
        if (box != null) {
            this.prevSearchBox = box;
            Point point = box.location();
            if (box instanceof BoxWord) {
                n2 = 0;
                while (n2 < stringArray.length && box != null) {
                    box.setSelected(true);
                    box = box.getNext();
                    ++n2;
                }
            } else if (box instanceof BoxTable) {
                point = ((BoxTable)box).getSearchPosition();
            }
            this.docFrame.setScrollPosition(point.x, point.y);
            return this.prevSearchBox.hashCode();
        }
        return -1;
    }

    private void selectAll(boolean bl) {
        Box box = this.boxListHead;
        while (box != null) {
            box.setSelected(bl);
            box = box.getNext();
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        this.frame.processEvent(mouseEvent);
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
        this.frame.processEvent(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n;
        if (this.mouseScrollX != -10000) {
            this.mouseScrollX = -10000;
            return;
        }
        int n2 = mouseEvent.getX() + this.scrollX;
        Box box = this.vis_doc.mouseClicked(n2, n = mouseEvent.getY() + this.scrollY);
        if (box != null && box.getLink() != null) {
            this.frame.passMouseOverLink(4, box.getLink(), box.getLinkTargetFrame(), box.getOutputString(), mouseEvent);
            this.frame.passMouseOverLink(1, box.getLink(), box.getLinkTargetFrame(), box.getOutputString(), mouseEvent);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0xC) == 0) {
            this.selectAll(false);
        }
        this.mouseScrollX = -10000;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n;
        int n2 = mouseEvent.getX() + this.scrollX;
        Box box = this.vis_doc.mouseMoved(n2, n = mouseEvent.getY() + this.scrollY);
        if (box == null || box.getLink() == null) {
            if (this.sel_box != null) {
                box = this.sel_box;
                if (this.getCursor() != this.cursorDefault) {
                    this.setCursor(this.cursorDefault);
                }
                this.frame.passMouseOverLink(4, box.getLink(), box.getLinkTargetFrame(), box.getOutputString(), mouseEvent);
                this.sel_box = null;
                return;
            }
        } else {
            if (box != this.sel_box) {
                this.sel_box = box;
                if (this.getCursor() != this.cursorLink) {
                    this.setCursor(this.cursorLink);
                }
                this.frame.passMouseOverLink(3, box.getLink(), box.getLinkTargetFrame(), box.getOutputString(), mouseEvent);
                return;
            }
            if (box instanceof BoxImage && ((BoxImage)box).isImageMap()) {
                this.frame.passMouseOverLink(2, box.getLink(), box.getLinkTargetFrame(), box.getOutputString(), mouseEvent);
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        Point point = this.docFrame.getScrollPosition();
        Dimension dimension = this.docFrame.getViewportSize();
        if ((mouseEvent.getModifiers() & 4) != 0) {
            if (this.mouseScrollX == -10000) {
                this.mouseScrollX = n;
                this.mouseScrollY = n2;
                return;
            }
            this.docFrame.setScrollPosition(point.x - (n - this.mouseScrollX), point.y - (n2 - this.mouseScrollY));
            this.mouseScrollX = n;
            this.mouseScrollY = n2;
            return;
        }
        if ((mouseEvent.getModifiers() & 8) != 0) {
            return;
        }
        this.vis_doc.mouseDragged(n + this.scrollX, n2 + this.scrollY);
        if (n < 0 || n2 < 0 || n > dimension.width || n2 > dimension.height) {
            if (n > dimension.width) {
                n -= dimension.width;
            } else if (n > 0) {
                n = 0;
            }
            if (n2 > dimension.height) {
                n2 -= dimension.height;
            } else if (n2 > 0) {
                n2 = 0;
            }
            this.docFrame.setScrollPosition(point.x + n, point.y + n2);
        }
    }
}

