/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.Browser;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.PrintJob;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.net.URL;
import java.util.Properties;

public class ICEBrowser
extends Applet
implements Externalizable,
WindowListener,
ActionListener,
PropertyChangeListener {
    private Browser bb;
    private Frame appFrame;
    private TextField textURL;
    private TextField enc;
    private TextField search;
    private Label status;
    private Panel controls;
    private boolean visibleControl = true;
    private boolean visibleStatus = true;
    private String start_loc;
    private String prevSearchString = "";
    private int prevSearch = -1;
    private Properties printProp = new Properties();

    public static void main(String[] stringArray) {
        String string = new String("http://www.icesoft.no");
        Frame frame = new Frame();
        frame.setLayout(new BorderLayout());
        ICEBrowser iCEBrowser = new ICEBrowser(stringArray.length >= 1 ? stringArray[0] : string, frame);
        frame.add((Component)iCEBrowser, "Center");
        ((Component)frame).setSize(400, 600);
        ((Component)frame).setVisible(true);
    }

    public ICEBrowser() {
        this(null, null);
    }

    public ICEBrowser(String string, Frame frame) {
        Serializable serializable;
        this.start_loc = string;
        this.appFrame = frame;
        this.setLayout(new BorderLayout());
        if (frame != null) {
            frame.addWindowListener(this);
        }
        if (frame != null && (serializable = File.separatorChar == '/' ? this.getClass().getResource("ibicon48.gif") : this.getClass().getResource("ibicon32.gif")) != null) {
            frame.setIconImage(this.getToolkit().getImage((URL)serializable));
        }
        serializable = new Panel();
        ((Container)serializable).setLayout(new FlowLayout(0));
        ((Component)serializable).setFont(new Font("SansSerif", 1, 14));
        Button button = new Button("Back");
        button.addActionListener(this);
        ((Container)serializable).add(button);
        button = new Button("Forward");
        button.addActionListener(this);
        ((Container)serializable).add(button);
        button = new Button("Reload");
        button.addActionListener(this);
        ((Container)serializable).add(button);
        button = new Button("Stop");
        button.addActionListener(this);
        ((Container)serializable).add(button);
        button = new Button("Scroll");
        button.addActionListener(this);
        ((Container)serializable).add(button);
        button = new Button("Print");
        button.addActionListener(this);
        ((Container)serializable).add(button);
        this.enc = new TextField("<encoding>", 12);
        this.enc.setFont(new Font("SansSerif", 0, 12));
        this.enc.addActionListener(this);
        ((Container)serializable).add(this.enc);
        this.search = new TextField("<search>", 12);
        this.search.setFont(new Font("SansSerif", 0, 12));
        this.search.addActionListener(this);
        ((Container)serializable).add(this.search);
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(0));
        this.textURL = new TextField(80);
        this.textURL.addActionListener(this);
        panel.add(this.textURL);
        this.controls = new Panel();
        this.controls.setLayout(new BorderLayout());
        this.controls.setBackground(Color.lightGray);
        this.controls.add("North", (Component)serializable);
        this.controls.add("South", panel);
        this.status = new Label("ICE Browser 4.08", 1);
        this.add("North", this.controls);
        this.add("South", this.status);
        this.bb = new Browser();
        this.bb.addPropertyChangeListener(this);
        this.add("Center", this.bb);
        this.setSize(300, 400);
        if (string != null) {
            this.bb.gotoLocation(string, "_top", null);
        }
    }

    public Browser getBrowser() {
        return this.bb;
    }

    public void init() {
    }

    public void start() {
    }

    public void stop() {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (actionEvent.getSource() == this.textURL) {
            this.bb.gotoLocation(this.textURL.getText());
            return;
        }
        if (actionEvent.getSource() == this.enc) {
            this.bb.setEncoding(this.enc.getText());
            return;
        }
        if (actionEvent.getSource() == this.search) {
            String string2 = this.search.getText();
            if (!string2.equals(this.prevSearchString)) {
                this.prevSearchString = string2;
                this.prevSearch = -1;
            }
            this.prevSearch = this.bb.search(this.prevSearch, string2, false);
            return;
        }
        if (string.equals("Scroll")) {
            this.bb.setScrollMode(this.bb.getScrollMode() ^ 1);
            return;
        }
        if (string.equals("Back")) {
            this.bb.goBack();
            return;
        }
        if (string.equals("Forward")) {
            this.bb.goForward();
            return;
        }
        if (string.equals("Reload")) {
            this.bb.reload();
            return;
        }
        if (string.equals("Stop")) {
            this.bb.htmlInterrupt();
            return;
        }
        if (string.equals("Print")) {
            this.printDoc();
        }
    }

    void printDoc() {
        PrintJob printJob = this.getToolkit().getPrintJob(this.appFrame, "ICE Browser", this.printProp);
        this.bb.printDoc(printJob);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.bb) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("statusString")) {
                this.status.setText((String)propertyChangeEvent.getNewValue());
                return;
            }
            if (string.equals("documentBase")) {
                ((TextComponent)this.textURL).setText((String)propertyChangeEvent.getNewValue());
                return;
            }
            if (string.equals("documentTitle") && this.appFrame != null) {
                this.appFrame.setTitle("ICE Browser - [" + propertyChangeEvent.getNewValue() + "]");
                return;
            }
            if (string.equals("parsingProgress")) {
                this.processProgress((String)propertyChangeEvent.getNewValue());
            }
        }
    }

    private void processProgress(String string) {
        int n = string.indexOf(32);
        int n2 = string.indexOf(32, n + 1);
        if (n < 0 || n2 < 0 || n2 == n) {
            return;
        }
        string.substring(n2);
        try {
            int n3 = Integer.parseInt(string.substring(0, n));
            int n4 = Integer.parseInt(string.substring(n + 1, n2));
            string = n3 == n4 ? "Parsing done" : (n4 <= 0 ? " " + (n3 >> 10) + "K read" : " " + n3 * 100 / n4 + "% read");
            this.status.setText(string);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        System.exit(0);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public String getVersion() {
        return "4.08";
    }

    public void setVersion(String string) {
    }

    public String getCurrentLocation() {
        this.bb.setCurrentFrame("_top");
        return this.bb.getCurrentLocation();
    }

    public void setCurrentLocation(String string) {
        this.bb.gotoLocation(string);
    }

    public void setVisibleStatus(boolean bl) {
        if (this.visibleStatus && !bl) {
            this.visibleStatus = false;
            this.remove(this.status);
            this.validate();
            return;
        }
        if (!this.visibleStatus && bl) {
            this.visibleStatus = true;
            this.add("South", this.status);
            this.validate();
        }
    }

    public boolean isVisibleStatus() {
        return this.visibleStatus;
    }

    public void setVisibleControl(boolean bl) {
        if (this.visibleControl && !bl) {
            this.visibleControl = false;
            this.remove(this.controls);
            this.validate();
            return;
        }
        if (!this.visibleControl && bl) {
            this.visibleControl = true;
            this.add("North", this.controls);
            this.validate();
        }
    }

    public boolean isVisibleControl() {
        return this.visibleControl;
    }

    public void writeExternal(ObjectOutput objectOutput) {
        try {
            objectOutput.writeObject(this.getSize());
            objectOutput.writeObject(new Boolean(this.isVisibleControl()));
            objectOutput.writeObject(this.getCurrentLocation());
            objectOutput.writeObject(this.getName());
            return;
        }
        catch (IOException iOException) {
            System.err.println("ICE Browser: cannot serialize");
            return;
        }
    }

    public void readExternal(ObjectInput objectInput) {
        try {
            Dimension dimension = (Dimension)objectInput.readObject();
            Boolean bl = (Boolean)objectInput.readObject();
            this.start_loc = (String)objectInput.readObject();
            String string = (String)objectInput.readObject();
            this.setSize(dimension);
            this.setName(string);
            this.setVisibleControl(bl);
            if (this.start_loc != null) {
                this.bb.gotoLocation(this.start_loc, "_top", null);
            }
            this.setVisible(true);
            return;
        }
        catch (Exception exception) {
            System.err.println("ICE Browser: cannot deserialize");
            return;
        }
    }
}

