/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.sea.helpsys;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import se.ericsson.sea.helpsys.ZIPContainer;
import se.ericsson.sea.helpsys.ZIPElement;

public class IndexTable {
    public static final String ZIP_PROPERTYS_FILE = "properties.ini";
    public static final String HELP_IDSTABLE_FILE = "table.ids";
    public static final String HELP_LOG_FILE = "helplog.txt";
    public static final String LANGUAGE_KEY = "LANGUAGE";
    public static final String RELEASE_KEY = "RELEASE";
    public static final String SUBJECT_KEY = "SUBJECT";
    public static final String SYSTEM_KEY = "SYSTEM";
    public static final String DEFAULT_KEY = "DEFAULT";
    public static final String LANGUAGEV_KEY = "LANGUAGEV";
    public static final String RELEASEV_KEY = "RELEASEV";
    public static final String SUBJECTV_KEY = "SUBJECTV";
    public static final String SYSTEMV_KEY = "SYSTEMV";
    private Hashtable full_zip_element = new Hashtable();
    private BufferedWriter out_file;
    private BufferedWriter helplog;

    public synchronized void load(InputStream inputstream, Properties p) throws IOException {
        BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(inputstream, "UTF8"));
        String s;
        while ((s = bufferedreader.readLine()) != null) {
            int i1;
            int l;
            int j;
            char c;
            if (s.length() <= 0 || (c = s.charAt(0)) == '#' || c == '!') continue;
            while (this.continueLine(s)) {
                String s1 = bufferedreader.readLine();
                if (s1 == null) {
                    s1 = new String("");
                }
                String s2 = s.substring(0, s.length() - 1);
                int k = 0;
                for (k = 0; k < s1.length() && " \t\r\n\f".indexOf(s1.charAt(k)) != -1; ++k) {
                }
                s1 = s1.substring(k, s1.length());
                s = new String(s2 + s1);
            }
            int i = s.length();
            for (j = 0; j < i && " \t\r\n\f".indexOf(s.charAt(j)) != -1; ++j) {
            }
            if (j == i) continue;
            for (l = j; l < i; ++l) {
                char c1 = s.charAt(l);
                if (c1 == '\\') {
                    ++l;
                    continue;
                }
                if ("=: \t\r\n\f".indexOf(c1) != -1) break;
            }
            for (i1 = l; i1 < i && " \t\r\n\f".indexOf(s.charAt(i1)) != -1; ++i1) {
            }
            if (i1 < i && "=:".indexOf(s.charAt(i1)) != -1) {
                ++i1;
            }
            while (i1 < i && " \t\r\n\f".indexOf(s.charAt(i1)) != -1) {
                ++i1;
            }
            String s3 = s.substring(j, l);
            String s4 = l >= i ? "" : s.substring(i1, i);
            s3 = this.loadConvert(s3);
            s4 = this.loadConvert(s4);
            p.put(s3, s4);
        }
        return;
    }

    private boolean continueLine(String s) {
        int i = 0;
        int j = s.length() - 1;
        while (j >= 0 && s.charAt(j--) == '\\') {
            ++i;
        }
        return i % 2 == 1;
    }

    private String loadConvert(String s) {
        int i = s.length();
        StringBuffer stringbuffer = new StringBuffer(i);
        int j = 0;
        while (j < i) {
            int c;
            if ((c = s.charAt(j++)) == 92) {
                if ((c = s.charAt(j++)) == 117) {
                    int k = 0;
                    block6: for (int l = 0; l < 4; ++l) {
                        c = s.charAt(j++);
                        switch (c) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                k = (k << 4) + c - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                k = (k << 4) + 10 + c - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                k = (k << 4) + 10 + c - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    stringbuffer.append((char)k);
                    continue;
                }
                if (c == 116) {
                    c = 9;
                } else if (c == 114) {
                    c = 13;
                } else if (c == 110) {
                    c = 10;
                } else if (c == 102) {
                    c = 12;
                }
                stringbuffer.append((char)c);
                continue;
            }
            stringbuffer.append((char)c);
        }
        return stringbuffer.toString();
    }

    public IndexTable(String help_root) throws Exception {
    }

    public Hashtable getAllZipElements() {
        return this.full_zip_element;
    }

    public void traverse(File f, String path) {
        if (f.isDirectory()) {
            String[] children = f.list();
            for (int i = 0; i < children.length; ++i) {
                File file = new File(f, children[i]);
                if (!file.isDirectory()) {
                    String fileName;
                    Hashtable content;
                    String zip_file = path + "/" + children[i];
                    if (!zip_file.substring(zip_file.lastIndexOf(46)).toLowerCase().equals(".zip") || (content = IndexTable.getZIPTableOfContent(fileName = path + "/" + children[i])) == null) continue;
                    Properties zip_properties = this.getInitFile(fileName, content, ZIP_PROPERTYS_FILE);
                    Properties ids = this.getInitFile(fileName, content, HELP_IDSTABLE_FILE);
                    if (zip_properties == null || ids == null) continue;
                    String entries_has_zip = zip_properties.getProperty("ENTRIES");
                    int entries_has = 0;
                    if (entries_has_zip == null) {
                        entries_has = 0;
                        this.generate_index_tab_entry(i, zip_file, zip_properties, "");
                        continue;
                    }
                    try {
                        entries_has = Integer.parseInt(entries_has_zip);
                        for (int j = 1; j <= entries_has; ++j) {
                            this.generate_index_tab_entry(i, zip_file, zip_properties, String.valueOf(j));
                        }
                        continue;
                    }
                    catch (Exception ex) {
                        System.out.println("ERROR: 'ENTRIES' VALUE NOT VALID !!!");
                        entries_has = 1;
                        this.generate_index_tab_entry(i, zip_file, zip_properties, "1");
                        continue;
                    }
                }
                this.traverse(file, path + "/" + children[i]);
            }
        }
    }

    public static Hashtable getZIPTableOfContent(String zipFile) {
        Hashtable<String, ZipEntry> items = new Hashtable<String, ZipEntry>();
        try {
            ZipFile zf = new ZipFile(zipFile);
            Enumeration<? extends ZipEntry> entries = zf.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zentry = entries.nextElement();
                items.put(zentry.getName(), zentry);
            }
        }
        catch (IOException e) {
            return null;
        }
        return items;
    }

    public Properties getInitFile(String zipFile, Hashtable items, String name) {
        Object buf = null;
        try {
            ZipFile zf = new ZipFile(zipFile);
            ZipEntry zentry = (ZipEntry)items.get(name);
            if (zentry != null) {
                InputStream in = zf.getInputStream(zentry);
                Properties p = new Properties();
                this.load(in, p);
                in.close();
                return p;
            }
        }
        catch (IOException ex) {
            return null;
        }
        return null;
    }

    public boolean parseIndexTable(String file_name, String str_root) throws Exception {
        try {
            String str_line;
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(str_root + "/" + file_name), "UTF8"));
            String token = "";
            boolean bSystem = false;
            boolean bSubject = false;
            boolean bRelease = false;
            boolean bLanguage = false;
            boolean bFile = false;
            boolean bSystemVw = false;
            boolean bSubjectVw = false;
            boolean bReleaseVw = false;
            boolean bLanguageVw = false;
            boolean bDefault = false;
            String strSystem = "";
            String strSubject = "";
            String strRelease = "";
            String strLanguage = "";
            String strFile = "";
            String strSystemVw = "";
            String strSubjectVw = "";
            String strDefault = "";
            String strReleaseVw = "";
            String strLanguageVw = "";
            String strFileVw = "";
            while ((str_line = in.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(str_line, " ,=\r\n\t");
                if (!st.hasMoreTokens()) continue;
                token = st.nextToken();
                if (token.startsWith("@")) {
                    bFile = false;
                    bSystem = false;
                    bSubject = false;
                    bRelease = false;
                    bLanguage = false;
                    bSystemVw = false;
                    bSubjectVw = false;
                    bReleaseVw = false;
                    bLanguageVw = false;
                    bDefault = false;
                    strSystem = "";
                    strSubject = "";
                    strRelease = "";
                    strLanguage = "";
                    strFile = "";
                    strSystemVw = "";
                    strSubjectVw = "";
                    strReleaseVw = "";
                    strLanguageVw = "";
                    strFileVw = "";
                }
                if (!bFile && token.equals("FILE") && st.hasMoreTokens()) {
                    strFile = str_line.substring(str_line.indexOf("=") + 1).trim();
                    bFile = true;
                } else if (bFile && token.equals("FILE")) {
                    System.out.println("ERROR: Cannot parse " + ZIPContainer.STR_INDEX_TABLE_FILE + " file!");
                    return false;
                }
                if (!bSystem && token.equals(SYSTEM_KEY) && st.hasMoreTokens()) {
                    strSystem = st.nextToken().trim();
                    bSystem = true;
                } else if (bSystem && token.equals(SYSTEM_KEY)) {
                    System.out.println("ERROR: Cannot parse " + ZIPContainer.STR_INDEX_TABLE_FILE + " file!");
                    return false;
                }
                if (!bSubject && token.equals(SUBJECT_KEY) && st.hasMoreTokens()) {
                    strSubject = st.nextToken().trim();
                    bSubject = true;
                } else if (bSubject && token.equals(SUBJECT_KEY)) {
                    System.out.println("ERROR: Cannot parse " + ZIPContainer.STR_INDEX_TABLE_FILE + " file!");
                    return false;
                }
                if (!bRelease && token.equals(RELEASE_KEY) && st.hasMoreTokens()) {
                    strRelease = st.nextToken().trim();
                    bRelease = true;
                } else if (bRelease && token.equals(RELEASE_KEY)) {
                    System.out.println("ERROR: Cannot parse " + ZIPContainer.STR_INDEX_TABLE_FILE + " file!");
                    return false;
                }
                if (!bLanguage && token.equals(LANGUAGE_KEY) && st.hasMoreTokens()) {
                    strLanguage = st.nextToken().trim();
                    bLanguage = true;
                } else if (bLanguage && token.equals(LANGUAGE_KEY)) {
                    System.out.println("ERROR: Cannot parse " + ZIPContainer.STR_INDEX_TABLE_FILE + " file!");
                    return false;
                }
                if (!bSystemVw && token.equals("SYSTEM_VW") && st.hasMoreTokens()) {
                    while (st.hasMoreTokens()) {
                        strSystemVw = st.nextToken().trim();
                    }
                    bSystemVw = true;
                }
                if (!bSubjectVw && token.equals("SUBJECT_VW") && st.hasMoreTokens()) {
                    while (st.hasMoreTokens()) {
                        strSubjectVw = strSubjectVw + st.nextToken() + " ";
                    }
                    bSubjectVw = true;
                }
                if (!bReleaseVw && token.equals("RELEASE_VW") && st.hasMoreTokens()) {
                    while (st.hasMoreTokens()) {
                        strReleaseVw = st.nextToken().trim();
                    }
                    bReleaseVw = true;
                }
                if (!bLanguageVw && token.equals("LANGUAGE_VW") && st.hasMoreTokens()) {
                    while (st.hasMoreTokens()) {
                        strLanguageVw = st.nextToken().trim();
                    }
                    bLanguageVw = true;
                }
                if (!bDefault && token.equals(DEFAULT_KEY) && st.hasMoreTokens()) {
                    strDefault = st.nextToken().trim();
                    bDefault = true;
                }
                if (strSystem.equals("") || strSubject.equals("") || strRelease.equals("") || strLanguage.equals("") || strFile.equals("") || !bSystemVw || !bSubjectVw || !bReleaseVw || !bLanguageVw) continue;
                ZIPElement elem = new ZIPElement(strSystem, strSystemVw, strRelease, strReleaseVw, strSubject, strSubjectVw, strLanguage, strLanguageVw, strFile, bDefault);
                String ht_key = strSystem + strRelease + strSubject + strLanguage;
                this.full_zip_element.put(ht_key, elem);
            }
            in.close();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public void createIndexTable(String file_name, String str_root) throws Exception {
        System.out.println("INDEX TABLE FILE:" + str_root + "/" + file_name);
        System.out.println("HELP LOG FILE   :" + str_root + "/" + HELP_LOG_FILE);
        try {
            this.helplog = new BufferedWriter(new FileWriter(str_root + "/" + HELP_LOG_FILE));
        }
        catch (Exception exe) {
            // empty catch block
        }
        this.out_file = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(str_root + "/" + file_name), "UTF8"));
        this.traverse(new File(str_root), str_root);
        this.out_file.close();
        this.helplog.close();
    }

    public static void doIt() {
        try {
            String hpath = "resources/help";
            String hfile = "IndexTable.txt";
            String str_root = hpath;
            String file_name = hfile;
            IndexTable cont = new IndexTable(str_root);
            cont.createIndexTable(file_name, str_root);
            System.out.println("------------------------ PARSING - CHECK ------------------------");
            cont.parseIndexTable(file_name, str_root);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void generate_index_tab_entry(int index, String zip_file, Properties zip_properties, String ext) {
        String syst = zip_properties.getProperty(SYSTEM_KEY + ext);
        String subject = zip_properties.getProperty(SUBJECT_KEY + ext);
        String release = zip_properties.getProperty(RELEASE_KEY + ext);
        String lang = zip_properties.getProperty(LANGUAGE_KEY + ext);
        String language_vw = zip_properties.getProperty(LANGUAGEV_KEY + ext);
        String release_vw = zip_properties.getProperty(RELEASEV_KEY + ext);
        String subject_vw = zip_properties.getProperty(SUBJECTV_KEY + ext);
        String sys_vw = zip_properties.getProperty(SYSTEMV_KEY + ext);
        String default_vw = zip_properties.getProperty(DEFAULT_KEY + ext);
        StringBuffer help_log_str = new StringBuffer();
        if (syst == null || syst.equals("")) {
            syst = "ERROR";
            help_log_str.append(SYSTEM_KEY + ext + ": NOT DEFINED!\r\n");
        }
        if (subject == null || subject.equals("")) {
            subject = "ERROR";
            System.out.println(SUBJECT_KEY + ext + ": NOT DEFINED!");
            help_log_str.append(SUBJECT_KEY + ext + ": NOT DEFINED!\r\n");
        }
        if (release == null || release.equals("")) {
            release = "ERROR";
            help_log_str.append(RELEASE_KEY + ext + ": NOT DEFINED!\r\n");
        }
        if (lang == null || lang.equals("")) {
            lang = "ERROR";
            help_log_str.append(LANGUAGE_KEY + ext + ": NOT DEFINED!\r\n");
        }
        if (language_vw == null || language_vw.equals("")) {
            language_vw = "EMPTY";
            help_log_str.append("LANGUAGE_VW" + ext + ": NOT DEFINED!\r\n");
        }
        if (release_vw == null || release_vw.equals("")) {
            release_vw = "EMPTY";
            help_log_str.append("RELEASE_VW" + ext + ": NOT DEFINED!\r\n");
        }
        if (subject_vw == null || subject_vw.equals("")) {
            subject_vw = "EMPTY";
            help_log_str.append("SUBJECT_VW" + ext + ": NOT DEFINED!\r\n");
        }
        if (sys_vw == null || sys_vw.equals("")) {
            sys_vw = "EMPTY";
            help_log_str.append("SYSTEM_VW" + ext + ": NOT DEFINED!\r\n");
        }
        StringBuffer sb = new StringBuffer();
        sb.append("@\r\n");
        sb.append("FILE=" + zip_file + "\r\n");
        if (default_vw != null) {
            sb.append("DEFAULT=" + default_vw + "\r\n");
        }
        ext = "";
        sb.append(SYSTEM_KEY + ext + "=" + syst + "\r\n");
        sb.append(SUBJECT_KEY + ext + "=" + subject + "\r\n");
        sb.append(RELEASE_KEY + ext + "=" + release + "\r\n");
        sb.append(LANGUAGE_KEY + ext + "= " + lang + "\r\n");
        sb.append("SYSTEM_VW" + ext + "=" + sys_vw + "\r\n");
        sb.append("SUBJECT_VW" + ext + "=" + subject_vw + "\r\n");
        sb.append("RELEASE_VW" + ext + "=" + release_vw + "\r\n");
        sb.append("LANGUAGE_VW" + ext + "= " + language_vw + "\r\n");
        sb.append("\r\n");
        System.out.println(index + zip_file);
        System.out.println(help_log_str);
        try {
            this.helplog.write(index + ". " + zip_file + "\r\n");
            this.helplog.write(help_log_str.toString());
            this.out_file.write(sb.toString() + "\r\n");
        }
        catch (IOException ioex) {
            System.out.println("ERROR = ???");
        }
    }

    public static void main(String[] args) {
        try {
            String hpath = "resources/help";
            String hfile = "IndexTable.txt";
            if (args != null) {
                if (args.length > 0) {
                    hpath = args[0];
                }
                if (args.length > 1) {
                    hfile = args[1];
                }
            }
            String str_root = hpath;
            String file_name = hfile;
            IndexTable cont = new IndexTable(str_root);
            cont.createIndexTable(file_name, str_root);
            System.out.println("------------------------ PARSING - CHECK ------------------------");
            cont.parseIndexTable(file_name, str_root);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

