/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.sea.wizardbean;

import com.installshield.wizard.WizardAction;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardSequence;
import java.io.File;
import java.io.FileInputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.util.Properties;

public class DBCheckAction
extends WizardAction {
    boolean noFile = false;
    boolean oldMSDEfound = false;
    boolean dBfound = false;
    String hostName;
    String conn2 = null;
    boolean internalError = false;
    private String dbName;
    private String dbVersion;

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbVersion(String dbVersion) {
        this.dbVersion = dbVersion;
    }

    public String getDbVersion() {
        return this.dbVersion;
    }

    public String getMessage() {
        return this.resolveString("$L(se.ericsson.sea.wizardbean.MyResources,searchdb)");
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getDbStatus() {
        StringBuffer analysis = new StringBuffer();
        if (this.noFile) {
            analysis.append(String.valueOf(this.resolveString("$L(se.ericsson.sea.wizardbean.MyResources,nobmsfound)")) + "\n");
        } else if (this.conn2 != null) {
            analysis.append(String.valueOf(this.resolveString("$L(se.ericsson.sea.wizardbean.MyResources,bmsdbold," + this.conn2 + ")")) + "\n");
        }
        if (this.dbName == null || this.dbVersion == null) {
            if (this.internalError) {
                analysis.append(String.valueOf(this.resolveString("$L(se.ericsson.sea.wizardbean.MyResources,anafailed)")) + "\n");
            } else {
                analysis.append(String.valueOf(this.resolveString("$L(se.ericsson.sea.wizardbean.MyResources,nodbfound)")) + "\n");
            }
        } else if (this.oldMSDEfound) {
            analysis.append(String.valueOf(this.resolveString("$L(se.ericsson.sea.wizardbean.MyResources,olddbfound)")) + "\n");
        }
        analysis.append(" \n" + this.resolveString("$L(se.ericsson.sea.wizardbean.MyResources,suggestion)") + "\n");
        if (this.noFile && !this.oldMSDEfound && !this.dBfound) {
            analysis.append(this.resolveString("$L(se.ericsson.sea.wizardbean.MyResources,suggmsde)"));
        } else {
            analysis.append(this.resolveString("$L(se.ericsson.sea.wizardbean.MyResources,sugguse)"));
        }
        return analysis.toString();
    }

    public boolean[] getDisplayFlags() {
        boolean[] blArray = new boolean[3];
        blArray[0] = true;
        blArray[1] = this.noFile && this.dbVersion == null;
        return blArray;
    }

    public void execute(WizardBeanEvent evt) {
        block25: {
            this.conn2 = null;
            this.dbName = null;
            this.dbVersion = null;
            Connection con = null;
            try {
                try {
                    String pwd;
                    String user;
                    String conn;
                    String driver;
                    block24: {
                        driver = "net.sourceforge.jtds.jdbc.Driver";
                        conn = "jdbc:jtds://127.0.0.1";
                        user = "sa";
                        pwd = "";
                        Properties p = new Properties();
                        String bmsroot = this.resolveString("$P(absoluteInstallLocation)");
                        FileInputStream fis = null;
                        try {
                            try {
                                this.noFile = false;
                                File f = new File(String.valueOf(bmsroot) + "/OAMServer.properties");
                                if (f.exists()) {
                                    fis = new FileInputStream(f);
                                    p.load(fis);
                                    driver = p.getProperty("DBdriver", driver);
                                    this.conn2 = p.getProperty("DBurl", conn);
                                    if (this.conn2 != null) {
                                        conn = this.conn2;
                                        this.conn2 = this.extractHostFromURL(this.conn2);
                                    }
                                    user = p.getProperty("DBuser", user);
                                    pwd = p.getProperty("DBpassword", pwd);
                                    break block24;
                                }
                                this.noFile = true;
                            }
                            catch (Exception ex) {
                                this.noFile = true;
                                ex.printStackTrace();
                            }
                        }
                        finally {
                            try {
                                if (fis != null) {
                                    fis.close();
                                }
                            }
                            catch (Exception exception) {}
                        }
                    }
                    this.hostName = this.extractHostFromURL(conn);
                    this.getState().setStatusDescription(this.resolveString("$L(se.ericsson.sea.wizardbean.MyResources,searchdb2," + this.hostName + ")"));
                    Class.forName(driver);
                    DatabaseMetaData md = null;
                    con = DriverManager.getConnection(conn, user, pwd);
                    md = con.getMetaData();
                    this.dbName = md.getDatabaseProductName();
                    this.dbVersion = md.getDatabaseProductVersion();
                    System.out.println(this.dbName);
                    System.out.println(this.dbVersion);
                    this.dBfound = true;
                    if (this.dbVersion.compareTo("08.00.0760") < 0) {
                        this.oldMSDEfound = true;
                        break block25;
                    }
                    ((WizardSequence)this.getWizardTree().getBean("dbsetup")).setActive(false);
                }
                catch (ClassNotFoundException e) {
                    this.internalError = true;
                    this.oldMSDEfound = false;
                    this.dBfound = false;
                    this.dbName = null;
                    this.dbVersion = null;
                    System.out.println("JDBC error: " + e);
                }
                catch (Exception e) {
                    this.oldMSDEfound = false;
                    this.dBfound = false;
                    this.dbName = null;
                    this.dbVersion = null;
                    System.out.println("JDBC error: " + e);
                }
            }
            finally {
                try {
                    if (con != null) {
                        con.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        super.execute(evt);
    }

    private String extractHostFromURL(String url) {
        try {
            url = String.valueOf(url) + "///";
            url = url.substring(url.indexOf("//") + 2);
            return url.substring(0, url.indexOf("/"));
        }
        catch (Exception exception) {
            return url;
        }
    }
}

