/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.archive.ijar;

import com.installshield.archive.ArchiveBuilderSupport;
import com.installshield.archive.BuildEvent;
import com.installshield.archive.BuildListener;
import com.installshield.archive.ijar.IJARReader;
import com.installshield.archive.ijar.IJARWriter;
import com.installshield.util.FileUtils;
import com.installshield.util.TempFileOwner;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;

public class IJAR
implements BuildListener {
    private static Hashtable writers = new Hashtable();
    private static Hashtable readers = new Hashtable();
    private IJARWriter writer;
    private String tempFile;

    private IJAR(IJARWriter iJARWriter, String string) {
        this.writer = iJARWriter;
        this.tempFile = string;
    }

    public void buildFinished(BuildEvent buildEvent) {
        new File(this.tempFile).delete();
        buildEvent.getSupport().removeBuildListener(this);
    }

    public void buildStarted(BuildEvent buildEvent) {
    }

    public static synchronized IJARReader getReader(URL uRL) throws IOException {
        IJARReader iJARReader = (IJARReader)readers.get(uRL.toExternalForm());
        if (iJARReader == null) {
            String string;
            boolean bl = false;
            if (uRL.getProtocol().equals("file")) {
                string = uRL.getFile();
            } else {
                string = FileUtils.createTempFile(uRL);
                bl = true;
            }
            iJARReader = new IJARReader(string);
            if (bl) {
                FileUtils.addTempFileOwner(new TempFileOwner(iJARReader.zipFile));
            }
            readers.put(uRL.toExternalForm(), iJARReader);
        }
        return iJARReader;
    }

    public static synchronized IJARWriter getWriter(ArchiveBuilderSupport archiveBuilderSupport, String string) throws IOException {
        IJARWriter iJARWriter = (IJARWriter)writers.get(string);
        if (iJARWriter == null) {
            String string2 = FileUtils.createTempFile();
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            FileUtils.addTempFileOwner(new TempFileOwner(fileOutputStream));
            iJARWriter = new IJARWriter(fileOutputStream);
            archiveBuilderSupport.putResource(string2, string);
            archiveBuilderSupport.addBuildListener(new IJAR(iJARWriter, string2));
            writers.put(string, iJARWriter);
        }
        return iJARWriter;
    }

    public static synchronized void reset() {
        writers.clear();
        readers.clear();
    }

    public void writeFinished(BuildEvent buildEvent) {
    }

    public void writeStarting(BuildEvent buildEvent) {
        try {
            this.writer.close();
        }
        catch (IOException iOException) {
            buildEvent.getSupport().logEvent(this, "err", iOException);
        }
    }
}

