/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product;

import com.installshield.product.GenericSoftwareObject;
import com.installshield.product.Locatable;
import com.installshield.product.Product;
import com.installshield.product.ProductAction;
import com.installshield.product.ProductActionEvent;
import com.installshield.product.ProductActionListener;
import com.installshield.product.ProductBean;
import com.installshield.product.ProductBeanPlaceHolder;
import com.installshield.product.ProductComponent;
import com.installshield.product.ProductComponentReference;
import com.installshield.product.ProductFeature;
import com.installshield.product.ProductReference;
import com.installshield.product.SoftwareObject;
import com.installshield.product.SoftwareObjectKey;
import com.installshield.product.StandardProductTreeIterator;
import com.installshield.product.Suite;
import com.installshield.product.actions.UninstallerArchive;
import com.installshield.product.actions.UninstallerJVMResolution;
import com.installshield.product.actions.UninstallerLauncher;
import com.installshield.util.FileUtils;
import com.installshield.util.GenericTreeNode;
import com.installshield.util.OperationRejectedException;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;

public class ProductTree {
    private ProductBean root = null;
    private UninstallerArchive uninstaller = new UninstallerArchive();
    private UninstallerLauncher uninstallerLauncher = new UninstallerLauncher();
    private UninstallerJVMResolution uninstallerJVMResolution = new UninstallerJVMResolution();
    private String logFile = "";
    private String selectedLocales = "";
    private Vector productActionListeners = new Vector();

    public ProductTree() {
        this.uninstaller.tree = this;
        this.uninstallerLauncher.tree = this;
        this.uninstallerJVMResolution.tree = this;
    }

    public ProductTree(ProductBean productBean) throws OperationRejectedException {
        this();
        this.setRoot(productBean);
    }

    public void add(ProductBean productBean, ProductBean productBean2) throws OperationRejectedException {
        if (!this.canAdd(productBean, productBean2)) {
            throw new OperationRejectedException();
        }
        GenericTreeNode genericTreeNode = productBean.node;
        genericTreeNode.addChild(this.getNode(productBean2));
    }

    public void addAction(ProductComponent productComponent, ProductAction productAction) throws OperationRejectedException {
        this.add(productComponent, productAction);
    }

    public void addComponent(Product product, ProductComponent productComponent) throws OperationRejectedException {
        this.add(product, productComponent);
    }

    public void addComponent(Product product, ProductComponentReference productComponentReference) throws OperationRejectedException {
        this.add(product, productComponentReference);
    }

    public void addComponent(ProductFeature productFeature, ProductComponent productComponent) throws OperationRejectedException {
        this.add(productFeature, productComponent);
    }

    public void addComponent(ProductFeature productFeature, ProductComponentReference productComponentReference) throws OperationRejectedException {
        this.add(productFeature, productComponentReference);
    }

    public void addFeature(Product product, ProductFeature productFeature) throws OperationRejectedException {
        this.add(product, productFeature);
    }

    public void addProductActionListener(ProductActionListener productActionListener) {
        this.productActionListeners.addElement(productActionListener);
    }

    public boolean canAdd(ProductBean productBean, ProductBean productBean2) {
        if (productBean2 instanceof ProductBeanPlaceHolder) {
            return true;
        }
        if (productBean instanceof Suite) {
            return productBean2 instanceof ProductReference;
        }
        if (productBean instanceof Product) {
            return productBean2 instanceof ProductFeature || productBean2 instanceof ProductComponent || productBean2 instanceof ProductComponentReference;
        }
        if (productBean instanceof ProductFeature) {
            return productBean2 instanceof ProductComponent || productBean2 instanceof ProductComponentReference;
        }
        if (productBean instanceof ProductComponent) {
            return productBean2 instanceof ProductAction;
        }
        return false;
    }

    public boolean canRemove(ProductBean productBean) {
        return true;
    }

    public Enumeration children(ProductBean productBean) {
        Vector<Object> vector = new Vector<Object>();
        GenericTreeNode genericTreeNode = this.getNode(productBean);
        if (genericTreeNode != null) {
            Enumeration enumeration = genericTreeNode.children();
            while (enumeration.hasMoreElements()) {
                vector.addElement(((GenericTreeNode)enumeration.nextElement()).getUserObject());
            }
        }
        return vector.elements();
    }

    private ProductBean findProductBean(ProductBean productBean, String string) {
        String string2 = productBean.getBeanId();
        if (string2 != null && string2.equals(string)) {
            return productBean;
        }
        Enumeration enumeration = this.children(productBean);
        while (enumeration.hasMoreElements()) {
            ProductBean productBean2 = this.findProductBean((ProductBean)enumeration.nextElement(), string);
            if (productBean2 == null) continue;
            return productBean2;
        }
        return null;
    }

    void fireProductActionEvent(ProductActionEvent productActionEvent) {
        int n = 0;
        while (n < this.productActionListeners.size()) {
            ((ProductActionListener)this.productActionListeners.elementAt(n)).productActionPerformed(productActionEvent);
            ++n;
        }
    }

    public ProductBean getBean(String string) {
        return this.findProductBean(this.getRoot(), string);
    }

    public ProductBean getChild(ProductBean productBean, int n) {
        return (ProductBean)((GenericTreeNode)productBean.node.getChildAt(n)).getUserObject();
    }

    public int getChildCount(ProductBean productBean) {
        return productBean.node.getChildCount();
    }

    public int getChildIndex(ProductBean productBean) {
        GenericTreeNode genericTreeNode = (GenericTreeNode)productBean.node.getParent();
        int n = 0;
        while (genericTreeNode != null && n < genericTreeNode.getChildCount()) {
            if (((GenericTreeNode)genericTreeNode.getChildAt(n)).getUserObject().equals(productBean)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public ProductBean getFirstChild(ProductBean productBean) {
        GenericTreeNode genericTreeNode = productBean.node.getFirstChild();
        return genericTreeNode != null ? (ProductBean)genericTreeNode.getUserObject() : null;
    }

    public int getInstallFailureOption(ProductBean productBean) {
        int n;
        int n2 = 1;
        if (productBean != null && productBean instanceof GenericSoftwareObject) {
            n2 = ((GenericSoftwareObject)productBean).getInstallFailureOption();
        }
        if (productBean != null && n2 != 3 && (n = this.getInstallFailureOption(this.getParent(productBean))) != 1) {
            n2 = n;
        }
        return n2;
    }

    public String getInstallLocation(ProductBean productBean) {
        String string = null;
        if (productBean instanceof Locatable) {
            string = ((Locatable)((Object)productBean)).getInstallLocation();
        }
        if (string == null || string.trim().length() == 0) {
            return this.getParentInstallLocation(productBean);
        }
        string = FileUtils.normalizeFileName(string);
        if (FileUtils.isAbsolute(string = productBean.resolveString(string))) {
            return string;
        }
        if (this.getParent(productBean) != null) {
            String string2 = this.getParentInstallLocation(productBean);
            return FileUtils.createFileName(string2, string);
        }
        if (productBean != this.root && this.root instanceof SoftwareObject) {
            return FileUtils.createFileName(this.getInstallLocation(this.root), string);
        }
        return string;
    }

    public ProductBean getLastChild(ProductBean productBean) {
        GenericTreeNode genericTreeNode = productBean.node.getLastChild();
        return genericTreeNode != null ? (ProductBean)genericTreeNode.getUserObject() : null;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public ProductBean getNextSibling(ProductBean productBean) {
        GenericTreeNode genericTreeNode = productBean.node.getNextSibling();
        return genericTreeNode != null ? (ProductBean)genericTreeNode.getUserObject() : null;
    }

    private GenericTreeNode getNode(ProductBean productBean) {
        GenericTreeNode genericTreeNode = productBean.node;
        if (genericTreeNode == null) {
            genericTreeNode = new GenericTreeNode();
        }
        this.updateBean(productBean, genericTreeNode);
        return genericTreeNode;
    }

    public ProductBean getParent(ProductBean productBean) {
        GenericTreeNode genericTreeNode = (GenericTreeNode)productBean.node.getParent();
        return genericTreeNode != null ? (ProductBean)genericTreeNode.getUserObject() : null;
    }

    private String getParentInstallLocation(ProductBean productBean) {
        ProductBean productBean2 = this.getParent(productBean);
        if (productBean2 != null) {
            return this.getInstallLocation(productBean2);
        }
        return new File("").getAbsolutePath();
    }

    public ProductBean getPreviousSibling(ProductBean productBean) {
        GenericTreeNode genericTreeNode = productBean.node.getPreviousSibling();
        return genericTreeNode != null ? (ProductBean)genericTreeNode.getUserObject() : null;
    }

    public int getRemoveOption(ProductBean productBean) {
        int n = 0;
        if (productBean != null && productBean instanceof GenericSoftwareObject) {
            n = ((GenericSoftwareObject)productBean).getRemoveOption();
        }
        if (productBean != null && n == 0) {
            n = this.getRemoveOption(this.getParent(productBean));
        }
        return n == 0 ? 4 : n;
    }

    public int getReplaceOption(ProductBean productBean) {
        int n = 0;
        if (productBean != null && productBean instanceof GenericSoftwareObject) {
            n = ((GenericSoftwareObject)productBean).getReplaceOption();
        }
        if (productBean != null && n == 0) {
            n = this.getReplaceOption(this.getParent(productBean));
        }
        return n == 0 ? 4 : n;
    }

    public ProductBean getRoot() {
        return this.root;
    }

    public String getSelectedLocales() {
        return this.selectedLocales;
    }

    public UninstallerArchive getUninstallerArchive() {
        return this.uninstaller;
    }

    public UninstallerJVMResolution getUninstallerJVMResolution() {
        return this.uninstallerJVMResolution;
    }

    public UninstallerLauncher getUninstallerLauncher() {
        return this.uninstallerLauncher;
    }

    public void insert(ProductBean productBean, int n, ProductBean productBean2) throws OperationRejectedException {
        if (!this.canAdd(productBean, productBean2)) {
            throw new OperationRejectedException();
        }
        GenericTreeNode genericTreeNode = productBean.node;
        genericTreeNode.insertChild(this.getNode(productBean2), n);
    }

    public void remove(ProductBean productBean) throws OperationRejectedException {
        if (!this.canRemove(productBean)) {
            throw new OperationRejectedException();
        }
        GenericTreeNode genericTreeNode = (GenericTreeNode)productBean.node.getParent();
        genericTreeNode.removeChild(productBean.node);
    }

    public void removeProductActionListener(ProductActionListener productActionListener) {
        this.productActionListeners.removeElement(productActionListener);
    }

    public SoftwareObject resolveKey(SoftwareObjectKey softwareObjectKey) {
        StandardProductTreeIterator standardProductTreeIterator = new StandardProductTreeIterator(this);
        ProductBean productBean = standardProductTreeIterator.getNext(standardProductTreeIterator.begin());
        while (productBean != standardProductTreeIterator.end()) {
            if (productBean instanceof SoftwareObject && ((SoftwareObject)((Object)productBean)).getKey().equals(softwareObjectKey)) {
                return (SoftwareObject)((Object)productBean);
            }
            productBean = standardProductTreeIterator.getNext(productBean);
        }
        return null;
    }

    public void setChild(ProductBean productBean, int n, ProductBean productBean2) throws OperationRejectedException {
        GenericTreeNode genericTreeNode = productBean.node;
        this.updateBean(productBean2, (GenericTreeNode)genericTreeNode.getChildAt(n));
    }

    public void setLogFile(String string) {
        this.logFile = string;
    }

    public void setRoot(ProductBean productBean) throws OperationRejectedException {
        this.root = productBean;
        if (productBean != null) {
            this.updateBean(this.root, this.getNode(productBean));
        }
    }

    public void setSelectedLocales(String string) {
        this.selectedLocales = string;
    }

    public void setUninstallerArchive(UninstallerArchive uninstallerArchive) {
        this.uninstaller = uninstallerArchive;
        if (uninstallerArchive != null) {
            uninstallerArchive.tree = this;
        }
    }

    public void setUninstallerJVMResolution(UninstallerJVMResolution uninstallerJVMResolution) {
        this.uninstallerJVMResolution = uninstallerJVMResolution;
        if (this.uninstallerJVMResolution != null) {
            this.uninstallerJVMResolution.tree = this;
        }
    }

    public void setUninstallerLauncher(UninstallerLauncher uninstallerLauncher) {
        this.uninstallerLauncher = uninstallerLauncher;
        if (this.uninstallerLauncher != null) {
            this.uninstallerLauncher.tree = this;
        }
    }

    private void updateBean(ProductBean productBean, GenericTreeNode genericTreeNode) {
        genericTreeNode.setUserObject(productBean);
        productBean.node = genericTreeNode;
        this.updateTree(productBean);
    }

    private void updateTree(ProductBean productBean) {
        ProductBean productBean2 = this.getFirstChild(productBean);
        while (productBean2 != null) {
            this.updateTree(productBean2);
            productBean2 = this.getNextSibling(productBean2);
        }
        productBean.tree = this;
    }
}

