/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.wizardbeans;

import com.installshield.product.service.product.ProductService;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.WizardUI;
import com.installshield.wizard.awt.ColumnConstraints;
import com.installshield.wizard.awt.ColumnLayout;
import com.installshield.wizard.awt.Spacing;
import com.installshield.wizard.console.ConsoleWizardUI;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;
import com.installshield.wizardx.panels.ExtendedWizardPanel;
import com.installshield.wizardx.ui.DirectoryInputComponent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Stack;
import java.util.Vector;

public class DestinationPanel
extends ExtendedWizardPanel
implements ActionListener {
    private String productURL = "/product.xml";
    private DirectoryInputComponent destinationField = null;
    private FileService fileService = null;
    private WizardUI ui = null;
    private static final String YES = "$L(com.installshield.wizard.i18n.WizardResources, yes)";
    private static final String NO = "$L(com.installshield.wizard.i18n.WizardResources, no)";
    private static final String CREATE_DIR = "createDirectoryResponse";
    private static final String YES_RESPONSE = "yes";
    private static final String NO_RESPONSE = "no";
    private String destinationToCreate = "";

    public DestinationPanel() {
        this.setDescription("$L(com.installshield.product.i18n.ProductResources, DestinationPanel.description, $P(displayName))");
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        wizardBuilderSupport.putRequiredService("productService");
        wizardBuilderSupport.putRequiredService("fileService");
    }

    private void createDirs(String string, FileService fileService) throws IOException, ServiceException {
        Object object;
        Stack<String> stack = new Stack<String>();
        Object object2 = string;
        while (object2 != null) {
            if (fileService.fileExists((String)object2)) break;
            stack.push((String)object2);
            object2 = object = fileService.getParent((String)object2);
        }
        if (stack.isEmpty() && string != null) {
            if (!fileService.isDirectoryWritable(string)) {
                throw new IOException("Directory exists and its read-only");
            }
            return;
        }
        object = new Vector();
        while (!stack.isEmpty()) {
            object2 = (String)stack.pop();
            if (!fileService.fileExists((String)object2)) {
                fileService.createDirectory((String)object2);
                ((Vector)object).addElement(object2);
                continue;
            }
            if (fileService.isDirectoryWritable((String)object2)) continue;
            throw new IOException("Directory is read-only");
        }
        int n = ((Vector)object).size() - 1;
        while (n >= 0) {
            if (fileService.fileExists((String)((Vector)object).elementAt(n))) {
                fileService.deleteDirectory((String)((Vector)object).elementAt(n));
            }
            --n;
        }
    }

    protected void createUI(WizardBeanEvent wizardBeanEvent) {
        super.createUI(wizardBeanEvent);
        this.ui = wizardBeanEvent.getUserInterface();
        this.destinationField.createComponentUI();
    }

    public void execute(WizardBeanEvent wizardBeanEvent) {
        try {
            String string = "";
            ProductService productService = (ProductService)this.getService("productService");
            string = (String)productService.getProductBeanProperty(this.productURL, null, "absoluteInstallLocation");
            this.fileService = (FileService)this.getService("fileService");
            String string2 = "";
            if (string != null) {
                string2 = this.resolveString(string);
            }
            boolean bl = false;
            if (string2.trim().length() > 0 && !string2.equals("")) {
                String string3;
                boolean bl2 = bl = this.fileService.fileExists(string2);
                if (!bl && this.getWizard().getServices().getValue(CREATE_DIR) != null && (string3 = (String)this.getWizard().getServices().getValue(CREATE_DIR)).equals(YES_RESPONSE)) {
                    this.fileService.createDirectory(string2);
                }
            }
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
        }
    }

    public Frame getParentFrame(Component component) {
        if (component == null) {
            return null;
        }
        Container container = component.getParent();
        if (container == null) {
            return null;
        }
        if (container instanceof Frame) {
            return (Frame)container;
        }
        return this.getParentFrame(container);
    }

    protected void initialize() {
        Object object;
        super.initialize();
        String string = "";
        try {
            object = (ProductService)this.getService("productService");
            string = (String)object.getProductBeanProperty(this.productURL, null, "absoluteInstallLocation");
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
        }
        try {
            this.fileService = (FileService)this.getService("fileService");
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
        }
        object = "";
        if (string != null) {
            object = this.resolveString(string);
        }
        Panel panel = new Panel(new ColumnLayout());
        this.getContentPane().add((Component)panel, "Center");
        panel.add(Spacing.createVerticalSpacing(10));
        this.destinationField = new DirectoryInputComponent((String)object, this.getParentFrame(this.getContentPane()), this.fileService);
        panel.add((Component)this.destinationField, ColumnConstraints.createHorizontalFill());
    }

    private boolean isDirectoryWritable(String string, FileService fileService) {
        try {
            this.createDirs(string, fileService);
            return true;
        }
        catch (Exception exception) {
            this.logEvent(this, "wrn", exception);
            return false;
        }
    }

    private String mapResponse(String string) {
        String string2 = NO_RESPONSE;
        if (string.equals(this.resolveString(YES))) {
            string2 = YES_RESPONSE;
        } else if (string.equals(this.resolveString(NO))) {
            string2 = NO_RESPONSE;
        }
        return string2;
    }

    public boolean queryExit(WizardBeanEvent wizardBeanEvent) {
        boolean bl = true;
        if (this.destinationField != null && (bl = this.validateDestination(wizardBeanEvent))) {
            this.updateProductTree(this.destinationField.getDirectoryName());
        }
        return bl;
    }

    private void updateProductTree(String string) {
        try {
            ProductService productService = (ProductService)this.getService("productService");
            productService.setProductBeanProperty(this.productURL, null, "installLocation", this.resolveString(string));
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
        }
    }

    private boolean validateDestination(WizardBeanEvent wizardBeanEvent) {
        block11: {
            if (this.destinationField == null) {
                throw new Error();
            }
            String string = this.destinationField.getDirectoryName();
            boolean bl = false;
            if (string.trim().length() <= 0 || string.equals("")) break block11;
            try {
                if (this.isDirectoryWritable(string, this.fileService)) {
                    if (string.equals(this.destinationToCreate)) {
                        return true;
                    }
                    this.destinationToCreate = string;
                    boolean bl2 = bl = this.fileService.fileExists(string);
                    if (!bl) {
                        String string2 = LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "DestinationPanel.directoryNotExist");
                        String string3 = null;
                        if (this.getWizard().getServices().getValue(CREATE_DIR) != null) {
                            string3 = (String)this.getWizard().getServices().getValue(CREATE_DIR);
                        } else {
                            string3 = (String)this.getWizard().getServices().getUserInput(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "DestinationPanel.createTheDirectory"), string2, new Object[]{this.resolveString(YES), this.resolveString(NO)}, this.resolveString(YES));
                            string3 = this.mapResponse(string3);
                        }
                        if (string3.equals(YES_RESPONSE)) {
                            return true;
                        }
                        this.destinationToCreate = "";
                        if (!(wizardBeanEvent.getUserInterface() instanceof ConsoleWizardUI)) break block11;
                        this.destinationField.consoleInteraction();
                        break block11;
                    }
                    return true;
                }
                String string4 = LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "notWritable", new String[]{string});
                String string5 = "$L(com.installshield.wizard.i18n.WizardResources, ok)";
                try {
                    this.getWizard().getServices().getUserInput(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "DestinationPanel.createTheDirectory"), string4, new Object[]{this.resolveString(string5)}, this.resolveString(string5));
                }
                catch (ServiceException serviceException) {
                    this.logEvent(this, "err", serviceException);
                }
                return false;
            }
            catch (ServiceException serviceException) {
                this.logEvent(this, "err", serviceException);
            }
        }
        return false;
    }
}

