/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

public class ResponseFilesParser {
    private static boolean canRead(String string, int n) {
        return n < string.length();
    }

    private static String[] createOptionArray(String string, Vector vector) {
        String[] stringArray = new String[vector.size() + 2];
        stringArray[0] = string;
        int n = 0;
        while (n < vector.size()) {
            stringArray[n + 1] = (String)vector.elementAt(n);
            ++n;
        }
        stringArray[stringArray.length - 1] = "0";
        return stringArray;
    }

    private static Vector gatherArguments(String string, int n) {
        Vector<String> vector = new Vector<String>();
        int n2 = n;
        while (n2 < string.length()) {
            if (!Character.isWhitespace(string.charAt(n2))) {
                Object[] objectArray = new Object[1];
                n2 = ResponseFilesParser.parseArgument(string, n2, objectArray);
                vector.addElement((String)objectArray[0]);
            }
            ++n2;
        }
        return vector;
    }

    public static Vector gatherOptions(String[] stringArray) {
        Vector<String[]> vector = new Vector<String[]>();
        int n = 1;
        while (n < stringArray.length - 1) {
            File file = new File(stringArray[n]);
            try {
                FileReader fileReader = new FileReader(file);
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                while (bufferedReader.ready()) {
                    String string = bufferedReader.readLine();
                    if (string.length() == 0 || string.startsWith("#")) continue;
                    try {
                        Object[] objectArray = new Object[1];
                        int n2 = 0;
                        n2 = ResponseFilesParser.parseOptionName(string, n2, objectArray);
                        String string2 = (String)objectArray[0];
                        Vector vector2 = ResponseFilesParser.gatherArguments(string, n2);
                        String[] stringArray2 = ResponseFilesParser.createOptionArray(string2, vector2);
                        vector.addElement(stringArray2);
                    }
                    catch (Exception exception) {
                        System.err.println("Error parsing " + string + " in response file " + stringArray[n] + ".");
                        System.err.println(exception.getMessage());
                    }
                }
                fileReader.close();
                bufferedReader.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("The response file " + stringArray[n] + " was not found.");
            }
            catch (IOException iOException) {
                System.err.println("Error processing response file " + stringArray[n] + ".");
            }
            ++n;
        }
        return vector;
    }

    private static int parseArgument(String string, int n, Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        while (ResponseFilesParser.canRead(string, n) && !Character.isWhitespace(string.charAt(n))) {
            if (string.charAt(n) == '\"') {
                Object[] objectArray2 = new Object[1];
                n = ResponseFilesParser.parseQuote(string, n, objectArray2);
                stringBuffer.append((String)objectArray2[0]);
                continue;
            }
            stringBuffer.append(string.charAt(n));
            ++n;
        }
        objectArray[0] = stringBuffer.toString();
        return n;
    }

    private static int parseOptionName(String string, int n, Object[] objectArray) throws Exception {
        if (string.startsWith("-")) {
            ++n;
        } else {
            throw new Exception("Expected '-' at offset " + n + ".");
        }
        Object[] objectArray2 = new Object[1];
        n = ResponseFilesParser.parseArgument(string, n, objectArray2);
        objectArray[0] = objectArray2[0];
        return n;
    }

    private static int parseQuote(String string, int n, Object[] objectArray) {
        int n2 = ++n;
        while (ResponseFilesParser.canRead(string, n) && string.charAt(n) != '\"') {
            ++n;
        }
        objectArray[0] = string.substring(n2, n);
        return ++n;
    }
}

