/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util.jvm;

import com.installshield.util.jvm.LauncherEntry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;

public class LaunchScript
extends LauncherEntry {
    static final char[] hexdigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private String[] classPath = null;
    private String title = "";
    private String mainClass = "";
    private Hashtable systemProperties = new Hashtable();
    private String otherArgs = "";
    private String mainClassArgs = "";
    private boolean consoleVisible = false;

    public LaunchScript() {
        this.setName("launch.txt");
    }

    private String formatValue(String string) {
        String string2 = "";
        int n = 0;
        int n2 = string.indexOf("\"", n);
        while (n2 >= 0) {
            string2 = String.valueOf(string2) + string.substring(n, n2 + 1);
            string2 = String.valueOf(string2) + "\"";
            n = n2 + 1;
            n2 = string.indexOf("\"", n);
        }
        if (n >= 0) {
            string2 = String.valueOf(string2) + string.substring(n);
        }
        return string2;
    }

    public String[] getClassPath() {
        return this.classPath;
    }

    public boolean getConsoleVisible() {
        return this.consoleVisible;
    }

    public InputStream getInputStream() throws IOException {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        if (this.title != null && this.title.length() > 0) {
            object = new StringBuffer();
            int n = 0;
            while (n < this.title.length()) {
                char c = this.title.charAt(n);
                if (c < '\u0000' || c > '\u007f') {
                    ((StringBuffer)object).append("\\u");
                    int n2 = (c & 0xF000) >> 12;
                    ((StringBuffer)object).append(hexdigits[n2]);
                    n2 = (c & 0xF00) >> 8;
                    ((StringBuffer)object).append(hexdigits[n2]);
                    n2 = (c & 0xF0) >> 4;
                    ((StringBuffer)object).append(hexdigits[n2]);
                    n2 = c & 0xF;
                    ((StringBuffer)object).append(hexdigits[n2]);
                } else {
                    ((StringBuffer)object).append(c);
                }
                ++n;
            }
            printWriter.write("DESC: ");
            printWriter.write(((StringBuffer)object).toString());
            printWriter.println("");
        }
        printWriter.write("DISPLAY_CONSOLE: " + (this.consoleVisible ? "1" : "0"));
        printWriter.println("");
        printWriter.write("COMMAND: @JVM_HOME@/@JVM_EXE@ ");
        printWriter.write("%CP%(");
        if (this.classPath != null) {
            int n = 0;
            while (n < this.classPath.length) {
                if (n != 0) {
                    printWriter.write(", ");
                }
                printWriter.write("\"" + this.formatValue(this.classPath[n]) + "\"");
                ++n;
            }
        }
        printWriter.write(") ");
        if (this.systemProperties != null) {
            object = this.systemProperties.keys();
            while (object.hasMoreElements()) {
                Object e = object.nextElement();
                Object v = this.systemProperties.get(e);
                if (v == null) continue;
                printWriter.write("%SYSTEMPROP%(\"" + this.formatValue(e.toString()) + "\", \"" + this.formatValue(v.toString()) + "\") ");
            }
        }
        printWriter.write("%RUNTIME_SYSTEMPROP%() ");
        if (this.otherArgs != null && this.otherArgs.length() > 0) {
            printWriter.write(String.valueOf(this.otherArgs) + " ");
        }
        printWriter.write("%RUNTIME_JAVAARGS%() ");
        if (this.mainClass != null && this.mainClass.length() > 0) {
            printWriter.write(String.valueOf(this.mainClass) + " ");
        }
        if (this.mainClassArgs != null && this.mainClassArgs.length() > 0) {
            printWriter.write(String.valueOf(this.mainClassArgs) + " ");
        }
        printWriter.println("");
        printWriter.flush();
        object = byteArrayOutputStream.toByteArray();
        printWriter.close();
        byteArrayOutputStream.close();
        return new ByteArrayInputStream((byte[])object);
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public String getMainClassArgs() {
        return this.mainClassArgs;
    }

    public String getOtherArgs() {
        return this.otherArgs;
    }

    public Dictionary getSystemProperties() {
        return this.systemProperties;
    }

    public String getTitle() {
        return this.title;
    }

    public int getType() {
        return 2;
    }

    public void setClassPath(String[] stringArray) {
        this.classPath = stringArray;
    }

    public void setConsoleVisible(boolean bl) {
        this.consoleVisible = bl;
    }

    public void setMainClass(String string) {
        this.mainClass = string;
    }

    public void setMainClassArgs(String string) {
        this.mainClassArgs = string;
    }

    public void setOtherArgs(String string) {
        this.otherArgs = string;
    }

    public void setSystemProperties(Dictionary dictionary) {
        this.systemProperties.clear();
        Enumeration enumeration = dictionary.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            this.systemProperties.put(k, dictionary.get(k));
        }
    }

    public void setTitle(String string) {
        this.title = string;
    }
}

