/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.awt;

import com.installshield.wizard.WizardBean;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.awt.AWTWizardBean;
import com.installshield.wizard.awt.FlowLabel;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class ErrorMessagePanel
extends WizardBean
implements AWTWizardBean,
ActionListener {
    private String errorMessage = "";
    private Panel contentPane = null;
    private FlowLabel label = null;

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            StringSelection stringSelection = new StringSelection(this.errorMessage);
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
        }
        catch (Throwable throwable) {
            System.err.println("could not copy error message " + this.errorMessage + " to clipboard");
            throwable.printStackTrace();
        }
    }

    public boolean entered(WizardBeanEvent wizardBeanEvent) {
        return true;
    }

    public void exited(WizardBeanEvent wizardBeanEvent) {
    }

    public Component getComponent() {
        return this.contentPane;
    }

    public String getDescription() {
        return "$L(com.installshield.wizard.i18n.WizardResources, ErrorMessagePanel.description)";
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getNavigationOptions() {
        return 0;
    }

    public String getTitle() {
        return "$L(com.installshield.wizard.i18n.WizardResources, ErrorMessagePanel.title)";
    }

    public void initializeComponent(WizardBeanEvent wizardBeanEvent) {
        this.contentPane = new Panel(new BorderLayout());
        this.label = new FlowLabel(this.errorMessage);
        this.contentPane.add((Component)this.label, "Center");
        Panel panel = new Panel(new FlowLayout(1));
        this.contentPane.add((Component)panel, "South");
        Button button = new Button("Copy Message to Clipboard");
        panel.add(button);
        button.addActionListener(this);
    }

    public boolean isComponentInitialized() {
        return this.label != null;
    }

    public boolean queryEnter(WizardBeanEvent wizardBeanEvent) {
        return true;
    }

    public boolean queryExit(WizardBeanEvent wizardBeanEvent) {
        return true;
    }

    public void setErrorMessage(String string) {
        String string2 = this.errorMessage = string != null ? string : "";
        if (this.label != null) {
            this.label.setText(string);
        }
    }
}

