/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.awt;

import com.installshield.wizard.awt.ButtonPanel;
import com.installshield.wizard.awt.FlowLabel;
import com.installshield.wizard.awt.InsetsPanel;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class MessageDialog
extends Dialog
implements ActionListener,
WindowListener,
FocusListener {
    private int result = 0;
    private Button[] buttons;
    private int transferFocusCount = 0;
    private final int captionWidth = 10;

    public MessageDialog(Frame frame, String string, String string2, String[] stringArray) {
        super(frame, string2, true);
        Component component;
        this.setForeground(SystemColor.controlText);
        this.setLayout(new BorderLayout());
        InsetsPanel insetsPanel = new InsetsPanel(10, 10, 5, 10);
        insetsPanel.setLayout(new BorderLayout(0, 5));
        this.add((Component)insetsPanel, "Center");
        ((Component)this).setBackground(SystemColor.control);
        this.addWindowListener(this);
        FlowLabel flowLabel = new FlowLabel(string);
        flowLabel.setMinimumSize(new Dimension(500, 0));
        insetsPanel.add((Component)flowLabel, "Center");
        Panel panel = new Panel(new FlowLayout(1));
        insetsPanel.add((Component)panel, "South");
        ButtonPanel buttonPanel = new ButtonPanel(1);
        panel.add(buttonPanel);
        this.buttons = new Button[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].startsWith("*")) {
                stringArray[n] = stringArray[n].substring(1);
                this.transferFocusCount = n;
            }
            component = new Button(this.pad(stringArray[n]));
            buttonPanel.addButton((Button)component);
            ((Button)component).addActionListener(this);
            component.addFocusListener(this);
            this.buttons[n] = component;
            ++n;
        }
        this.pack();
        component = frame;
        synchronized (component) {
            Dimension dimension = frame.isVisible() ? frame.getSize() : Toolkit.getDefaultToolkit().getScreenSize();
            Point point = frame.isVisible() ? frame.getLocation() : new Point(0, 0);
            ((Component)this).setLocation(point.x + (dimension.width - this.getSize().width) / 2, point.y + (dimension.height - this.getSize().height) / 2);
        }
        this.setResizable(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.result = -1;
        int n = 0;
        while (n < this.buttons.length) {
            if (this.buttons[n] == actionEvent.getSource()) {
                this.result = n;
                break;
            }
            ++n;
        }
        ((Component)this).setVisible(false);
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.transferFocusCount > 0) {
            focusEvent.getComponent().transferFocus();
            --this.transferFocusCount;
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public static Frame getParentFrame(Component component) {
        Container container = component.getParent();
        if (container instanceof Frame) {
            return (Frame)container;
        }
        if (container != null) {
            return MessageDialog.getParentFrame(container);
        }
        return null;
    }

    public int getResult() {
        return this.result;
    }

    private String pad(String string) {
        int n = 10 - string.length();
        if (n > 0) {
            n /= 2;
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(' ');
                ++n2;
            }
            stringBuffer.append(string);
            int n3 = 0;
            while (n3 < n) {
                stringBuffer.append(' ');
                ++n3;
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.result = -1;
        ((Component)this).setVisible(false);
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

