/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.service.log;

import com.installshield.wizard.service.AbstractServiceImplementor;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.WizardServices;
import com.installshield.wizard.service.file.FileService;
import com.installshield.wizard.service.log.LogServiceImplementor;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class PureJavaLogServiceImpl
extends AbstractServiceImplementor
implements LogServiceImplementor {
    private String output = null;
    private boolean resolvingFileName = false;
    private PrintWriter log = null;
    private String optionalOutput = null;
    private boolean resolvingOptionalFileName = false;
    private PrintWriter optionalLog = null;

    private void closeLogOutput() throws ServiceException {
        if (this.log != null) {
            this.log.close();
            this.log = null;
        }
    }

    private void closeOptionalLogOutput() throws ServiceException {
        if (this.optionalLog != null) {
            this.optionalLog.close();
            this.optionalLog = null;
        }
    }

    private String createDefaultLogOutput() throws ServiceException {
        String string = this.getFileService().getNamedDirectory("log");
        if (string != null) {
            String string2 = "Undefpurpose";
            String string3 = "Undefname";
            String string4 = System.getProperties().getProperty("file.separator");
            string = String.valueOf(string) + string4 + PureJavaLogServiceImpl.getLogName(string2, string3, "");
            return string;
        }
        throw new ServiceException(399, "could not create log file");
    }

    private FileService getFileService() throws ServiceException {
        WizardServices wizardServices = this.getServices();
        return (FileService)wizardServices.getService("fileService");
    }

    private static String getLogName(String string, String string2, String string3) {
        string2 = string2.replace(' ', '_');
        string2 = string2.replace('/', '-');
        string2 = string2.replace('\\', '-');
        String string4 = String.valueOf(string2) + "_" + string;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMddhhmm");
        Date date = new Date();
        string4 = String.valueOf(string4) + "." + string3 + simpleDateFormat.format(date);
        return string4;
    }

    public String getLogOutput() throws ServiceException {
        return this.output;
    }

    public String getOptionalLogOutput() throws ServiceException {
        return this.optionalOutput;
    }

    public int getSystemCompatibility() {
        return 1;
    }

    public void setLogOutput(String string) throws ServiceException {
        if (!this.resolvingFileName) {
            this.resolvingFileName = true;
            this.closeLogOutput();
            this.output = this.getServices().resolveString(string);
            this.resolvingFileName = false;
        }
    }

    public void setOptionalLogOutput(String string) throws ServiceException {
        if (!this.resolvingOptionalFileName) {
            this.resolvingOptionalFileName = true;
            this.closeOptionalLogOutput();
            this.optionalOutput = this.getServices().resolveString(string);
            this.resolvingOptionalFileName = false;
        }
    }

    public synchronized void writeToOptionalOutput(String string) throws ServiceException {
        if (this.optionalOutput != null) {
            try {
                this.closeOptionalLogOutput();
                this.optionalLog = new PrintWriter(new FileWriter(this.optionalOutput, true));
                this.optionalLog.println(string);
                this.optionalLog.flush();
                this.closeOptionalLogOutput();
            }
            catch (IOException iOException) {
                throw new ServiceException(iOException);
            }
        } else {
            throw new ServiceException(399, "optional log file is not defined");
        }
    }

    public synchronized void writeToOutput(String string) throws ServiceException {
        if (this.output == null || this.output.equals("")) {
            this.output = this.createDefaultLogOutput();
        }
        try {
            this.closeLogOutput();
            this.log = new PrintWriter(new FileWriter(this.output, true));
            this.log.println(string);
            this.log.flush();
            this.closeLogOutput();
        }
        catch (IOException iOException) {
            throw new ServiceException(iOException);
        }
    }
}

