/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.panels;

import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.TTYDisplay;
import com.installshield.wizard.Wizard;
import com.installshield.wizard.WizardBean;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.WizardPanel;
import com.installshield.wizard.WizardTreeIterator;
import com.installshield.wizard.awt.InsetsPanel;
import com.installshield.wizard.console.ConsoleWizardBean;
import com.installshield.wizardx.ui.ConsoleContainer;
import com.installshield.wizardx.ui.ConsoleUIComponent;
import com.installshield.wizardx.ui.TextDisplayComponent;
import java.awt.Component;
import java.awt.Container;
import java.io.IOException;

public class ExtendedWizardPanel
extends WizardPanel
implements ConsoleWizardBean {
    private TextDisplayComponent caption = null;
    private Wizard wizard = null;
    private boolean consoleInteraction = false;
    private ConsoleContainer consoleContainer = new ConsoleContainer();
    static /* synthetic */ Class class$com$installshield$wizardx$panels$ExtendedWizardPanel;
    static /* synthetic */ Class class$com$installshield$wizardx$i18n$WizardXResources;

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        try {
            wizardBuilderSupport.putClass((class$com$installshield$wizardx$panels$ExtendedWizardPanel != null ? class$com$installshield$wizardx$panels$ExtendedWizardPanel : (class$com$installshield$wizardx$panels$ExtendedWizardPanel = ExtendedWizardPanel.class$("com.installshield.wizardx.panels.ExtendedWizardPanel"))).getName());
            wizardBuilderSupport.putResourceBundles((class$com$installshield$wizardx$i18n$WizardXResources != null ? class$com$installshield$wizardx$i18n$WizardXResources : (class$com$installshield$wizardx$i18n$WizardXResources = ExtendedWizardPanel.class$("com.installshield.wizardx.i18n.WizardXResources"))).getName(), wizardBuilderSupport.getSelectedLocales());
            wizardBuilderSupport.putPackage("com.installshield.wizardx.ui");
            wizardBuilderSupport.putPackage("com.installshield.wizard.awt");
            wizardBuilderSupport.putClass("com.installshield.wizard.console.ConsoleWizardBean");
            wizardBuilderSupport.putPackage("ice.htmlbrowser", true);
        }
        catch (IOException iOException) {
            wizardBuilderSupport.logEvent(this, "err", iOException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void componentConsoleInteraction(Container container) {
        if (container != null) {
            Component[] componentArray = container.getComponents();
            int n = 0;
            while (n < componentArray.length) {
                Component component = componentArray[n];
                if (component instanceof Container && !(component instanceof ConsoleUIComponent)) {
                    this.componentConsoleInteraction((Container)component);
                } else if (component instanceof ConsoleUIComponent) {
                    ((ConsoleUIComponent)((Object)component)).consoleInteraction();
                } else {
                    this.logEvent(this, "wrn", "Component is not of type ConsoleInteraction " + component);
                }
                ++n;
            }
        }
    }

    public void consoleInitialize(WizardBeanEvent wizardBeanEvent) {
        if (this.wizard == null) {
            this.wizard = wizardBeanEvent.getWizard();
        }
        this.consoleInteraction = true;
        this.initialize();
    }

    public void consoleInteraction(WizardBeanEvent wizardBeanEvent) {
        this.componentConsoleInteraction(this.getContentPane());
        TTYDisplay.showNewline();
        String string = this.isLastIterativeBean() ? LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "pressEnterToExit") : LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "pressEnterToContinue");
        TTYDisplay.queryValue(string);
    }

    protected void createUI(WizardBeanEvent wizardBeanEvent) {
        this.initialize();
        this.caption.createComponentUI();
        Container container = this.getContentPane();
        container.remove(this.caption);
        container.add((Component)this.caption, "North");
    }

    public Container getContentPane() {
        if (this.isConsoleInteraction()) {
            return this.consoleContainer;
        }
        return super.getContentPane();
    }

    public Container getPane() {
        if (this.isConsoleInteraction()) {
            return new ConsoleContainer();
        }
        return new InsetsPanel();
    }

    protected void initialize() {
        this.caption = new TextDisplayComponent(this.resolveString(this.getDescription()), true);
        this.getContentPane().add(this.caption);
    }

    public boolean isConsoleInteraction() {
        return this.consoleInteraction;
    }

    private boolean isLastIterativeBean() {
        WizardBean wizardBean;
        WizardTreeIterator wizardTreeIterator = this.wizard.getIterator();
        return wizardTreeIterator.getNext(wizardBean = this.wizard.getCurrentBean()) == wizardTreeIterator.end();
    }
}

