/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizardx.ui;

import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.TTYDisplay;
import com.installshield.wizardx.ui.AbstractUIComponent;
import com.installshield.wizardx.ui.ConsoleUIComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.TextListener;
import java.util.Enumeration;
import java.util.Hashtable;

public class TextInputComponent
extends AbstractUIComponent
implements ConsoleUIComponent {
    private static final int BORDER_LAYOUT = 1;
    private static final int FLOW_LAYOUT = 2;
    private int rows;
    private int columns;
    private String text;
    private String caption = "";
    private boolean isPassword = false;
    private boolean isLineWrap = false;
    private int layout = 1;
    private TextComponent comp;
    private boolean canContinue = true;
    private Hashtable actionListeners;
    private Hashtable keyListeners;
    private Hashtable textListeners;

    public TextInputComponent() {
        this("");
    }

    public TextInputComponent(int n, int n2) {
        this("", n, n2, false);
    }

    public TextInputComponent(int n, int n2, boolean bl) {
        this("", n, n2, bl);
    }

    public TextInputComponent(String string) {
        this(string, 0, 0, false);
    }

    public TextInputComponent(String string, int n, int n2, boolean bl) {
        this.text = string;
        this.rows = n;
        this.columns = n2;
        this.isLineWrap = bl;
    }

    public TextInputComponent(String string, boolean bl) {
        this(string, 0, 0, bl);
    }

    public void addActionListener(ActionListener actionListener) {
        if (this.actionListeners == null) {
            this.actionListeners = new Hashtable();
        }
        this.actionListeners.put(actionListener, actionListener);
        if (this.comp != null && this.comp instanceof TextField) {
            ((TextField)this.comp).addActionListener(actionListener);
        }
    }

    private void addComponent(TextComponent textComponent) {
        if (this.layout == 1) {
            this.add((Component)textComponent, "North");
        } else {
            this.add(textComponent);
        }
    }

    public void addKeyListener(KeyListener keyListener) {
        if (this.keyListeners == null) {
            this.keyListeners = new Hashtable();
        }
        this.keyListeners.put(keyListener, keyListener);
        if (keyListener != null && this.comp != null) {
            this.comp.addKeyListener(keyListener);
        }
    }

    public void addTextListener(TextListener textListener) {
        if (this.textListeners == null) {
            this.textListeners = new Hashtable();
        }
        this.textListeners.put(textListener, textListener);
        if (textListener != null && this.comp != null) {
            this.comp.addTextListener(textListener);
        }
    }

    public boolean canContinue() {
        return this.canContinue;
    }

    private void checkEchoCharacter() {
        if (this.comp instanceof TextField) {
            if (this.isPassword() && !((TextField)this.comp).echoCharIsSet()) {
                ((TextField)this.comp).setEchoChar('*');
            } else if (((TextField)this.comp).echoCharIsSet() && !this.isPassword()) {
                this.remove(this.comp);
                this.comp = new TextField(this.text, this.columns);
                this.addComponent(this.comp);
            }
        }
    }

    public void consoleInteraction() {
        TTYDisplay tTYDisplay = this.getTTYDisplay();
        boolean bl = true;
        do {
            if (!bl && this.isPassword()) {
                TTYDisplay.showText(LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "TextInputComponent.invalidTextEntered", new String[]{this.getText()}));
            }
            TTYDisplay.showNewline();
            this.text = TTYDisplay.queryValue(this.getCaption(), this.getText(), "");
            this.setText(this.text);
            this.informListeners();
            bl = this.canContinue;
        } while (!this.canContinue);
    }

    public void createComponentUI() {
        this.validateLayout();
        if (this.rows > 1) {
            this.comp = this.createTextArea(this.text, this.rows, this.columns, this.isLineWrap);
        } else {
            this.comp = new TextField(this.text, this.columns);
            if (this.isPassword()) {
                this.checkEchoCharacter();
            }
        }
        this.addComponent(this.comp);
    }

    private TextArea createTextArea(String string, int n, int n2, boolean bl) {
        if (bl) {
            return new TextArea(string, n, n2, 1);
        }
        return new TextArea(string, n, n2);
    }

    public String getCaption() {
        return this.caption;
    }

    public int getColumns() {
        return this.columns;
    }

    public int getRows() {
        return this.rows;
    }

    public String getText() {
        if (this.comp != null) {
            return this.comp.getText();
        }
        return this.text;
    }

    private void informActionListeners() {
        ActionEvent actionEvent = new ActionEvent(new Object(), 1001, this.text);
        if (this.actionListeners != null) {
            Enumeration enumeration = this.actionListeners.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                ActionListener actionListener = (ActionListener)this.actionListeners.get(k);
                if (actionListener == null) continue;
                actionListener.actionPerformed(actionEvent);
            }
        }
    }

    private void informListeners() {
        this.informActionListeners();
    }

    public boolean isLineWrap() {
        return this.isLineWrap;
    }

    public boolean isPassword() {
        return this.isPassword;
    }

    public void removeActionListener(ActionListener actionListener) {
        if (this.actionListeners != null) {
            this.actionListeners.remove(actionListener);
        }
        if (this.comp != null && this.comp instanceof TextField) {
            ((TextField)this.comp).removeActionListener(actionListener);
        }
    }

    public void removeKeyListener(KeyListener keyListener) {
        if (this.keyListeners != null) {
            this.keyListeners.remove(keyListener);
        }
        if (keyListener != null && this.comp != null) {
            this.comp.removeKeyListener(keyListener);
        }
    }

    public void removeTextListener(TextListener textListener) {
        if (this.textListeners != null) {
            this.textListeners.remove(textListener);
        }
        if (textListener != null && this.comp != null) {
            this.comp.removeTextListener(textListener);
        }
    }

    public void requestFocus() {
        if (this.comp != null) {
            this.comp.requestFocus();
        }
    }

    public void setCaption(String string) {
        this.caption = string;
    }

    public void setColumns(int n) {
        this.columns = n;
        if (this.comp instanceof TextArea) {
            ((TextArea)this.comp).setColumns(n);
        } else {
            ((TextField)this.comp).setColumns(n);
        }
        this.validateLayout();
        this.checkEchoCharacter();
    }

    public void setContinue(boolean bl) {
        this.canContinue = bl;
    }

    public void setLineWrap(boolean bl) {
        this.isLineWrap = bl;
        if (this.comp != null && this.comp instanceof TextArea) {
            this.remove(this.comp);
            this.comp = this.createTextArea(this.text, this.getRows(), this.getColumns(), bl);
            this.addComponent(this.comp);
        }
    }

    public void setPassword(boolean bl) {
        this.isPassword = bl;
        this.checkEchoCharacter();
    }

    public void setRows(int n) {
        this.rows = n;
        if (this.comp != null) {
            if (n > 1) {
                if (this.comp instanceof TextArea) {
                    ((TextArea)this.comp).setRows(n);
                } else if (this.comp instanceof TextField) {
                    this.remove(this.comp);
                    this.comp = this.createTextArea(this.text, n, this.columns, this.isLineWrap);
                    this.addComponent(this.comp);
                }
            } else if (this.comp instanceof TextArea) {
                this.remove(this.comp);
                this.comp = new TextField(this.text, this.columns);
                this.validateLayout();
                this.addComponent(this.comp);
            }
        }
    }

    public void setText(String string) {
        this.text = string;
        if (this.comp != null) {
            this.comp.setText(string);
        }
    }

    private void validateLayout() {
        if (this.getColumns() > 0 || this.getRows() > 0) {
            this.layout = 2;
            this.setLayout(new FlowLayout(0));
        } else {
            this.layout = 1;
            this.setLayout(new BorderLayout());
        }
    }
}

