/*
 * Decompiled with CFR 0.152.
 */
package ice.htmlbrowser;

import ice.htmlbrowser.Box;
import ice.htmlbrowser.DocContainer;
import ice.htmlbrowser.FormChoice;
import ice.htmlbrowser.FormEntry;
import ice.htmlbrowser.FormInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.List;
import java.util.Vector;

class BoxSelect
extends Box
implements FormEntry {
    private FormInfo form;
    private List list;
    private FormChoice choice;
    private String name;
    private boolean multiple;
    private Vector defaults;
    private Vector optionValues;
    private String curOptionValue;
    private boolean curSelected = false;
    private boolean flagParsing = false;

    BoxSelect(DocContainer docContainer, FormInfo formInfo, String string, int n, boolean bl) {
        super(docContainer);
        this.form = formInfo;
        this.name = string;
        this.multiple = bl;
        if (n > 1) {
            this.list = new List(n, bl);
        } else {
            this.choice = new FormChoice();
        }
        this.optionValues = new Vector();
        this.defaults = new Vector();
    }

    void beginOption(String string, boolean bl) {
        this.curOptionValue = string;
        this.curSelected = bl;
        this.flagParsing = true;
    }

    void endOption(String string) {
        if (!this.flagParsing) {
            return;
        }
        this.flagParsing = false;
        string = string.trim();
        string = string.replace('\n', ' ');
        if (this.curOptionValue == null) {
            this.curOptionValue = string;
        }
        this.optionValues.addElement(this.curOptionValue);
        if (this.curSelected) {
            Integer n = new Integer(this.optionValues.size() - 1);
            if (this.multiple || this.defaults.size() < 1) {
                this.defaults.addElement(n);
            } else {
                this.defaults.setElementAt(n, 0);
            }
        }
        if (this.list != null) {
            this.list.add(string);
            if (this.curSelected) {
                this.list.select(this.optionValues.size() - 1);
            }
        } else {
            this.choice.add(string);
            if (this.curSelected) {
                this.choice.select(this.optionValues.size() - 1);
            }
        }
        this.curOptionValue = null;
        this.curSelected = false;
    }

    void finishSelect() {
        Component component = this.choice;
        if (component == null) {
            component = this.list;
        }
        this.doc.setAWTComponent(this, component);
        Dimension dimension = component.getPreferredSize();
        this.resize(dimension.width, dimension.height);
        component.setSize(dimension.width, dimension.height);
        component.setBackground(Color.lightGray);
    }

    int getBaseLine() {
        return this.height - 4;
    }

    public int getNumValues() {
        if (this.list != null && this.multiple) {
            int[] nArray = this.list.getSelectedIndexes();
            return nArray.length;
        }
        return 1;
    }

    public String getName(int n) {
        return this.name;
    }

    public String getValue(int n) {
        int n2 = -1;
        if (this.list != null) {
            if (this.multiple) {
                int[] nArray = this.list.getSelectedIndexes();
                if (n < 0 || n >= nArray.length) {
                    return null;
                }
                n2 = nArray[n];
            } else {
                n2 = this.list.getSelectedIndex();
            }
        } else {
            n2 = this.choice.getSelectedIndex();
        }
        if (n2 < 0 || n2 >= this.optionValues.size()) {
            return null;
        }
        return (String)this.optionValues.elementAt(n2);
    }

    public void reset() {
        if (this.list != null) {
            int n = this.list.getItemCount();
            int n2 = 0;
            while (n2 < n) {
                this.list.deselect(n2);
                ++n2;
            }
            n = this.defaults.size();
            n2 = 0;
            while (n2 < n) {
                this.list.select((Integer)this.defaults.elementAt(n2));
                ++n2;
            }
            return;
        }
        if (this.defaults.size() > 0) {
            this.choice.select((Integer)this.defaults.elementAt(0));
        }
    }
}

