#!/system/bin/sh
#=====================================================
# Leon Liu
# 2012/01/04
# updatedd-2.6    Planet DDNS
# check wan ip to update DDNS server
# wan interface: eth2.2
#=====================================================
#
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/system/lib/updatedd

while [ 1 ];do
	if [ -f "/system/etc/DDNS.config" ]; then
		break
	else
		sleep 3
	fi
done
echo status=error > /etc/ddns_status
wan_mode=`busybox sed -n '1p' /system/etc/DDNS.config`
srv=`busybox sed -n '3p' /system/etc/DDNS.config`
ddns=`busybox sed -n '6p' /system/etc/DDNS.config`
u=`busybox sed -n '4p' /system/etc/DDNS.config`
pw=`busybox sed -n '5p' /system/etc/DDNS.config`
opmode="1"
ez=`busybox sed -n '2p' /system/etc/DDNS.config`
host="planetddns.com"
i=0
maxTimes=2

# Leon Liu 2011/10/17 add Vlan tag interface

# Leon Liu 2011/10/17 add Vlan tag interface

# Leon Liu 2011/10/17 add Vlan tag interface

	wan_if="eth0"

# Leon Liu 2011/10/17 add Vlan tag interface

echo "0.0.0.0" >  /etc/old_wanip


# Disable
#if [ "$ez" == "0" ]; then
#		exit 0
#fi
		
# Dynamic DDNS check		
#if [ "$ez" == "2" ]; then
#	if [ "$srv" == "" -o "$srv" == "none" ]; then
#		exit 0
#	fi
#fi

#if [ "$ez" == "2" ]; then
#	if [ "$ddns" = "" -o "$u" = "" -o "$pw" = "" ]; then
#		exit 0
#	fi
#fi

# only support gateway mode
#if [ "$opmode" != "1" ]; then
#	exit 0
#fi

# debug
echo "srv=$srv"
echo "ddns=$ddns"
echo "u=$u"
echo "pw=$pw"
echo "host=$host"
## planet DDNS, Easy DDNS and Dynamic DDNS
if [ "$srv" == "planet" -o "$ez" == "1" ] ; then
	## planet parameter MAC, firmware version , model name
	wan_mac=`busybox ifconfig "$wan_if" | busybox sed -n '1p' | busybox sed 's/^.*HWaddr //g'`
	echo "wan_mac = $wan_mac"
	if [ -f /etc_ro/version ] ; then
		fw=`busybox cat /etc_ro/version |awk '{print $1}'`
	else
		echo "not found config /etc_ro/version"
	fi
	if [ -f /etc_ro/model ] ; then
		model=`busybox cat /etc_ro/model |awk '{print $1}'`
	else
		echo "not found config /etc_ro/model"
	fi
	## every 2 minute check once
	while [ 1 ];do
		ez=`busybox sed -n '2p' /system/etc/DDNS.config`
		if [ "$ez" == "0" ]; then
			continue
		fi
		if [ "$wan_mode" = "PPPOE" -o  "$wan_mode" = "L2TP" -o "$wan_mode" = "PPTP"  ]; then
			new_ip=`busybox ifconfig ppp0 | grep 'inet ' | busybox sed 's/^.*addr://g' |busybox sed 's/  P-t-P.*$//g'`
		else
			new_ip=`busybox ifconfig "$wan_if" | grep 'inet ' | busybox sed 's/^.*addr://g' |busybox sed 's/  Bcast.*$//g'`
		fi
		old_ip=`cat /etc/old_wanip |awk '{print $1}'`
		if [ "$new_ip" != "" ];then
			if [ "$new_ip" != "$old_ip" ];then
				echo status=error > /etc/ddns_status
				echo "==== change ip , do DDNS update ! ===="
				echo "updatedd -Y $srv -- -m $wan_mac -f $fw -p $model $u:$pw $ddns.planetddns.com"
				if [ "$ez" == "2" ]; then
					echo "updatedd -Y $srv -- -m $wan_mac -f $fw -p $model $u:$pw $ddns.planetddns.com"
					updatedd -Y $srv -- -m $wan_mac -f $fw -p $model $u:$pw $ddns.$host 
				else
					echo "updatedd -Y $srv -- -m $wan_mac -f $fw -p $model -e easy $u:$pw"
					updatedd -Y planet -- -m $wan_mac -f $fw -p $model -e easy $u:$pw
				fi
				sleep 5
				server_msg=`cat /etc/ddns_status |awk '{print $1}'`
				echo "server massage:$server_msg"
				if [ "$server_msg" = "status=0" -o "$server_msg" = "status=1" ];then
					echo "==== DDNS successfully updated ===="
					echo $new_ip > /etc/old_wanip
				elif [ "$server_msg" = "status=2" -o "$server_msg" = "status=3" -o "$server_msg" = "status=4" -o "$server_msg" = "status=5" -o "$server_msg" = "status=6" ]; then
					echo "==== DDNS update fail !!! , status=2~6 ===="
				else
					echo "==== Server not reply ===="
				fi

			else
				if [ "$i" -ne "$maxTimes" ]; then
					i=$(($i+1))
					continue
				fi
				echo status=error > /etc/ddns_status
				echo "==== no change ip ===="
				if [ "$ez" == "2" ]; then
					echo "updatedd -Y $srv -- -m $wan_mac -f $fw -p $model $u:$pw $ddns.planetddns.com"
					updatedd -Y $srv -- -m $wan_mac -f $fw -p $model $u:$pw $ddns.$host 
				else
					echo "updatedd -Y $srv -- -m $wan_mac -f $fw -p $model -e easy $u:$pw"
					updatedd -Y planet -- -m $wan_mac -f $fw -p $model -e easy $u:$pw
				fi
				i=0
				sleep 5
				server_msg=`cat /etc/ddns_status |awk '{print $1}'`
				echo "server massage:$server_msg"
				if [ "$server_msg" = "status=0" -o "$server_msg" = "status=1" ];then
					echo "==== DDNS successfully updated ===="
					echo $new_ip > /etc/old_wanip
				elif [ "$server_msg" = "status=2" -o "$server_msg" = "status=3" -o "$server_msg" = "status=4" -o "$server_msg" = "status=5" -o "$server_msg" = "status=6" ]; then
					echo "====$srv DDNS update fail !!! , status=2~6 ===="
				else
					echo "====$srv Server not reply ===="
				fi
			fi
		else
			echo status=error > /etc/ddns_status
		fi

		sleep 120 
	done
### other provider
else
	## every 2 minute check once
	while [ 1 ];do
		ez=`busybox sed -n '2p' /system/etc/DDNS.config`
		if [ "$ez" == "0" ]; then
			continue
		fi
		if [ "$wan_mode" = "PPPOE" -o  "$wan_mode" = "L2TP" -o "$wan_mode" = "PPTP"  ]; then
			new_ip=`busybox ifconfig ppp0 | grep 'inet ' | sed 's/^.*addr://g' |sed 's/  P-t-P.*$//g'`
		else
			new_ip=`busybox ifconfig "$wan_if" | grep 'inet ' | busybox sed 's/^.*addr://g' |busybox sed 's/  Bcast.*$//g'`
		fi
		old_ip=`cat /etc/old_wanip |awk '{print $1}'`
		if [ "$new_ip" != "" ];then
			if [ "$new_ip" != "$old_ip" ];then
				echo status=error > /etc/ddns_status
				echo "==== change ip , do DDNS update ! ===="
				echo "updatedd -Y $srv $u:$pw $ddns"
				updatedd -Y $srv $u:$pw $ddns 
				sleep 5 
				server_msg=`cat /etc/ddns_status |awk '{print $1}'`
				echo "server massage:$server_msg"
				if [ "$server_msg" = "status=ok" ];then
					echo "==== DDNS successfully updated ===="
					echo $new_ip > /etc/old_wanip
				elif [ "$server_msg" = "status=2" -o "$server_msg" = "status=3" -o "$server_msg" = "status=4" -o "$server_msg" = "status=5" -o "$server_msg" = "status=6" ]; then
					echo "==== DDNS update fail !!! , status=2~6 ===="
				else
					echo "==== Server not reply ===="
				fi
			else
				if [ "$i" -ne "$maxTimes" ]; then
					i=$(($i+1))
					continue
				fi
				echo status=error > /etc/ddns_status
				echo "==== no change ip ===="
				updatedd -Y $srv $u:$pw $ddns 
				i=0
				sleep 5 
				server_msg=`cat /etc/ddns_status |awk '{print $1}'`
				echo "server massage:$server_msg"
				if [ "$server_msg" = "status=ok" ];then
					echo "==== DDNS successfully updated ===="
					echo $new_ip > /etc/old_wanip
				elif [ "$server_msg" = "status=2" -o "$server_msg" = "status=3" -o "$server_msg" = "status=4" -o "$server_msg" = "status=5" -o "$server_msg" = "status=6" ]; then
					echo "====$srv DDNS update fail !!! , status=2~6 ===="
				else
					echo "====$srv Server not reply ===="
				fi
			fi
		else
			echo status=error > /etc/ddns_status
		fi
		sleep 120 
	done
fi
exit 0