#!/system/bin/sh

#DEBUG_DIR=debug_$(date +%Y-%m-%d-%H-%M-%S)

DEBUG_PATH="/sdcard"
UDISK_PATH="/udisk"

#CHECk_PATHĬ·Ϊ/sdcard 
CHECK_PATH="/sdcard"
DEBUG_DIR="debug"
DEBUG_DIR_PATH=${CHECK_PATH}'/debug'
DEBUG_STATE="/data/data/com.fanvil.debugreporter/debugmode"
DEBUG_PATH_FILE="/data/data/com.fanvil.debugreporter/debugpath"

MODULE_RECOVERY_DIR="recovery"
MODULE_RECOVERY_DIR_PATH=${DEBUG_DIR_PATH}/${MODULE_RECOVERY_DIR}
CACHE_PATH="/cache"
RECOVERY_PATH="/cache/recovery"

MODULE_NETWORK_DIR="network"
MODULE_NETWORK_DIR_PATH=${DEBUG_DIR_PATH}/${MODULE_NETWORK_DIR}

MODULE_CM_DIR="cm"
MODULE_CM_DIR_PATH=${DEBUG_DIR_PATH}/${MODULE_CM_DIR}
VERSION_PATH="/system/etc/mt"
VERSION_DIR="version"
PRODUCT="product"
CALLMANAGER_PATH="/data/data/com.fanvil.callmanager"
CONFIG_FILE="config.txt"

MODULE_ANDROID_DIR="android"
MODULE_ANDROID_DIR_PATH=${DEBUG_DIR_PATH}/${MODULE_ANDROID_DIR}
DATA_PATH="/data"
ANR_PATH="/data/anr"
ANR_DIR="anr"
TRACES_FILE="traces.txt"
TOMBSTONES_PATH="/data/tombstones"
TOMBSTONES_DIR="tombstones"
DROPBOX_PATH="/data/system/dropbox"
DROPBOX_DIR="dropbox"
DATA_DHCP_PATH="/data/misc/dhcp"
DATA_BLUETOOTHD_PATH="/data/misc/bluetoothd"
DATA_BLUETOOTH_PATH="/data/misc/bluetooth"
ETC_PATH="/system/etc"
SYSTEM_PATH="/system"
BUILD_PROP="build.prop"
DEFAULT_PROP="default.prop"
PROP_DIR="property"
DHCP_DIR="dhcp"
BLUETOOTH_DIR="bluetooth"

MODULE_LINUX_DIR="linux"
MODULE_LINUX_DIR_PATH=${DEBUG_DIR_PATH}/${MODULE_LINUX_DIR}
DIR_AUDIO="audio"
DIR_SYSINFO="sysinfo"
DIR_RUNTIME="runtime"

DUMPFILE_TCPDUMP=${MODULE_NETWORK_DIR_PATH}/tcpdump-$(date +%Y-%m-%d-%H-%M-%S).pcap
DUMPFILE_IFTOP=${MODULE_NETWORK_DIR_PATH}/iftop-$(date +%Y-%m-%d-%H-%M-%S)

DUMPFILE_CACHAE_DIR_INFO=${MODULE_RECOVERY_DIR_PATH}/cache-dirinfo
DUMPFILE_BUSYBOX_IFCONFIG=${MODULE_NETWORK_DIR_PATH}/busybox-ifconfig
DUMPFILE_NETCFG=${MODULE_NETWORK_DIR_PATH}/netcfg
DUMPFILE_NETSTAT=${MODULE_NETWORK_DIR_PATH}/netstat
DUMPFILE_BUSYBOX_ARMV6L_NETSTAT=${MODULE_NETWORK_DIR_PATH}/busybox-armv6l-netstat
DUMPFILE_BUSYBOX_ARMV6L_ROUTE=${MODULE_NETWORK_DIR_PATH}/busybox-armv6l-route
DUMPFILE_SHOWLEASE=${MODULE_NETWORK_DIR_PATH}/showlease
DUMPFILE_BUSYBOX_ARMV6L_IP_ADDRESS=${MODULE_NETWORK_DIR_PATH}/busybox-armv6l-ip-address
DUMPFILE_BUSYBOX_ARMV6L_IP_ROUTE=${MODULE_NETWORK_DIR_PATH}/busybox-armv6l-ip-route
DUMPFILE_BUSYBOX_ARMV6L_IP_LINK=${MODULE_NETWORK_DIR_PATH}/busybox-armv6l-ip-link
DUMPFILE_BUSYBOX_ARMV6L_IP_TUNNEL=${MODULE_NETWORK_DIR_PATH}/busybox-armv6l-ip-tunnel

DUMPFILE_LOGCAT=${MODULE_ANDROID_DIR_PATH}/logcat-$(date +%Y-%m-%d-%H-%M-%S)
DUMPFILE_ANDROID_DUMPSTATE=${MODULE_ANDROID_DIR_PATH}/dumpstate
DUMPFILE_ANDROID_DUMPSYS=${MODULE_ANDROID_DIR_PATH}/dumpsys
DUMPFILE_ANDROID_PRINTENV=${MODULE_ANDROID_DIR_PATH}/printenv
DUMPFILE_ANDROID_GETPROP=${MODULE_ANDROID_DIR_PATH}/${PROP_DIR}/getprop
DUMPFILE_TINYMIX=${MODULE_ANDROID_DIR_PATH}/tinymix
DUMPFILE_DATA_DHCP=${MODULE_ANDROID_DIR_PATH}/data-dhcp-dirinfo
DUMPFILE_DATA_BLUETOOTH=${MODULE_ANDROID_DIR_PATH}/data-bluetooth-dirinfo
DUMPFILE_DATA_BLUETOOTHD=${MODULE_ANDROID_DIR_PATH}/data-bluetoothd-dirinfo

DUMPFILE_BUSYBOX_ARMV6L_TOP=${MODULE_LINUX_DIR_PATH}/${DIR_RUNTIME}/busybox-armv6l-top-$(date +%Y-%m-%d-%H-%M-%S)
DUMPFILE_PROC_LAST_KMSG=${MODULE_LINUX_DIR_PATH}/${DIR_RUNTIME}/proc-last-kmsg
DUMPFILE_PROC_CPUINFO=${MODULE_LINUX_DIR_PATH}/${DIR_SYSINFO}/proc-cpuinfo
DUMPFILE_PROC_HARDWARE_VERSION=${MODULE_LINUX_DIR_PATH}/${DIR_SYSINFO}/proc-hardware-version
DUMPFILE_BUSYBOX_ARMV6L_MOUNT=${MODULE_LINUX_DIR_PATH}/${DIR_SYSINFO}/busybox-armv6l-mount
DUMPFILE_PROC_ASOUND_CARDS=${MODULE_LINUX_DIR_PATH}/${DIR_AUDIO}/proc-asound-cards
DUMPFILE_PROC_ASOUND_DEVICES=${MODULE_LINUX_DIR_PATH}/${DIR_AUDIO}/proc-asound-devices
DUMPFILE_PROC_ASOUND_PCM=${MODULE_LINUX_DIR_PATH}/${DIR_AUDIO}/proc-asound-pcm
DUMPFILE_PROC_ASOUND_CARD0_ID=${MODULE_LINUX_DIR_PATH}/${DIR_AUDIO}/proc-asound-card0-id
DUMPFILE_PROC_ASOUND_CARD0_PCM0C_INFO=${MODULE_LINUX_DIR_PATH}/${DIR_AUDIO}/proc-asound-card0-pcm0c-info
DUMPFILE_PROC_ASOUND_CARD0_PCM0P_INFO=${MODULE_LINUX_DIR_PATH}/${DIR_AUDIO}/proc-asound-card0-pcm0p-info
DUMPFILE_PROC_ASOUND_CARD1_ID=${MODULE_LINUX_DIR_PATH}/${DIR_AUDIO}/proc-asound-card1-id
DUMPFILE_PROC_ASOUND_CARD1_PCM1C_INFO=${MODULE_LINUX_DIR_PATH}/${DIR_AUDIO}/proc-asound-card1-pcm0c-info
DUMPFILE_PROC_ASOUND_CARD1_PCM1P_INFO=${MODULE_LINUX_DIR_PATH}/${DIR_AUDIO}/proc-asound-card1-pcm0p-info
DUMPFILE_DMESG=${MODULE_LINUX_DIR_PATH}/${DIR_RUNTIME}/dmesg
DUMPFILE_BUSYGOX_ARMV6L_FREE=${MODULE_LINUX_DIR_PATH}/${DIR_RUNTIME}/busybox-armv6l-free
DUMPFILE_PROC_MEMINFO=${MODULE_LINUX_DIR_PATH}/${DIR_RUNTIME}/proc-meminfo
DUMPFILE_BUSYBOX_AMRV6L_PS=${MODULE_LINUX_DIR_PATH}/${DIR_RUNTIME}/busybox-armv6l-ps
DUMPFILE_PS=${MODULE_LINUX_DIR_PATH}/${DIR_RUNTIME}/ps
DUMPFILE_BUSYBOX_AMRV6L_UPTIME=${MODULE_LINUX_DIR_PATH}/${DIR_RUNTIME}/busybox-armv6l-uptime
DUMPFILE_UPTIME=${MODULE_LINUX_DIR_PATH}/${DIR_RUNTIME}/uptime
DUMPFILE_BUSYBOX_UPTIME=${MODULE_LINUX_DIR_PATH}/${DIR_RUNTIME}/busybox-uptime
DUMPFILE_BUSYBOX_AMRV6L_DATE=${MODULE_LINUX_DIR_PATH}/${DIR_RUNTIME}/busybox-armv6l-date
DUMPFILE_BUSYBOX_AMRV6L_PSTREE=${MODULE_LINUX_DIR_PATH}/${DIR_RUNTIME}/busybox-armv6l-pstree
DUMPFILE_BUSYBOX_AMRV6L_DF=${MODULE_LINUX_DIR_PATH}/${DIR_SYSINFO}/busybox-armv6l-df
DUMPFILE_BUSYBOX_AMRV6L_LSUSB=${MODULE_LINUX_DIR_PATH}/${DIR_SYSINFO}/busybox-armv6l-lsusb
DUMPFILE_HDMI_STATE=${MODULE_LINUX_DIR_PATH}/${DIR_RUNTIME}/hdmi-state
DUMPFILE_RFKILL_STATE=${MODULE_LINUX_DIR_PATH}/${DIR_RUNTIME}/rfkill-state

DUMPFILE_DATA_CALLMANAGER=${MODULE_CM_DIR_PATH}/data-callmanager-dirinfo

#======================
# network
#    ifconfig
#    netcfg
#    netstat
#    busybox-armv6l netstat
#======================
function start_network_trace()
{
    #echo "start_network_trace "

    if [ ! -d ${DEBUG_DIR_PATH} ]; then
        mkdir -p ${DEBUG_DIR_PATH}
    fi
    cd ${DEBUG_DIR_PATH}

    if [ ! -d ${MODULE_NETWORK_DIR_PATH} ]; then
        mkdir -p ${MODULE_NETWORK_DIR_PATH}
    fi

    #if [ ! -f ${DUMPFILE_TCPDUMP} ]; then
    #    touch ${DUMPFILE_TCPDUMP}
    #fi
    #/system/xbin/tcpdump -vv -i any -s 0 -w ${DUMPFILE_TCPDUMP} host !127.0.0.1 &

    #if [ ! -f ${DUMPFILE_IFTOP} ]; then
    #    touch ${DUMPFILE_IFTOP}
    #fi
    #DUMP_DATE=`date "+%Y-%m-%d %H:%M:%S"`
    #echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_IFTOP}
    #iftop >> ${DUMPFILE_IFTOP} &

    dump_network_trace_once
    dump_network_trace_timing

    #echo "start_network_trace end"
}

function dump_network_trace_once()
{
    #echo "dump_network_trace_once begin"

    if [ ! -f ${DEBUG_PATH_FILE} ]; then
        #echo "${DEBUG_PATH_FILE} is not exist."
        return 1
    fi

    if [ ! -d ${DEBUG_DIR_PATH} ]; then
        mkdir -p ${DEBUG_DIR_PATH}
    fi
    cd ${DEBUG_DIR_PATH}

    #echo "dump_network_trace_once end"
}

function dump_network_trace_timing()
{
    #echo "dump_network_trace_timing begin"

    if [ ! -d ${DEBUG_DIR_PATH} ]; then
        mkdir -p ${DEBUG_DIR_PATH}
    fi
    cd ${DEBUG_DIR_PATH}

    if [ ! -d ${MODULE_NETWORK_DIR_PATH} ]; then
        mkdir -p ${MODULE_NETWORK_DIR_PATH}
    fi

    DUMP_DATE=`date "+%Y-%m-%d %H:%M:%S"`

    #ifconfig

    if [ ! -f ${DUMPFILE_BUSYBOX_IFCONFIG} ]; then
        touch ${DUMPFILE_BUSYBOX_IFCONFIG}
    fi
    echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_BUSYBOX_IFCONFIG}
    busybox ifconfig >> ${DUMPFILE_BUSYBOX_IFCONFIG}

    #netcfg
    if [ ! -f ${DUMPFILE_NETCFG} ]; then
        touch ${DUMPFILE_NETCFG}
    fi
    echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_NETCFG}
    netcfg >> ${DUMPFILE_NETCFG}

    #netstat
    if [ ! -f ${DUMPFILE_NETSTAT} ]; then
        touch ${DUMPFILE_NETSTAT}
    fi
    echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_NETSTAT}
    netstat >> ${DUMPFILE_NETSTAT}

    #busybox-armv6l netstat
    if [ ! -f ${DUMPFILE_BUSYBOX_ARMV6L_NETSTAT} ]; then
        touch ${DUMPFILE_BUSYBOX_ARMV6L_NETSTAT}
    fi
    echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_BUSYBOX_ARMV6L_NETSTAT}
    /system/usr/sbin/busybox-armv6l netstat -ap >> ${DUMPFILE_BUSYBOX_ARMV6L_NETSTAT}

    #busybox-armv6l route
    if [ ! -f ${DUMPFILE_BUSYBOX_ARMV6L_ROUTE} ]; then
        touch ${DUMPFILE_BUSYBOX_ARMV6L_ROUTE}
    fi
    echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_BUSYBOX_ARMV6L_ROUTE}
    /system/usr/sbin/busybox-armv6l route -n >> ${DUMPFILE_BUSYBOX_ARMV6L_ROUTE}
    echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_BUSYBOX_ARMV6L_ROUTE}
    /system/usr/sbin/busybox-armv6l route -e >> ${DUMPFILE_BUSYBOX_ARMV6L_ROUTE}

    #showlease
    if [ ! -f ${DUMPFILE_SHOWLEASE} ]; then
        touch ${DUMPFILE_SHOWLEASE}
    fi
    echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_SHOWLEASE}
    showlease eth0 >> ${DUMPFILE_SHOWLEASE}

    #busybox-armv6l ip address
    if [ ! -f ${DUMPFILE_BUSYBOX_ARMV6L_IP_ADDRESS} ]; then
        touch ${DUMPFILE_BUSYBOX_ARMV6L_IP_ADDRESS}
    fi
    echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_BUSYBOX_ARMV6L_IP_ADDRESS}
    /system/usr/sbin/busybox-armv6l ip addres >> ${DUMPFILE_BUSYBOX_ARMV6L_IP_ADDRESS}

    #busybox-armv6l ip route
    if [ ! -f ${DUMPFILE_BUSYBOX_ARMV6L_IP_ROUTE} ]; then
        touch ${DUMPFILE_BUSYBOX_ARMV6L_IP_ROUTE}
    fi
    echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_BUSYBOX_ARMV6L_IP_ROUTE}
    /system/usr/sbin/busybox-armv6l ip route >> ${DUMPFILE_BUSYBOX_ARMV6L_IP_ROUTE}

    #busybox-armv6l ip link
    if [ ! -f ${DUMPFILE_BUSYBOX_ARMV6L_IP_LINK} ]; then
        touch ${DUMPFILE_BUSYBOX_ARMV6L_IP_LINK}
    fi
    echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_BUSYBOX_ARMV6L_IP_LINK}
    /system/usr/sbin/busybox-armv6l ip link >> ${DUMPFILE_BUSYBOX_ARMV6L_IP_LINK}

    #busybox-armv6l ip tunnel
    if [ ! -f ${DUMPFILE_BUSYBOX_ARMV6L_IP_TUNNEL} ]; then
        touch ${DUMPFILE_BUSYBOX_ARMV6L_IP_TUNNEL}
    fi
    echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_BUSYBOX_ARMV6L_IP_TUNNEL}
    /system/usr/sbin/busybox-armv6l ip tunnel >> ${DUMPFILE_BUSYBOX_ARMV6L_IP_TUNNEL}

    #echo "dump_network_trace_timing end"
}

function stop_network_trace()
{
    #echo "stop_network_trace begin"

    if [ ! -d ${DEBUG_DIR_PATH} ]; then
        mkdir -p ${DEBUG_DIR_PATH}
    fi
    cd ${DEBUG_DIR_PATH}

    dump_network_trace_once
    dump_network_trace_timing

    #/system/usr/sbin/busybox-armv6l pkill -f "/system/xbin/tcpdump"
    #/system/usr/sbin/busybox-armv6l pkill -f "iftop"

    #echo "stop_network_trace end"
}

#======================
# callmanager
#     version
#     product
#     config
#======================
function start_callmanager_trace()
{
    #echo "start_callmanager_trace begin"

    if [ ! -d ${DEBUG_DIR_PATH} ]; then
        mkdir -p ${DEBUG_DIR_PATH}
    fi
    cd ${DEBUG_DIR_PATH}

    dump_callmanager_trace_once

    #echo "start_callmanager_trace end"
}

function dump_callmanager_trace_once()
{
    #echo "dump_callmanager_trace_once begin"

    if [ ! -d ${DEBUG_DIR_PATH} ]; then
        mkdir -p ${DEBUG_DIR_PATH}
    fi
    cd ${DEBUG_DIR_PATH}

    if [ ! -d ${MODULE_CM_DIR_PATH} ]; then
        mkdir -p ${MODULE_CM_DIR_PATH}
    fi

    # version
    if [ -d ${VERSION_PATH} ]; then
        mkdir -p ${MODULE_CM_DIR}/${VERSION_DIR}
        cp -f ${VERSION_PATH}/* ${MODULE_CM_DIR}/${VERSION_DIR}
    fi

    # product id
    cp -f ${ETC_PATH}/${PRODUCT} ${MODULE_CM_DIR}

    # config
    if [ -d ${CALLMANAGER_PATH} ]; then
        cp -f ${CALLMANAGER_PATH}/${CONFIG_FILE} ${MODULE_CM_DIR}
    fi

    #echo "dump_callmanager_trace_once end"
}

function dump_callmanager_trace_timing()
{
    #echo "dump_callmanager_trace_timing begin"

    if [ ! -d ${DEBUG_DIR_PATH} ]; then
        mkdir -p ${DEBUG_DIR_PATH}
    fi
    cd ${DEBUG_DIR_PATH}

    DUMP_DATE=`date "+%Y-%m-%d %H:%M:%S"`

    echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_DATA_CALLMANAGER}
    busybox ls -lehR ${CALLMANAGER_PATH} >> ${DUMPFILE_DATA_CALLMANAGER}

    #echo "dump_callmanager_trace_timing end"
}

#======================
# android
#     anr
#     tombstones
#     dropbox
#     logcat
#     dumpstate
#     dumpsys
#     property
#=======================
function start_android_trace()
{
    #echo "start_android_trace begin"

    if [ ! -d ${DEBUG_DIR_PATH} ]; then
        mkdir -p ${DEBUG_DIR_PATH}
    fi
    cd ${DEBUG_DIR_PATH}

    if [ ! -d ${MODULE_RECOVERY_DIR_PATH} ]; then
        mkdir -p ${MODULE_RECOVERY_DIR_PATH}
    fi

    if [ ! -d ${MODULE_ANDROID_DIR_PATH} ]; then
        mkdir -p ${MODULE_ANDROID_DIR_PATH}
    fi

    #logcat
    if [ ! -f ${DUMPFILE_LOGCAT} ]; then
        touch ${DUMPFILE_LOGCAT}
    fi
    logcat -v time -f ${DUMPFILE_LOGCAT} &

    dump_android_trace_once

    #echo "start_android_trace end"
}

function dump_android_trace_once()
{
    #echo "dump_android_trace_once begin $DEBUG_DIR_PATH"
    
    if [ ! -d ${DEBUG_DIR_PATH} ]; then
        mkdir -p ${DEBUG_DIR_PATH}
    fi
    cd ${DEBUG_DIR_PATH}

    # /cache/recovery
    if [ -d $RECOVERY_PATH ]; then
        if [ ! -d ${MODULE_RECOVERY_DIR_PATH} ]; then
            mkdir -p ${MODULE_RECOVERY_DIR_PATH}
        fi
        cp -Rf ${RECOVERY_PATH}/* ${MODULE_RECOVERY_DIR_PATH}
    fi

    #anr
    if [ -d ${ANR_PATH} ]; then
        if [ ! -d ${MODULE_ANDROID_DIR_PATH}/${ANR_DIR} ]; then
            mkdir -p ${MODULE_ANDROID_DIR_PATH}/${ANR_DIR}
        fi
        cp -Rf ${ANR_PATH}/* ${MODULE_ANDROID_DIR_PATH}/${ANR_DIR}
    fi

    #tombstones
    if [ -d ${TOMBSTONES_PATH} ]; then
        if [ ! -d ${MODULE_ANDROID_DIR_PATH}/${TOMBSTONES_DIR} ]; then
            mkdir -p ${MODULE_ANDROID_DIR_PATH}/${TOMBSTONES_DIR}
        fi
        cp -Rf ${TOMBSTONES_PATH}/* ${MODULE_ANDROID_DIR_PATH}/${TOMBSTONES_DIR}
    fi

    #dropbox
    if [ -d ${DROPBOX_PATH} ]; then
        if [ ! -d ${MODULE_ANDROID_DIR_PATH}/${DROPBOX_DIR} ]; then
            mkdir -p ${MODULE_ANDROID_DIR_PATH}/${DROPBOX_DIR}
        fi
        cp -Rf ${DROPBOX_PATH}/* ${MODULE_ANDROID_DIR_PATH}/${DROPBOX_DIR}
    fi

    if [ -d ${DHCP_PATH} ]; then
        if [ ! -d ${MODULE_ANDROID_DIR_PATH}/${DHCP_PATH} ]; then
            mkdir -p ${MODULE_ANDROID_DIR_PATH}/${DHCP_PATH}
        fi
        cp -Rf ${DATA_DHCP_PATH}/* ${MODULE_ANDROID_DIR_PATH}/${DHCP_PATH}
    fi

    if [ -d ${BLUETOOTH_PATH} ]; then
        if [ ! -d ${MODULE_ANDROID_DIR_PATH}/${BLUETOOTH_PATH} ]; then
            mkdir -p ${MODULE_ANDROID_DIR_PATH}/${BLUETOOTH_PATH}
        fi
        cp -Rf ${DATA_BLUETOOTHD_PATH}/* ${MODULE_ANDROID_DIR_PATH}/${BLUETOOTH_PATH}
        cp -Rf ${DATA_BLUETOOTH_PATH}/* ${MODULE_ANDROID_DIR_PATH}/${BLUETOOTH_PATH}
    fi

    #dumpstate
    #dumpstate > ${DUMPFILE_ANDROID_DUMPSTATE}

    #dumpsys
    #dumpsys > ${DUMPFILE_ANDROID_DUMPSYS}

    # property
    if [ ! -d ${MODULE_ANDROID_DIR_PATH}/${PROP_DIR} ]; then
        mkdir -p ${MODULE_ANDROID_DIR_PATH}/${PROP_DIR}
    fi

    # build.prop
    cp -f ${SYSTEM_PATH}/${BUILD_PROP} ${MODULE_ANDROID_DIR_PATH}/${PROP_DIR}

    # deault.prop
    cp -f ${SYSTEM_PATH}/${DEFAULT_PROP} ${MODULE_ANDROID_DIR_PATH}/${PROP_DIR}

    cp /data/system/packages.list ${MODULE_ANDROID_DIR_PATH}/packages.list

    if [ ! -f ${DUMPFILE_ANDROID_PRINTENV} ]; then
        touch ${DUMPFILE_ANDROID_PRINTENV}
    fi
    printenv > ${DUMPFILE_ANDROID_PRINTENV}

    #echo "dump_android_trace_once end"
}

function dump_android_trace_timing()
{
    #echo "dump_android_trace_timing begin"

    if [ ! -d ${DEBUG_DIR_PATH} ]; then
        mkdir -p ${DEBUG_DIR_PATH}
    fi
    cd ${DEBUG_DIR_PATH}

    DUMP_DATE=`date "+%Y-%m-%d %H:%M:%S"`

    # getprop
    if [ ! -f ${DUMPFILE_ANDROID_GETPROP} ]; then
        touch ${DUMPFILE_ANDROID_GETPROP}
    fi
    echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_ANDROID_GETPROP}
    getprop >> ${DUMPFILE_ANDROID_GETPROP}

    # tinymix
    if [ ! -f ${DUMPFILE_TINYMIX} ]; then
        touch ${DUMPFILE_TINYMIX}
    fi
    echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_TINYMIX}
    tinymix >> ${DUMPFILE_TINYMIX}

    # /data/misc/dhcp
    echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_DATA_DHCP}
    busybox ls -lehR ${DATA_DHCP_PATH} >> ${DUMPFILE_DATA_DHCP}

    # /data/misc/bluetoothd
    echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_DATA_BLUETOOTHD}
    busybox ls -lehR ${DATA_BLUETOOTHD_PATH} >> ${DUMPFILE_DATA_BLUETOOTHD}

    # /data/misc/bluetooth
    echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_DATA_BLUETOOTH}
    busybox ls -lehR ${DATA_BLUETOOTH_PATH} >> ${DUMPFILE_DATA_BLUETOOTH}

    # /cache
    echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_CACHAE_DIR_INFO}
    busybox ls -lehR ${CACHE_PATH} >> ${DUMPFILE_CACHAE_DIR_INFO}

    #echo "dump_android_trace_timing end"
}

function stop_android_trace()
{
    #echo "stop_android_trace begin"

    if [ ! -d ${DEBUG_DIR_PATH} ]; then
        mkdir -p ${DEBUG_DIR_PATH}
    fi
    cd ${DEBUG_DIR_PATH}

    dump_android_trace_once
    dump_android_trace_timing

    #/system/usr/sbin/busybox-armv6l pkill -f "logcat"

    #echo "stop_android_trace end"
}

#=======================
# linux
#     memory
#     dmesg
#=======================
function start_linux_trace()
{
    #echo "start_linux_trace begin"

    if [ ! -d ${DEBUG_DIR_PATH} ]; then
        mkdir -p ${DEBUG_DIR_PATH}
    fi
    cd ${DEBUG_DIR_PATH}

    if [ ! -d ${MODULE_LINUX_DIR_PATH} ]; then
        mkdir -p ${MODULE_LINUX_DIR_PATH}
    fi

    if [ ! -d ${MODULE_LINUX_DIR_PATH}/${DIR_RUNTIME} ]; then
        mkdir -p ${MODULE_LINUX_DIR}/${DIR_RUNTIME}
    fi

    if [ ! -d ${MODULE_LINUX_DIR_PATH}/${DIR_SYSINFO} ]; then
        mkdir -p ${MODULE_LINUX_DIR_PATH}/${DIR_SYSINFO}
    fi

    if [ ! -d ${MODULE_LINUX_DIR_PATH}/${DIR_AUDIO} ]; then
        mkdir -p ${MODULE_LINUX_DIR_PATH}/${DIR_AUDIO}
    fi

    #if [ ! -f ${DUMPFILE_BUSYBOX_ARMV6L_TOP} ]; then
    #    touch ${DUMPFILE_BUSYBOX_ARMV6L_TOP}
    #fi
    #/system/usr/sbin/busybox-armv6l top -b -m > ${DUMPFILE_BUSYBOX_ARMV6L_TOP} &

    dump_linux_trace_once
    dump_linux_trace_timing

    #echo "start_linux_trace end"
}

function dump_linux_trace_once()
{
    #echo "dump_linux_trace_once begin"

    if [ ! -d ${DEBUG_DIR_PATH} ]; then
        mkdir -p ${DEBUG_DIR_PATH}
    fi
    cd ${DEBUG_DIR_PATH}

    DUMP_DATE=`date "+%Y-%m-%d %H:%M:%S"`

    #/proc/last_kmsg
    if [ -f /proc/last_kmsg ]; then
        if [ ! -f ${DUMPFILE_PROC_LAST_KMSG} ]; then
            touch ${DUMPFILE_PROC_LAST_KMSG}
        fi
        echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_PROC_LAST_KMSG}
        cat /proc/last_kmsg >> ${DUMPFILE_PROC_LAST_KMSG}
    fi

    # /proc/cpuinfo
    if [ -f /proc/cpuinfo ]; then
        if [ ! -f ${DUMPFILE_PROC_CPUINFO} ]; then
            touch ${DUMPFILE_PROC_CPUINFO}
        fi
        echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_PROC_CPUINFO}
        cat /proc/cpuinfo >> ${DUMPFILE_PROC_CPUINFO}
    fi

    # hardware version
    if [ -f /proc/hardware_version ]; then
        if [ ! -f ${DUMPFILE_PROC_HARDWARE_VERSION} ]; then
            touch ${DUMPFILE_PROC_HARDWARE_VERSION}
        fi
        echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_PROC_HARDWARE_VERSION}
        cat /proc/hardware_version >> ${DUMPFILE_PROC_HARDWARE_VERSION}
    fi

    # mount
    if [ ! -f ${DUMPFILE_BUSYBOX_ARMV6L_MOUNT} ]; then
        touch ${DUMPFILE_BUSYBOX_ARMV6L_MOUNT}
    fi
    echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_BUSYBOX_ARMV6L_MOUNT}
    /system/usr/sbin/busybox-armv6l mount >> ${DUMPFILE_BUSYBOX_ARMV6L_MOUNT}

    # /proc/asound/cards
    if [ -f /proc/asound/cards ]; then
        if [ ! -f ${DUMPFILE_PROC_ASOUND_CARDS} ]; then
            touch ${DUMPFILE_PROC_ASOUND_CARDS}
        fi
        echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_PROC_ASOUND_CARDS}
        cat /proc/asound/cards >> ${DUMPFILE_PROC_ASOUND_CARDS}
    fi

    # /proc/asound/devices
    if [ -f /proc/asound/devices ]; then
        if [ ! -f ${DUMPFILE_PROC_ASOUND_DEVICES} ]; then
            touch ${DUMPFILE_PROC_ASOUND_DEVICES}
        fi
        echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_PROC_ASOUND_DEVICES}
        cat /proc/asound/devices >> ${DUMPFILE_PROC_ASOUND_DEVICES}
    fi

    # /proc/asound/pcm
    if [ -f /proc/asound/pcm ]; then
        if [ ! -f ${DUMPFILE_PROC_ASOUND_PCM} ]; then
            touch ${DUMPFILE_PROC_ASOUND_PCM}
        fi
        echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_PROC_ASOUND_PCM}
        cat /proc/asound/pcm >> ${DUMPFILE_PROC_ASOUND_PCM}
    fi

    # /proc/asound/card0/id
    if [ -f /proc/asound/card0/id ]; then
        if [ ! -f ${DUMPFILE_PROC_ASOUND_CARD0_ID} ]; then
            touch ${DUMPFILE_PROC_ASOUND_CARD0_ID}
        fi
        echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_PROC_ASOUND_CARD0_ID}
        cat /proc/asound/card0/id >> ${DUMPFILE_PROC_ASOUND_CARD0_ID}
    fi

    # /proc/asound/card0/pcm0c/info
    if [ -f /proc/asound/card0/pcm0c/info ]; then
        if [ ! -f ${DUMPFILE_PROC_ASOUND_CARD0_PCM0C_INFO} ]; then
            touch ${DUMPFILE_PROC_ASOUND_CARD0_PCM0C_INFO}
        fi
        echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_PROC_ASOUND_CARD0_PCM0C_INFO}
        cat /proc/asound/card0/pcm0c/info >> ${DUMPFILE_PROC_ASOUND_CARD0_PCM0C_INFO}
    fi

    # /proc/asound/card0/pcm0p/info
    if [ -f /proc/asound/card0/pcm0p/info ]; then
        if [ ! -f ${DUMPFILE_PROC_ASOUND_CARD0_PCM0P_INFO} ]; then
            touch ${DUMPFILE_PROC_ASOUND_CARD0_PCM0P_INFO}
        fi
        echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_PROC_ASOUND_CARD0_PCM0P_INFO}
        cat /proc/asound/card0/pcm0p/info >> ${DUMPFILE_PROC_ASOUND_CARD0_PCM0P_INFO}
    fi

    # /proc/asound/card1/id
    if [ -f /proc/asound/card1/id ]; then
        if [ ! -f ${DUMPFILE_PROC_ASOUND_CARD1_ID} ]; then
            touch ${DUMPFILE_PROC_ASOUND_CARD1_ID}
        fi
        echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_PROC_ASOUND_CARD1_ID}
        cat /proc/asound/card1/id >> ${DUMPFILE_PROC_ASOUND_CARD1_ID}
    fi

    # /proc/asound/card1/pcm0c/info
    if [ -f /proc/asound/card1/pcm0c/info ]; then
        if [ ! -f ${DUMPFILE_PROC_ASOUND_CARD1_PCM0C_INFO} ]; then
            touch ${DUMPFILE_PROC_ASOUND_CARD1_PCM0C_INFO}
        fi
        echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_PROC_ASOUND_CARD1_PCM0C_INFO}
        cat /proc/asound/card1/pcm0c/info >> ${DUMPFILE_PROC_ASOUND_CARD1_PCM0C_INFO}
    fi

    # /proc/asound/card1/pcm0p/info
    if [ -f /proc/asound/card1/pcm0p/info ]; then
        if [ ! -f ${DUMPFILE_PROC_ASOUND_CARD1_PCM1P_INFO} ]; then
            touch ${DUMPFILE_PROC_ASOUND_CARD1_PCM1P_INFO}
        fi
        echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_PROC_ASOUND_CARD1_PCM1P_INFO}
        cat /proc/asound/card1/pcm0p/info >> ${DUMPFILE_PROC_ASOUND_CARD1_PCM1P_INFO}
    fi

    #echo "dump_linux_trace_once end"
}

function dump_linux_trace_timing()
{
    #echo "dump_linux_trace_timing begin"

    if [ ! -d ${DEBUG_DIR_PATH} ]; then
        mkdir -p ${DEBUG_DIR_PATH}
    fi
    cd ${DEBUG_DIR_PATH}

    DUMP_DATE=`date "+%Y-%m-%d %H:%M:%S"`

    # dmesg
    if [ ! -f ${DUMPFILE_DMESG} ]; then
        touch ${DUMPFILE_DMESG}
    fi
    echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_DMESG}
    dmesg >> ${DUMPFILE_DMESG}

    # memory
    if [ ! -f ${DUMPFILE_BUSYGOX_ARMV6L_FREE} ]; then
        touch ${DUMPFILE_BUSYGOX_ARMV6L_FREE}
    fi
    echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_BUSYGOX_ARMV6L_FREE}
    /system/usr/sbin/busybox-armv6l free -m >> ${DUMPFILE_BUSYGOX_ARMV6L_FREE}

    # /proc/meminfo
    if [ -f /proc/meminfo ]; then
        if [ ! -f ${DUMPFILE_PROC_MEMINFO} ]; then
            touch ${DUMPFILE_PROC_MEMINFO}
        fi
        echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_PROC_MEMINFO}
        cat /proc/meminfo >> ${DUMPFILE_PROC_MEMINFO}
    fi

    # busybox-armv6l ps
    if [ ! -f ${DUMPFILE_BUSYBOX_AMRV6L_PS} ]; then
        touch ${DUMPFILE_BUSYBOX_AMRV6L_PS}
    fi
    echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_BUSYBOX_AMRV6L_PS}
    /system/usr/sbin/busybox-armv6l ps -T >> ${DUMPFILE_BUSYBOX_AMRV6L_PS}

    # ps
    if [ ! -f ${DUMPFILE_PS} ]; then
        touch ${DUMPFILE_PS}
    fi
    echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_PS}
    ps >> ${DUMPFILE_PS}

    # busybox-armv6l uptime
    if [ ! -f ${DUMPFILE_BUSYBOX_AMRV6L_UPTIME} ]; then
        touch ${DUMPFILE_BUSYBOX_AMRV6L_UPTIME}
    fi
    echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_BUSYBOX_AMRV6L_UPTIME}
    /system/usr/sbin/busybox-armv6l uptime >> ${DUMPFILE_BUSYBOX_AMRV6L_UPTIME}

    # uptime
    if [ ! -f ${DUMPFILE_UPTIME} ]; then
        touch ${DUMPFILE_UPTIME}
    fi
    echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_UPTIME}
    uptime >> ${DUMPFILE_UPTIME}

    # busybox uptime
    if [ ! -f ${DUMPFILE_BUSYBOX_UPTIME} ]; then
        touch ${DUMPFILE_BUSYBOX_UPTIME}
    fi
    echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_BUSYBOX_UPTIME}
    busybox uptime >> ${DUMPFILE_BUSYBOX_UPTIME}

    # busybox-armv6l date
    if [ ! -f ${DUMPFILE_BUSYBOX_AMRV6L_DATE} ]; then
        touch ${DUMPFILE_BUSYBOX_AMRV6L_DATE}
    fi
    echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_BUSYBOX_AMRV6L_DATE}
    /system/usr/sbin/busybox-armv6l date >> ${DUMPFILE_BUSYBOX_AMRV6L_DATE}

    # busybox-armv6l pstree
    if [ ! -f ${DUMPFILE_BUSYBOX_AMRV6L_PSTREE} ]; then
        touch ${DUMPFILE_BUSYBOX_AMRV6L_PSTREE}
    fi
    echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_BUSYBOX_AMRV6L_PSTREE}
    /system/usr/sbin/busybox-armv6l pstree >> ${DUMPFILE_BUSYBOX_AMRV6L_PSTREE}

    # busybox-armv6l df
    if [ ! -f ${DUMPFILE_BUSYBOX_AMRV6L_DF} ]; then
        touch ${DUMPFILE_BUSYBOX_AMRV6L_DF}
    fi
    echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_BUSYBOX_AMRV6L_DF}
    /system/usr/sbin/busybox-armv6l df -h >> ${DUMPFILE_BUSYBOX_AMRV6L_DF}

    # busybox-armv6l lsusb
    if [ ! -f ${DUMPFILE_BUSYBOX_AMRV6L_LSUSB} ]; then
        touch ${DUMPFILE_BUSYBOX_AMRV6L_LSUSB}
    fi
    echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_BUSYBOX_AMRV6L_LSUSB}
    /system/usr/sbin/busybox-armv6l lsusb >> ${DUMPFILE_BUSYBOX_AMRV6L_LSUSB}

    echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_HDMI_STATE}
    cat /sys/bus/platform/drivers/mxc_hdmi/mxc_hdmi/cable_state >> ${DUMPFILE_HDMI_STATE}

    echo "==========${DUMP_DATE}==========" >> ${DUMPFILE_RFKILL_STATE}
    /system/usr/sbin/busybox-armv6l ls -la /sys/class/rfkill/ >> ${DUMPFILE_RFKILL_STATE}


    #echo "dump_linux_trace_timing end"
}

function stop_linux_trace()
{
    #echo "stop_linux_trace begin"

    if [ ! -d ${DEBUG_DIR_PATH} ]; then
        mkdir -p ${DEBUG_DIR_PATH}
    fi
    cd ${DEBUG_DIR_PATH}

    dump_linux_trace_once
    dump_linux_trace_timing

    #/system/usr/sbin/busybox-armv6l pkill -f "/system/usr/sbin/busybox-armv6l top"

    #echo "stop_linux_trace end"
}

#ģʽдļдϵͳ
function enable_debug_trace()
{
    setprop sys.debugmode 1

    if [ ! -f ${DEBUG_STATE} ]; then
        touch ${DEBUG_STATE}
        chmod 777 ${DEBUG_STATE}
    fi

    if [ -f ${DEBUG_STATE} ]; then
        echo 1 > ${DEBUG_STATE}
    fi
}

#set ·ļ ֻset sdcardudisk
function set_debug_path_trace()
{
    #echo "set_debug_path_trace start $1"
    if [ ! -f ${DEBUG_PATH_FILE} ]; then
        touch ${DEBUG_PATH_FILE}
        chmod 777 ${DEBUG_PATH_FILE}
    fi

    if [ -f ${DEBUG_PATH_FILE} ]; then
        if [ "$1" = "${DEBUG_PATH}" -o "$1" = "${UDISK_PATH}" ]; then
        echo $1 > ${DEBUG_PATH_FILE}
        fi
    fi 
    #echo "set_debug_path_trace end!"
}

#һЩϢ
function set_some_debug_file_name()
{
    #echo "set_some_debug_file_name start"
    DEBUG_DIR_PATH=${CHECK_PATH}/debug
    MODULE_LINUX_DIR_PATH=${DEBUG_DIR_PATH}/${MODULE_LINUX_DIR}
    MODULE_RECOVERY_DIR_PATH=${DEBUG_DIR_PATH}/${MODULE_RECOVERY_DIR}
    MODULE_NETWORK_DIR_PATH=${DEBUG_DIR_PATH}/${MODULE_NETWORK_DIR}
    MODULE_CM_DIR_PATH=${DEBUG_DIR_PATH}/${MODULE_CM_DIR}
    MODULE_ANDROID_DIR_PATH=${DEBUG_DIR_PATH}/${MODULE_ANDROID_DIR}
    DUMPFILE_BUSYBOX_ARMV6L_TOP=${MODULE_LINUX_DIR_PATH}/${DIR_RUNTIME}/busybox-armv6l-top-$(date +%Y-%m-%d-%H-%M-%S)

    DUMPFILE_TCPDUMP=${MODULE_NETWORK_DIR_PATH}/tcpdump-$(date +%Y-%m-%d-%H-%M-%S).pcap
    DUMPFILE_IFTOP=${MODULE_NETWORK_DIR_PATH}/iftop-$(date +%Y-%m-%d-%H-%M-%S)

    DUMPFILE_CACHAE_DIR_INFO=${MODULE_RECOVERY_DIR_PATH}/cache-dirinfo
    DUMPFILE_BUSYBOX_IFCONFIG=${MODULE_NETWORK_DIR_PATH}/busybox-ifconfig
    DUMPFILE_NETCFG=${MODULE_NETWORK_DIR_PATH}/netcfg
    DUMPFILE_NETSTAT=${MODULE_NETWORK_DIR_PATH}/netstat
    DUMPFILE_BUSYBOX_ARMV6L_NETSTAT=${MODULE_NETWORK_DIR_PATH}/busybox-armv6l-netstat
    DUMPFILE_BUSYBOX_ARMV6L_ROUTE=${MODULE_NETWORK_DIR_PATH}/busybox-armv6l-route
    DUMPFILE_SHOWLEASE=${MODULE_NETWORK_DIR_PATH}/showlease
    DUMPFILE_BUSYBOX_ARMV6L_IP_ADDRESS=${MODULE_NETWORK_DIR_PATH}/busybox-armv6l-ip-address
    DUMPFILE_BUSYBOX_ARMV6L_IP_ROUTE=${MODULE_NETWORK_DIR_PATH}/busybox-armv6l-ip-route
    DUMPFILE_BUSYBOX_ARMV6L_IP_LINK=${MODULE_NETWORK_DIR_PATH}/busybox-armv6l-ip-link
    DUMPFILE_BUSYBOX_ARMV6L_IP_TUNNEL=${MODULE_NETWORK_DIR_PATH}/busybox-armv6l-ip-tunnel

    DUMPFILE_LOGCAT=${MODULE_ANDROID_DIR_PATH}/logcat-$(date +%Y-%m-%d-%H-%M-%S)
    DUMPFILE_ANDROID_DUMPSTATE=${MODULE_ANDROID_DIR_PATH}/dumpstate
    DUMPFILE_ANDROID_DUMPSYS=${MODULE_ANDROID_DIR_PATH}/dumpsys
    DUMPFILE_ANDROID_PRINTENV=${MODULE_ANDROID_DIR_PATH}/printenv
    DUMPFILE_ANDROID_GETPROP=${MODULE_ANDROID_DIR_PATH}/${PROP_DIR}/getprop
    DUMPFILE_TINYMIX=${MODULE_ANDROID_DIR_PATH}/tinymix
    DUMPFILE_DATA_DHCP=${MODULE_ANDROID_DIR_PATH}/data-dhcp-dirinfo
    DUMPFILE_DATA_BLUETOOTH=${MODULE_ANDROID_DIR_PATH}/data-bluetooth-dirinfo
    DUMPFILE_DATA_BLUETOOTHD=${MODULE_ANDROID_DIR_PATH}/data-bluetoothd-dirinfo

    DUMPFILE_BUSYBOX_ARMV6L_TOP=${MODULE_LINUX_DIR_PATH}/${DIR_RUNTIME}/busybox-armv6l-top-$(date +%Y-%m-%d-%H-%M-%S)
    DUMPFILE_PROC_LAST_KMSG=${MODULE_LINUX_DIR_PATH}/${DIR_RUNTIME}/proc-last-kmsg
    DUMPFILE_PROC_CPUINFO=${MODULE_LINUX_DIR_PATH}/${DIR_SYSINFO}/proc-cpuinfo
    DUMPFILE_PROC_HARDWARE_VERSION=${MODULE_LINUX_DIR_PATH}/${DIR_SYSINFO}/proc-hardware-version
    DUMPFILE_BUSYBOX_ARMV6L_MOUNT=${MODULE_LINUX_DIR_PATH}/${DIR_SYSINFO}/busybox-armv6l-mount
    DUMPFILE_PROC_ASOUND_CARDS=${MODULE_LINUX_DIR_PATH}/${DIR_AUDIO}/proc-asound-cards
    DUMPFILE_PROC_ASOUND_DEVICES=${MODULE_LINUX_DIR_PATH}/${DIR_AUDIO}/proc-asound-devices
    DUMPFILE_PROC_ASOUND_PCM=${MODULE_LINUX_DIR_PATH}/${DIR_AUDIO}/proc-asound-pcm
    DUMPFILE_PROC_ASOUND_CARD0_ID=${MODULE_LINUX_DIR_PATH}/${DIR_AUDIO}/proc-asound-card0-id
    DUMPFILE_PROC_ASOUND_CARD0_PCM0C_INFO=${MODULE_LINUX_DIR_PATH}/${DIR_AUDIO}/proc-asound-card0-pcm0c-info
    DUMPFILE_PROC_ASOUND_CARD0_PCM0P_INFO=${MODULE_LINUX_DIR_PATH}/${DIR_AUDIO}/proc-asound-card0-pcm0p-info
    DUMPFILE_PROC_ASOUND_CARD1_ID=${MODULE_LINUX_DIR_PATH}/${DIR_AUDIO}/proc-asound-card1-id
    DUMPFILE_PROC_ASOUND_CARD1_PCM1C_INFO=${MODULE_LINUX_DIR_PATH}/${DIR_AUDIO}/proc-asound-card1-pcm0c-info
    DUMPFILE_PROC_ASOUND_CARD1_PCM1P_INFO=${MODULE_LINUX_DIR_PATH}/${DIR_AUDIO}/proc-asound-card1-pcm0p-info
    DUMPFILE_DMESG=${MODULE_LINUX_DIR_PATH}/${DIR_RUNTIME}/dmesg
    DUMPFILE_BUSYGOX_ARMV6L_FREE=${MODULE_LINUX_DIR_PATH}/${DIR_RUNTIME}/busybox-armv6l-free
    DUMPFILE_PROC_MEMINFO=${MODULE_LINUX_DIR_PATH}/${DIR_RUNTIME}/proc-meminfo
    DUMPFILE_BUSYBOX_AMRV6L_PS=${MODULE_LINUX_DIR_PATH}/${DIR_RUNTIME}/busybox-armv6l-ps
    DUMPFILE_PS=${MODULE_LINUX_DIR_PATH}/${DIR_RUNTIME}/ps
    DUMPFILE_BUSYBOX_AMRV6L_UPTIME=${MODULE_LINUX_DIR_PATH}/${DIR_RUNTIME}/busybox-armv6l-uptime
    DUMPFILE_UPTIME=${MODULE_LINUX_DIR_PATH}/${DIR_RUNTIME}/uptime
    DUMPFILE_BUSYBOX_UPTIME=${MODULE_LINUX_DIR_PATH}/${DIR_RUNTIME}/busybox-uptime
    DUMPFILE_BUSYBOX_AMRV6L_DATE=${MODULE_LINUX_DIR_PATH}/${DIR_RUNTIME}/busybox-armv6l-date
    DUMPFILE_BUSYBOX_AMRV6L_PSTREE=${MODULE_LINUX_DIR_PATH}/${DIR_RUNTIME}/busybox-armv6l-pstree
    DUMPFILE_BUSYBOX_AMRV6L_DF=${MODULE_LINUX_DIR_PATH}/${DIR_SYSINFO}/busybox-armv6l-df
    DUMPFILE_BUSYBOX_AMRV6L_LSUSB=${MODULE_LINUX_DIR_PATH}/${DIR_SYSINFO}/busybox-armv6l-lsusb
    DUMPFILE_HDMI_STATE=${MODULE_LINUX_DIR_PATH}/${DIR_RUNTIME}/hdmi-state
    DUMPFILE_RFKILL_STATE=${MODULE_LINUX_DIR_PATH}/${DIR_RUNTIME}/rfkill-state

    DUMPFILE_DATA_CALLMANAGER=${MODULE_CM_DIR_PATH}/data-callmanager-dirinfo

    #echo "set_some_debug_file_name end"
}

function start_debug_trace()
{
    #echo "start_debug_trace begin"

    if [ ! -f ${DEBUG_PATH_FILE} ]; then
        #echo "${DEBUG_PATH_FILE} is not exist."
        return 0
    fi
    state=$(cat ${DEBUG_PATH_FILE})
    CHECK_PATH=${state}
    set_some_debug_file_name

    if [ ! -d ${DEBUG_DIR_PATH} ]; then
        mkdir -p ${DEBUG_DIR_PATH}
        if [ $? -ne 0 ]; then
            #echo "start_debug_trace: mkdir $DEBUG_DIR failed"
            return 1
        fi
    fi
    cd ${DEBUG_DIR_PATH}

    start_linux_trace

    start_callmanager_trace

    start_network_trace

    start_android_trace

    #echo "start_debug_trace end"
}

function stop_debug_trace()
{
    #echo "stop_debug_trace begin"

    if [ ! -f ${DEBUG_PATH_FILE} ]; then
        #echo "${DEBUG_PATH_FILE} is not exist."
        return 0
    fi
    
    state=$(cat ${DEBUG_PATH_FILE})
    CHECK_PATH=${state}
    set_some_debug_file_name

    if [ ! -d ${DEBUG_DIR_PATH} ]; then
        mkdir -p ${DEBUG_DIR_PATH}
    fi
    cd ${DEBUG_DIR_PATH}

    /system/usr/sbin/busybox-armv6l pkill -f "sleep 300"

    stop_network_trace
    stop_android_trace
    stop_linux_trace

    #echo "stop_debug_trace end"
}

#رյϢдļϵͳ
function disable_debug_trace()
{
    setprop sys.debugmode 0

    if [ ! -f ${DEBUG_STATE} ]; then
        touch ${DEBUG_STATE}
        chmod 777 ${DEBUG_STATE}
    fi

    if [ -f ${DEBUG_STATE} ]; then
        echo 0 > ${DEBUG_STATE}
    fi
}

#ļеֵ Ƿdebugģʽ 0  1 
function check_debug_trace()
{
    if [ ! -f ${DEBUG_STATE} ]; then
        #echo "${DEBUG_STATE} is not exist."
        return 0
    fi
    state=$(cat ${DEBUG_STATE})
    if [ $state -ne 1 ]; then
        #echo "${DEBUG_STATE} is not enabled."
        return 0
    fi
    setprop sys.debugmode 1
    return 1
}

function dump_debug_trace_once()
{
    #echo "dump_debug_trace_once begin"

    if [ ! -d ${DEBUG_DIR_PATH} ]; then
        mkdir -p ${DEBUG_DIR_PATH}
    fi
    cd ${DEBUG_DIR_PATH}

    dump_android_trace_once
    dump_linux_trace_once
    dump_callmanager_trace_once
    dump_network_trace_once

    #echo "dump_debug_trace_once end"
}

function dump_debug_trace_timing()
{
    #echo "dump_debug_trace_timing begin"
	
    if [ ! -d ${DEBUG_DIR_PATH} ]; then
        mkdir -p ${DEBUG_DIR_PATH}
    fi
    cd ${DEBUG_DIR_PATH}
    
    while true; do
        check_debug_trace
        if [ ! $? -eq 1 ]; then
            #echo "dump_debug_trace_timing: debug mode is disabled."
            break
        fi
        dump_android_trace_timing
        dump_linux_trace_timing
        dump_network_trace_timing
        dump_callmanager_trace_timing
        sleep 300
        if [ $? -ne 0 ]; then
            #echo "dump_debug_trace_timing: sleep failed"
            break
        fi

        check_logcat_size
        #check_tcpdump_size
    
        debug_catalog_size
        if [ $? -ne 0 ]; then
           disable_debug_trace
           /system/usr/sbin/busybox-armv6l pkill -f "logcat"
           stop_debug_trace
           echo "sdcard is not enough"
           break
        fi
	
        check_sdcard_enough_in_running
        if [ $? -ne 0 ]; then
           disable_debug_trace
           /system/usr/sbin/busybox-armv6l pkill -f "logcat"
           stop_debug_trace
           echo "sdcard is not enough"
           break
        fi
    done
    #echo "dump_debug_trace_timing end"
}

#logСǷ񳬹50M
function check_logcat_size()
{
    #echo "check_logcat_size  ${DUMPFILE_LOGCAT}"
    size=`/system/usr/sbin/busybox-armv6l du -m -x ${DUMPFILE_LOGCAT} |  busybox awk '{print $1}'`
    echo "${DUMPFILE_LOGCAT} size = ${size}"
    if [ $size -gt 50 ]; then
        /system/usr/sbin/busybox-armv6l pkill -f "logcat"
        busybox tar -cf ${DUMPFILE_LOGCAT}.tar ${DUMPFILE_LOGCAT}
        gzip ${DUMPFILE_LOGCAT}.tar
        rm ${DUMPFILE_LOGCAT}
        logcat -c
        

        if [ ! -f ${DEBUG_PATH_FILE} ]; then
            #echo "${DEBUG_PATH_FILE} is not exist."
            return 0
        fi

        DEBUG_PATH=$(cat ${DEBUG_PATH_FILE})
        MODULE_ANDROID_DIR_PATH=${DEBUG_DIR_PATH}/${MODULE_ANDROID_DIR}
        DUMPFILE_LOGCAT=${MODULE_ANDROID_DIR_PATH}/logcat-$(date +%Y-%m-%d-%H-%M-%S)
        echo "DUMPFILE_LOGCAT: $DUMPFILE_LOGCAT"
        #ﻹ»ȡļʱ
        logcat -v time -f ${DUMPFILE_LOGCAT} &
    fi
}

#pcapСǷ񳬹50M
function check_tcpdump_size()
{
    echo "check_tcpdump_size  ${DUMPFILE_TCPDUMP}"
    size=`/system/usr/sbin/busybox-armv6l du -m -x ${DUMPFILE_TCPDUMP} |  busybox awk '{print $1}'`
    echo "${DUMPFILE_TCPDUMP} size = ${size}"
    if [ $size -gt 50 ]; then
        /system/usr/sbin/busybox-armv6l pkill -f "tcpdump"
        busybox tar -cf ${DUMPFILE_TCPDUMP}.tar ${DUMPFILE_TCPDUMP}
        gzip ${DUMPFILE_TCPDUMP}.tar
        rm ${DUMPFILE_TCPDUMP}

        if [ ! -f ${DEBUG_PATH_FILE} ]; then
            #echo "${DEBUG_PATH_FILE} is not exist."
            return 0
        fi

        DEBUG_PATH=$(cat ${DEBUG_PATH_FILE})
        MODULE_NETWORK_DIR_PATH=${DEBUG_DIR_PATH}/${MODULE_NETWORK_DIR}
        DUMPFILE_TCPDUMP=${MODULE_NETWORK_DIR_PATH}/tcpdump-$(date +%Y-%m-%d-%H-%M-%S).pcap
        #echo "DUMPFILE_TCPDUMP: $DUMPFILE_TCPDUMP"

        #ﻹ»ȡļʱ
        /system/xbin/tcpdump -vv -i any -s 0 -w ${DUMPFILE_TCPDUMP} host !127.0.0.1 &
    fi
}

#Ϣ
function export_debug_trace()
{
    echo "export_debug_trace begin"

    EXPORT_PATH=$1

    if [ -z "$EXPORT_PATH" ]; then
        #echo "Debug:path error"
        return 1
    fi

    if [ ! -f ${DEBUG_PATH_FILE} ]; then
        #echo "${DEBUG_PATH_FILE} is not exist."
        return 0
    fi

    CHECK_PATH=$(cat ${DEBUG_PATH_FILE})
    DEBUG_DIR_PATH=${CHECK_PATH}'/debug'
    set_some_debug_file_name

    if [ ! -d ${DEBUG_DIR_PATH} ]; then
        mkdir -p ${DEBUG_DIR_PATH}
    fi
    cd ${DEBUG_DIR_PATH}

    dump_network_trace_timing

    #echo "EXPORT_PATH: $EXPORT_PATH"
    #echo "CHECK_PATH: $CHECK_PATH"
    #echo "DEBUG_DIR: $DEBUG_DIR"

    EXPORT_NAME=${DEBUG_DIR}-$(date +%Y-%m-%d-%H-%M-%S)
    setprop sys.debugexportname ${EXPORT_NAME}
    busybox tar -cf ${EXPORT_NAME}.tar *
    gzip ${EXPORT_NAME}.tar
    cp ${EXPORT_NAME}.tar.gz ${EXPORT_PATH}
    rm ${EXPORT_NAME}.tar.gz

    check_debug_trace
    if [ ! $? -eq 1 ]; then
        #echo "export_debug_trace: debug mode is disabled."
        rm -R ${DEBUG_DIR_PATH}
    fi
    echo "export_debug_trace end"
}

#ɾdebugĿ¼
function remove_debug_path()
{
   # echo "remove_debug_path start "
    if [ ! -f ${DEBUG_PATH_FILE} ]; then
        #echo "${DEBUG_PATH_FILE} is not exist."
        return 0
    fi

    DEBUG_PATH=$(cat ${DEBUG_PATH_FILE})
    DEBUG_DIR_PATH=${DEBUG_PATH}/'debug'
    #echo "${DEBUG_DIR_PATH}"

    if [ -d ${DEBUG_DIR_PATH} ]; then
        rm -R ${DEBUG_DIR_PATH}
    fi

    #echo "remove_debug_path end"
}

function check_sdcard_enough_in_running()
{
    #echo "check_sdcard_enough_in_running start!"
    if [ ! -f ${DEBUG_PATH_FILE} ]; then
        #echo "${DEBUG_PATH_FILE} is not exist."
        return 0
    fi

    state=$(cat ${DEBUG_PATH_FILE})
    #echo "check_sdcard_enough_in_running  ${state}"
    Available=`/system/usr/sbin/busybox-armv6l df -m ${state} | busybox sed -n 2p | busybox awk '{print $4}'`

    echo "check_sdcard_enough_in_running $Available"
    #жֵСǷΪڵ200MB
    if [ $Available -le 200 ];
    then 
        echo "storage is insuffcient"
    return 1
    fi

    #echo "check_sdcard_enough_in_running end!"
}

#debugĿ¼ĴС500M
function debug_catalog_size()
{
    echo "debug_catalog_size start"
    if [ ! -f ${DEBUG_PATH_FILE} ]; then
        #echo "${DEBUG_PATH_FILE} is not exist."
        return 0
    fi
    state=$(cat ${DEBUG_PATH_FILE})
    DEBUG_DIR_PATH=${CHECK_PATH}/debug
    #echo "debug_catalog_size ${DEBUG_DIR_PATH}"
    Available=`busybox du -sm ${DEBUG_DIR_PATH} | busybox awk '{print $1}'`

    echo "debug_catalog_size $Available"
    #жֵСǷΪڵ500MB
    if [ $Available -ge 500 ]; then 
        echo "debug catalog is insuffcient"
        return 1
    fi
    #echo "debug_catalog_size end!"
}

#ռǷ20%
function start_check_enough_sapce()
{
    #echo "start_check_enough_sapce start!"
    if [ ! -f ${DEBUG_PATH_FILE} ]; then
        echo "${DEBUG_PATH_FILE} is not exist."
        return 1
    fi

    state=$(cat ${DEBUG_PATH_FILE})
    #echo "start_check_enough_sapce  ${state}"
    Available=`/system/usr/sbin/busybox-armv6l df -m ${state} | busybox sed -n 2p | busybox awk '{print $4}'`

    #echo "$Available"
    #жֵСǷΪСڵ300MB
    if [ $Available -le 300 ]; then 
        echo "storage is insuffcient"
    return 1
    fi
    #echo "start_check_enough_sapce end!"
}

ARGS=`/system/usr/sbin/busybox-armv6l getopt -o heducrs:p: -l help,enable,disable,dump,check,remove,set:,export: -- "$@"`
if [ $? != 0 ] ; then echo "Terminating..." >&2 ; exit 1 ; fi
eval set -- "$ARGS"
while true;do
    case "$1" in
        -e|--enable)
            echo "-e | --enable"
            echo "enable begin"
            start_check_enough_sapce
            if [ $? -ne 0 ]; then
                disable_debug_trace
                remove_debug_path
            else
                enable_debug_trace
                start_debug_trace 
                dump_debug_trace_timing
            fi
            echo "enable end"
            break
            ;;
        -d|--disable)
            echo "-d | --disable"
            /system/usr/sbin/busybox-armv6l pkill -f "logcat"
            echo "disable begin"
            disable_debug_trace
            stop_debug_trace
            echo "disable end"
            break
            ;;
        -u|--dump)
            echo "-u | --dump"
            echo "dump begin"
            dump_network_trace_once
            dump_android_trace_once
            dump_linux_trace_once
            dump_callmanager_trace_once
            dump_android_trace_timing
            dump_linux_trace_timing
            dump_network_trace_timing
            dump_callmanager_trace_timing
            echo "dump end"
            break
            ;;
        -c|--check)
            echo "-c | --check"
            echo "check begin"
            check_debug_trace
            if [ ! $? -eq 0 ]; then
                start_debug_trace
                dump_debug_trace_timing
            fi
            echo "check end"
            break
            ;;
        -r|--remove)
            echo "-r | --remove"
            echo "remove begin"	
            remove_debug_path
            echo "remove end"
            break
            ;;
        -s|--set)
            echo "-s | --set"
            echo "set begin"	
            set_debug_path_trace $2
            shift 2
            echo "set end"
            break
            ;;
        -p|--export)
            echo "-p | --export"
            echo "export begin"
            export_debug_trace $2
            shift 2
            break
            ;;
        -h|--help)
            echo "-h | --help"
            shift
            ;;
        --)
            shift
            break
            ;;
        *)
            echo "unknown:{$1}"
            exit 1
            ;;
    esac
done
