#!/system/bin/sh

UPGRADE_PATH="/data/impupdate"
UPGRADE_CMD_FILE="$UPGRADE_PATH/update.cmd"
UPGRADE_LOG_FILE="$UPGRADE_PATH/update.log"
UPGRADE_CUSTOMDATA_PATH="$UPGRADE_PATH/customdata"
UPGRADE_PRE_UPDATE_FILE="$UPGRADE_CUSTOMDATA_PATH/pre_update.sh"
UPGRADE_UPDATE_FILE="$UPGRADE_CUSTOMDATA_PATH/update.sh"
UPGRADE_POST_UPDATE_FILE="$UPGRADE_CUSTOMDATA_PATH/post_update.sh"
UPGRADE_VERSION_FILE="$UPGRADE_CUSTOMDATA_PATH/version.txt"
UPGRADE_RELEASENOTE_FILE="$UPGRADE_CUSTOMDATA_PATH/releasenote.txt"

SYS_VERSION_FILE="/system/version/version.txt"
SYS_VERSION_HISTORY="/system/version/update_history.txt"

UPGRADE_DEFAULT_IMAGE_NAME="$UPGRADE_PATH/image.tar.gz"

PROP_UPGRADE="sys.imp.upgrade"
PROP_UPGRADE_FILE="sys.imp.upgrade.file"
PROP_BACKUP="sys.imp.backup"
PROP_BACKUP_FILE="sys.imp.backup.file"
PROP_RECOVERY="sys.imp.recovery"
PROP_RECOVERY_FILE="sys.imp.recovery.file"

BACKUP_PATH="/sdcard/impbackup"

RECOVERY_PATH="/data/imprecovery"
RECOVERY_CMD_FILE="$RECOVERY_PATH/recovery.cmd"
RECOVERY_LOG_FILE="/data/data/com.fanvil.settings/files/recovery.log"

#	update.log
#	0	ʼָҪϵͳɻָ
#	1	ûҵָļ
#	2	дʧ
#
#	100 ɹ
#	101 ѹʧ
#	102 ڻ
#


# $1 upgrade.tar.gz for upgrade
function do_upgrade()
{
	#backup_file=`date +%Y%m%d%H%M%S`
	#/system/usr/sbin/imp_backup.sh "$BACKUP_PATH/$backup_file"
	
	upgrade_file=$1
	mkdir -p $UPGRADE_CUSTOMDATA_PATH
	#УѹԶ
	tar zxf $upgrade_file data/customdata/* -C $UPGRADE_CUSTOMDATA_PATH
	
	chmod -R 777 $UPGRADE_CUSTOMDATA_PATH
	
	#ԶԤ
	if [ -f $UPGRADE_PRE_UPDATE_FILE ]; then
		$UPGRADE_PRE_UPDATE_FILE
	fi
	
	#ѹУ
	tar zxf $upgrade_file -C /
	if [ $? -ne 0 ]; then
		echo 101 > $UPGRADE_LOG_FILE
		return 1
	fi
	
	#Զ
	if [ -f $UPGRADE_UPDATE_FILE ]; then
		$UPGRADE_UPDATE_FILE
	fi
	
	echo 100 > $UPGRADE_LOG_FILE
	
	
	#Ҫverison.txtversion_history.txt
	version_path=${SYS_VERSION_FILE%/*}
	if [ ! -d $version_path ]; then
		mkdir -p $version_path
	fi
	
	history=`cat $SYS_VERSION_HISTORY`
	update_time=`date +%Y-%m-%d_%H.%M.%S`
	
	if [ -f $UPGRADE_VERSION_FILE ]; then
		echo "time:"$update_time > $SYS_VERSION_FILE
		cat $UPGRADE_VERSION_FILE >> $SYS_VERSION_FILE
		
		echo $update_time > $SYS_VERSION_HISTORY
		cat $UPGRADE_VERSION_FILE >> $SYS_VERSION_HISTORY
	fi
	
	echo "---------------------" >> $SYS_VERSION_HISTORY
	echo "update log:"
	echo $history >> $SYS_VERSION_HISTORY
	
	
	#ɾԶĿ¼
	rm -r $UPGRADE_CUSTOMDATA_PATH
	#ɾ汾
	rm $upgrade_file
}

#	recovery.log
#	0	ʼָҪϵͳɻָ
#	1	ûҵָļ
#	2	дʧ
#	
#	100	ݳɹ
#	101	ѹʧ
#	102	ݰڻ

# $1 *.tar.gz
function do_recovery()
{	
	recovery_file=$1
	
	echo "entern do_recovery: file=$recovery_file"
	
	cd /
	recovery_tmp_file=data/imprecovery/tmp.tar
	gunzip -c $recovery_file > $recovery_tmp_file
	tar xf $recovery_tmp_file
	
	if [ $? -ne 0 ]; then
		echo 101 > $RECOVERY_LOG_FILE
		return 1
	else	
		echo 100 > $RECOVERY_LOG_FILE
	fi
	
	rm $recovery_tmp_file
}

#$1 *.impbk.tar.gz
function start_recovery()
{
	recovery_file=`getprop $PROP_RECOVERY_FILE`
	echo "recovery file: " "$recovery_file"
	
	if [ ! -f $recovery_file ]; then
		echo "The specified file not exist!"
		echo 1 > $RECOVERY_LOG_FILE
		return 1
	fi
	
	recovery_cmd_path=${RECOVERY_CMD_FILE%/*}
	if [ ! -d $recovery_cmd_path ]; then
		mkdir -p $recovery_cmd_path
	fi	
	echo $recovery_file > $RECOVERY_CMD_FILE
	
	if [ $? -ne 0 ]; then
		echo 2 > $RECOVERY_LOG_FILE
	else
		echo 0 > $RECOVERY_LOG_FILE
		echo "reboot to recovery"
	fi	
}

# ǰɨĿ¼
function start_upgrade()
{	
	#upgrade_file=`getprop $PROP_UPGRADE_FILE`
	#echo "upgrade file: " $upgrade_file
	
	#if [ ! -f $upgrade_file ]; then
	#	echo "The specified file not exist!"
	#	echo 1 > $UPGRADE_LOG_FILE
	#	return 1
	#fi
	
	upgrade_cmd_path=${UPGRADE_CMD_FILE%/*}
	if [ ! -d $upgrade_cmd_path ]; then
		mkdir -p $upgrade_cmd_path
	fi
	
	rm $UPGRADE_CMD_FILE
	if [ -f $UPGRADE_DEFAULT_IMAGE_NAME ]; then
		echo $UPGRADE_DEFAULT_IMAGE_NAME > $UPGRADE_CMD_FILE
	fi
	
	find $upgrade_cmd_path | awk '$1~/\.tar.gz$/ && $1!="$UPGRADE_DEFAULT_IMAGE_NAME" {print $1} ' >> $UPGRADE_CMD_FILE
	
	#echo $upgrade_file > $UPGRADE_CMD_FILE
	
	if [ $? -ne 0 ]; then
		echo 2 > $UPGRADE_LOG_FILE
	else
		echo 0 > $UPGRADE_LOG_FILE
		echo "reboot to upgrade"
	fi
}

# $1 *.tar.gz file
function tar_sanity_test()
{	
	echo "tar_sanity_test: file="$1
	
	if [ -f $1 ]; then
		return 0
	else
		return 1
	fi
	
	return 1
}

#app״̬¿ʼָ
if [ "$#" -eq "1" ]; then
	if [ $1 = "upgrade" ]; then
		start_upgrade
	elif [ $1 = "recovery" ]; then
		start_recovery
	elif [ $1 = "never_upgrade" ]; then
		#upgrade_file=`getprop $PROP_UPGRADE_FILE`
		#ɾĿ¼
		rm -rf $UPGRADE_PATH
	fi
else
	#ӣҪ
	ln -s /system/bin/busybox /system/bin/cp
	ln -s /system/bin/busybox /system/bin/tftp
	ln -s /system/bin/busybox /system/bin/tar
	ln -s /system/bin/busybox /system/bin/gunzip
	busybox rm /system/bin/rm
	ln -s /system/bin/busybox /system/bin/rm
	ln -s /system/bin/busybox /system/bin/vi
	ln -s /system/bin/busybox /system/bin/awk
	ln -s /system/bin/busybox /system/bin/find
	
	if [ -f $UPGRADE_CMD_FILE ]; then
		
		#ж,logļһ汾Ϊ
		while read file; do
			tar_sanity_test $file
			if [ $? -ne 0 ]; then
	                        echo 102 > $UPGRADE_LOG_FILE
			else
				do_upgrade $file
			fi
		done < $UPGRADE_CMD_FILE
		
		
		
		# remove upgrade file, no matter upgrade success or fail
		rm $UPGRADE_CMD_FILE
	fi
        
	if [ -f $RECOVERY_CMD_FILE ]; then
		recovery_file=`cat $RECOVERY_CMD_FILE`
		
		echo "entry recovery: file="$recovery_file
		
		tar_sanity_test $recovery_file
		if [ $? -ne 0 ]; then
			echo 102 > $RECOVERY_LOG_FILE
		else
			do_recovery $recovery_file
		fi
		
		rm $RECOVERY_CMD_FILE
	fi
fi


