#!/system/bin/sh

DEBUG_DIR=debug_$(date +%y%m%d%H%M%S)

MODULE_NETWORK_DIR="network"

MODULE_CM_DIR="cm"
VERSION_PATH="/system/etc/mt"
VERSION_DIR="version"
PRODUCT="product"
CALLMANAGER_PATH="/data/data/com.fanvil.callmanager"
CONFIG_FILE="config.txt"

MODULE_ANDROID_DIR="android"
DATA_PATH="/data"
ANR_PATH="/data/anr"
ANR_DIR="anr"
TRACES_FILE="traces.txt"
TOMBSTONES_PATH="/data/tombstones"
TOMBSTONES_DIR="tombstones"
DROPBOX_PATH="/data/system/dropbox"
DROPBOX_DIR="dropbox"
ETC_PATH="/system/etc"
SYSTEM_PATH="/system"
BUILD_PROP="build.prop"
DEFAULT_PROP="default.prop"
PROP_DIR="property"

MODULE_LINUX_DIR="linux"
	
#======================
# network
#    ifconfig
#======================
function do_network()
{
	echo "Debug:network starting..."

	mkdir $MODULE_NETWORK_DIR

	#ifconfig
	busybox ifconfig >> $MODULE_NETWORK_DIR/network.txt
	
	echo "Debug:network stop"
}

#======================
# callmanager
#     version
#     product
#     config
#======================
function do_callmanager()
{
	echo "Debug:callmanager starting..."

	mkdir $MODULE_CM_DIR

	# version
    if [ -d $VERSION_PATH ]; then
		mkdir ${MODULE_CM_DIR}/${VERSION_DIR}
		cp -f ${VERSION_PATH}/* ${MODULE_CM_DIR}/${VERSION_DIR}
	fi
	
	# product id
	cp -f ${ETC_PATH}/${PRODUCT} $MODULE_CM_DIR
	
	# config
    if [ -d $CALLMANAGER_PATH ]; then
		cp -f ${CALLMANAGER_PATH}/${CONFIG_FILE} $MODULE_CM_DIR
	fi

	echo "Debug:callmanager stop"
}

#======================
# android
#     anr
#     tombstones
#     dropbox
#     logcat
#     dumpstate
#     dumpsys
#     property
#=======================
function do_android()
{
	echo "Debug:android starting..."

	mkdir $MODULE_ANDROID_DIR

	#anr
	if [ -d $ANR_PATH ]; then
		mkdir ${MODULE_ANDROID_DIR}/${ANR_DIR}
		cp -Rf ${ANR_PATH}/* ${MODULE_ANDROID_DIR}/${ANR_DIR}
    fi
	
	#tombstones
	if [ -d $TOMBSTONES_PATH ]; then
		mkdir ${MODULE_ANDROID_DIR}/${TOMBSTONES_DIR}
		cp -Rf $TOMBSTONES_PATH/* ${MODULE_ANDROID_DIR}/${TOMBSTONES_DIR}
    fi

	#dropbox
	if [ -d $DROPBOX_PATH ]; then
        mkdir ${MODULE_ANDROID_DIR}/${DROPBOX_DIR}
		cp -Rf $DROPBOX_PATH/* ${MODULE_ANDROID_DIR}/${DROPBOX_DIR}
    fi
	
	#logcat 
	logcat -v time -d -f $MODULE_ANDROID_DIR/logcat.txt
		
	#dumpstate
	dumpstate > $MODULE_ANDROID_DIR/dumpstate.txt

	#dumpsys
	dumpsys > $MODULE_ANDROID_DIR/dumpsys.txt
	
	# property
	mkdir ${MODULE_ANDROID_DIR}/${PROP_DIR}

	# build.prop
	cp -f ${SYSTEM_PATH}/${BUILD_PROP} ${MODULE_ANDROID_DIR}/${PROP_DIR}
	
	# deault.prop
	cp -f ${SYSTEM_PATH}/${DEFAULT_PROP} ${MODULE_ANDROID_DIR}/${PROP_DIR}

	#system properties
	getprop > ${MODULE_ANDROID_DIR}/${PROP_DIR}/getprop.txt

	echo "Debug:android stop"
}

#=======================
# linux
#     memory
#     dmesg
#=======================
function do_linux()
{
	echo "Debug:linux starting..."

	mkdir $MODULE_LINUX_DIR

	# memory
	/system/usr/sbin/busybox-armv6l free -m > $MODULE_LINUX_DIR/memory.txt

	#linux kernel message	
	dmesg > $MODULE_LINUX_DIR/dmesg.txt

	echo "Debug:linux stop"
}

function do_debug()
{
	EXPORT_PATH=$1

	if [ -z "$EXPORT_PATH" ]; then
        echo "Debug:path error"
        return 1
    fi

	cd $EXPORT_PATH

	if [ ! -d $DEBUG_DIR ]; then
        mkdir $DEBUG_DIR
		if [ $? -ne 0 ]; then
			echo "Debug:failed"
			return 1
		fi
    fi
	
	cd $DEBUG_DIR

	do_linux
	
	do_callmanager
	
	do_network
	
	do_android

	cd $EXPORT_PATH

	busybox tar -cf ${DEBUG_DIR}.tar $DEBUG_DIR
	gzip ${DEBUG_DIR}.tar

	rm -R $DEBUG_DIR
}

do_debug $1
ret=$?
if [ $? -ne 0 ]; then
	echo "Debug:failed"
else
	echo "Debug:success"
fi
exit $ret
