#!/system/bin/sh

function version_check()
{
    HARDWARE_VERSION_PROC_FILE=/proc/hardware_version
    VERSION_FILE=/system/etc/mt/version.txt
    EXTENSION_VERSION_FILE=/system/etc/mt/extension.version
    HARDWARE_VERSION_FILE=/system/etc/mt/hardware.version
    VOLTAGE_FILE=/proc/soc/classd_voltage

    if [ ! -f "$HARDWARE_VERSION_PROC_FILE" ];then
        echo $HARDWARE_VERSION_PROC_FILE" not exists!"
        return 1
    fi

    HARDWARE_VERSION=`cat $HARDWARE_VERSION_PROC_FILE`
    echo "Hardware Version: "$HARDWARE_VERSION
    echo $HARDWARE_VERSION > $HARDWARE_VERSION_FILE

    if [ "$HARDWARE_VERSION" = "V1.0" ]; then
        if [ ! -f "$VOLTAGE_FILE" ];then
            echo $VOLTAGE_FILE" not exists!"
            return 1
        fi

        VOLTAGE=`cat $VOLTAGE_FILE`
        echo "current classd voltage: "$VOLTAGE

        if [ ! -f "$EXTENSION_VERSION_FILE" ];then
            echo $EXTENSION_VERSION" not exists!"
            return 1
        fi

        EXTENSION_VERSION=`cat $EXTENSION_VERSION_FILE`
        echo "current extension.version: "$EXTENSION_VERSION

        if [ "$VOLTAGE" = "40" ];then
            if [ "$EXTENSION_VERSION" = "B" ]; then

               echo "D" > $EXTENSION_VERSION_FILE
               echo "new extension.version: "`cat $EXTENSION_VERSION_FILE`
            fi

            VERSION=`cat $VERSION_FILE`
            echo "current version: "$VERSION

            EXTENSION=`echo ${VERSION:((${#VERSION} - 1))}`
            echo "current extension: "$EXTENSION

            if [ "$EXTENSION" = "B" ]; then
               busybox sed -i s'/.$/D/g' $VERSION_FILE
               echo "new version: "`cat $VERSION_FILE`
            fi
        fi
    elif [ "$HARDWARE_VERSION" = "V2.0" -o "$HARDWARE_VERSION" = "V3.0" ]; then
        VERSION=`cat $VERSION_FILE`
        echo "current version: "$VERSION
        busybox sed -i s"/.$/2/g" $VERSION_FILE
        echo "new version: "`cat $VERSION_FILE`
    fi
}
