#!/system/bin/sh

# /system/usr/sbin/imp_backup.sh /xxx/xxx/xxx.tar.gz
#

#	backup.log
#	0	ݳɹ
#	1	LOGļʧ
#	2	Ŀ¼ʧ
#	3	ļʧ		

BACKUP_LOG_PATH="/data/data/com.fanvil.settings/files"
BACKUP_LOG_FILE="$BACKUP_LOG_PATH/backup.log"

PROP_BACKUP="sys.imp.backup"
PROP_BACKUP_FILE="sys.imp.backup.file"

BACKUP_MODULES="data/data/com.android.providers.contacts \
		data/data/com.android.providers.telephony \
		data/data/com.android.providers.settings \
		data/data/com.android.providers.calendar \
		data/data/com.fanvil.callmanager \
		data/data/com.fanvil.mtservice \
		data/data/com.fanvil.settings "

function do_backup()
{	
	backup_file=`getprop $PROP_BACKUP_FILE`
	backup_file_path=${backup_file%/*}
	
	echo "backup file: " $backup_file
	echo "backup file path: " $backup_file_path

	if [ ! -d $BACKUP_LOG_PATH ]; then
		mkdir -p $BACKUP_LOG_PATH
		
		if [ $? -ne 0 ]; then
			echo 1 > $BACKUP_LOG_FILE
			return 1
		fi
	fi 	
	
	
	if [ ! -d $backup_file_path ]; then
		mkdir -p $backup_file_path
		
		if [ $? -ne 0 ]; then
			echo 2 > $BACKUP_LOG_FILE
			return 1
		fi
	fi	
	
	cd /	
	backup_modules=""
	for module in $BACKUP_MODULES; do
		if [ -d $module ]; then
			backup_modules="$backup_modules $module"
		fi	
	done	
	
	echo "backup modules:\n"$backup_modules	
	
	busybox tar -cf $backup_file.tar $backup_modules
	gzip $backup_file.tar
	
	if [ $? -ne 0 ]; then
		echo 3 > $BACKUP_LOG_FILE
	else
		echo 0 > $BACKUP_LOG_FILE
	fi 
	
}


#if [ "$#" -lt "1" ]; then
#	echo "param missing!"
#	exit 1;
#fi


do_backup
ret=$?

exit $ret
