#set -x
# Phenix 2011-11-23 18:30
# config-vlan.sh
# Set up VLAN with following parameters
# $1 enable voice VLAN 1:enable 0:disable
# $2 voice VLAN ID 0~4095
# $3 data VLAN type 0: follow (VID same as voice VLAN) 1: un-tagged 2: tagged
# $4 data VLAN ID 0~4095

if [ ! -c /dev/esw ]; then
    busybox mknod /dev/esw c 270 0
fi

if [ $# -ne 4 ]; then
    echo "Syntax : $0 <Voice Vlan type> <Voice Vlan ID> <Data Vlan type> <Data Vlan ID>"
    exit 1
fi

VOICE_VLAN_TYPE=$1
VOICE_VLAN_ID=$2
DATA_VLAN_TYPE=$3
DATA_VLAN_ID=$4

#pbmp: Port bitmap of VLAN ports.
#ubmp: Port bitmap of VLAN ports whose associated packets will not contain the IEEE 802.1q tag header.
pbmp=0x000
ubmp=0x000
hardware_version=`getprop ro.fanvil.hardware.version`
product=`cat /etc/product`
if [ $product = "7900" ]; then
    if [ $hardware_version = "v1" ]; then
        #for D900, 2:LAN 1:PC 5:CPU
        echo "This is D900"
        PORT_PC=1
        PORT_LAN=2
        PORT_CPU=5
        PORT_PC_BITMAP=0x02
        PORT_LAN_BITMAP=0x04
        PORT_CPU_BITMAP=0x20
    elif [ $hardware_version = "v2" ]; then
        #for D900, 1:LAN 3:PC 16:CPU
        echo "This is D900"
        PORT_PC=3
        PORT_LAN=1
        PORT_CPU=16
        PORT_PC_BITMAP=0x08
        PORT_LAN_BITMAP=0x02
        PORT_CPU_BITMAP=0x10000
    fi
else
    if [ $hardware_version = "v1" ]; then
        #for X600, 2:LAN 1:PC 5:CPU
        echo "This is X600"
        PORT_PC=2
        PORT_LAN=1
        PORT_CPU=5
        PORT_PC_BITMAP=0x04
        PORT_LAN_BITMAP=0x02
        PORT_CPU_BITMAP=0x20
    elif [ $hardware_version = "v2" ]; then
        #for X600, 1:LAN 3:PC 16:CPU
        echo "This is X600"
        PORT_PC=3
        PORT_LAN=1
        PORT_CPU=16
        PORT_PC_BITMAP=0x08
        PORT_LAN_BITMAP=0x02
        PORT_CPU_BITMAP=0x10000
    fi
fi

# Initiallize or re-init VLAN
eth vlan init

#according to VLAN type their should be 2x3=6 cases of VLAN
#voice vlan type=0 and data vlan type != 2, no process need then

#case 0,1
if [ $VOICE_VLAN_TYPE -eq 0 -a $DATA_VLAN_TYPE -ne 2 ];then
  exit 0
fi


#add vlan map

#case 2
if [ $VOICE_VLAN_TYPE -eq 0 -a $DATA_VLAN_TYPE -eq 2 ];then
  if [ $DATA_VLAN_ID -eq "1" ]; then
      let VOICE_VLAN_ID=0
  else
      let VOICE_VLAN_ID=1
  fi

  eth vlan port vid $PORT_PC  $DATA_VLAN_ID
  eth vlan port vid $PORT_LAN $VOICE_VLAN_ID
  eth vlan port vid $PORT_CPU $VOICE_VLAN_ID

  let pbmp=$PORT_CPU_BITMAP+$PORT_LAN_BITMAP
  let ubmp=$PORT_CPU_BITMAP+$PORT_LAN_BITMAP
  eth vlan table add $VOICE_VLAN_ID $pbmp $ubmp

  let pbmp=$PORT_PC_BITMAP+$PORT_LAN_BITMAP
  let ubmp=$PORT_PC_BITMAP
  eth vlan table add $DATA_VLAN_ID $pbmp $ubmp
fi


#case 3
if [ $VOICE_VLAN_TYPE -eq 1 -a $DATA_VLAN_TYPE -eq 0 ];then

  eth vlan port vid $PORT_PC  $VOICE_VLAN_ID
  eth vlan port vid $PORT_LAN $VOICE_VLAN_ID
  eth vlan port vid $PORT_CPU $VOICE_VLAN_ID

  let pbmp=$PORT_CPU_BITMAP+$PORT_LAN_BITMAP+$PORT_PC_BITMAP
  let ubmp=$PORT_CPU_BITMAP+$PORT_PC_BITMAP
  eth vlan table add $VOICE_VLAN_ID $pbmp $ubmp

fi


#case 4
if [ $VOICE_VLAN_TYPE -eq 1 -a $DATA_VLAN_TYPE -eq 1 ];then
  if [ $VOICE_VLAN_TYPE -eq "1"]; then
      DATA_VLAN_ID=0
  else
      DATA_VLAN_ID=1
  fi

  eth vlan port vid $PORT_PC  $DATA_VLAN_ID
  eth vlan port vid $PORT_LAN $DATA_VLAN_ID
  eth vlan port vid $PORT_CPU $VOICE_VLAN_ID

  let pbmp=$PORT_CPU_BITMAP+$PORT_LAN_BITMAP
  let ubmp=$PORT_CPU_BITMAP
  eth vlan table add $VOICE_VLAN_ID $pbmp $ubmp

  let pbmp=$PORT_PC_BITMAP+$PORT_LAN_BITMAP
  let ubmp=$PORT_PC_BITMAP+$PORT_LAN_BITMAP
  eth vlan table add $DATA_VLAN_ID  $pbmp $ubmp

fi

#case 5
if [ $VOICE_VLAN_TYPE -eq 1 -a $DATA_VLAN_TYPE -eq 2 ];then
  if [ $DATA_VLAN_ID -eq $VOICE_VLAN_ID ]; then
    eth vlan port vid $PORT_PC  $VOICE_VLAN_ID
    eth vlan port vid $PORT_LAN $VOICE_VLAN_ID
    eth vlan port vid $PORT_CPU $VOICE_VLAN_ID

    let pbmp=$PORT_CPU_BITMAP+$PORT_LAN_BITMAP+$PORT_PC_BITMAP
    let ubmp=$PORT_CPU_BITMAP+$PORT_PC_BITMAP
    eth vlan table add $VOICE_VLAN_ID $pbmp $ubmp
  else

    eth vlan port vid $PORT_PC  $DATA_VLAN_ID
    eth vlan port vid $PORT_LAN $VOICE_VLAN_ID
    eth vlan port vid $PORT_CPU $VOICE_VLAN_ID

    let pbmp=$PORT_CPU_BITMAP+$PORT_LAN_BITMAP
    let ubmp=$PORT_CPU_BITMAP
    eth vlan table add $VOICE_VLAN_ID $pbmp $ubmp

    let pbmp=$PORT_PC_BITMAP+$PORT_LAN_BITMAP
    let ubmp=$PORT_PC_BITMAP
    eth vlan table add $DATA_VLAN_ID  $pbmp $ubmp

  fi
fi

