var config = {
    "isShowIAX2":0,
    "isShowWifi":0,
    "isShowLAN":0,
    "isShowVPN":1,
    "isShowSotfKey":1,
    "supportBlackList":1,
    "isShowContact":1,
    "videoSettingsLabel":0,
    "AnsDialMode":1,
    "isShowFilter":1,
    "memoryKeyValue":1,
    "isShowActionPlan":1,
    "isShowRecord":1,
    "isShowDoorPhone":1,
    "isShowIpv6_conf":0,
    "isShowScreenRecord":0,
    "dsskeyIconsShow":0,
    "fileSizeMax_Ring":1024*1024,
    "fileSizeMax_Cert":1024*10,
    "fileSizeMax_Icon":1024*10,
    "fileSizeMax_Pbook":1024*1024,
    "fileSizeMax_Bmp":1024*1024,
    "enableRecord":"",
    "inforHardware":"",
    "sysNetwork":"",
    "clearTable":"",
    "clearEtc":"",
    "ringUpgrade":"",
    "backPictureUpgrade":"",
    "dsskeyIconsSetting":"",
    "DnsDomain":"none",
    "handsetVolume":"none",
    "SpeakerphoneVolume":"none",
    "HeadsetVolume":"none",
    "TimeSynchronizedviaDHCP":"",
    "TimeSynchronizedviaDHCPv6":"none",
    "DateFormat":"",
    "DaylightSavingTimeSettings":"",
    "ScreenConfiguration":"",
    "LCDMenuPasswordSettings":"",
    "keyboardSettings":"",
    "ManageCloudPhonebooks":"",
    "LDAPSettings":"",
    "bw_ldap":"",
    "callLog":"",
    "deviceLog":"",
    "RingType":"",
    "application":"",
    "appBr":"",
    "EnableTelnet":"",
    "TelnetPort":"",
    "PPTP":"",
    "PPTPTitle":"",
    "PPTPBody":"",
    "CallerDisplayType":"",
    "RedialSetting":"",
    "PowerLED":"",
    "LineLED":"",
    "BLF_LED":"",    
    "TIM_DateFormat_RW":[],
    "contrast":"",
    "PINtoLock":"",
    "softkeyModeShow":"none",
    "softkeyExitStyleShow":"none",
    "vpnModeShow":"none",    
    "vpnStatusShow":"none",    
    "FUN_Key_SubType_KESelector":[],
    "FUN_Key_Type_Selector":[],
    "selectCustomSoftKey":[2,10,11],
    "POWER_LIGHT":"",
    "ProgrammableTitle":"",
    "ProgrammableBody":"",
    "dspEhsType":"none",
    "IlbcPayloadType":"",
    "G_723_1_BitRate":"none",
    "disableMuteforRing":"none",
    "HciCapture":"none",
    "isShowDtmfCode":"none",
    "sideKeyTransferForm":"none",
    "httpPort":[0,65535],
    "httpsPort":[0,65535]
};

function getConfig() {
    //var displayTokenList = document.querySelectorAll("[displaytoken='product']");
    var displayTokenArr = new Array();
    var elemArr = ["form", "div", "tr", "td", "li"];
    for(var j=0; j<elemArr.length; j++){
        var elems = document.getElementsByTagName(elemArr[j]);
        for(var i=0; i<elems.length; i++){
            if(elems[i].getAttribute("displaytoken") == "product"){
                displayTokenArr[displayTokenArr.length] = elems[i];
            }
        }
    }

    for (var i = 0; i < displayTokenArr.length; i++) {
        var displayTokenID = displayTokenArr[i].id;
        displayTokenArr[i].style.display = config[displayTokenID];
    }

    //var optionRm = document.querySelectorAll("[optionrm = 'true']");
    var optionRm = new Array();
    var selects = document.getElementsByTagName("select");
    for(var i=0; i<selects.length; i++){
        if(selects[i].getAttribute("optionrm") == "true"){
            optionRm[optionRm.length] = selects[i];
        }
    }

    for (var i = 0; i < optionRm.length; i++) {
        var selectID = optionRm[i].id;
        var configname = selectID.split("(")[0];
        var selectElement = document.getElementById(selectID);
        var optionNum = config[configname];

        for (var j = 0; j < optionNum.length; j++) {
            if (j == 0) {
                selectElement.options.remove(optionNum[j]);
            } else {
                selectElement.options.remove(optionNum[j] - j);
            }
        }
    }

    var forms = document.getElementsByTagName("form");
    for(var i=0; i<forms.length; i++){
        //var sizeControlElement = forms[i].querySelectorAll("[sizeControl = 'true']");
        var inputs = forms[i].getElementsByTagName("input");
        var sizeControlElement = new Array();
        var submitBtn;
        for(var n=0; n<inputs.length; n++){
            if(inputs[n].getAttribute("sizeControl") == "true"){
                sizeControlElement[sizeControlElement.length] = inputs[n];
            }
            if(inputs[n].getAttribute("type") == "submit"){
                submitBtn = inputs[n];
            }
        }
        if(sizeControlElement.length > 0 ){
            for(var j=0; j<sizeControlElement.length; j++){
                var span = document.createElement("span");
                var elId = sizeControlElement[j].id;
                var startSize = config[elId][0];
                var endSize = config[elId][1];
                if (parseInt(startSize) >= 1024)
                {
                    span.innerHTML = "(" + startSize + "~" + endSize + ")";
                }
                insertAfter(span, sizeControlElement[j]);
                sizeControlElement[j].oninput = function(){
                    var isRight = true;
                    var errorBox = new Array();
                    var rightBox = new Array();
                    for(var n = 0; n<sizeControlElement.length; n++){
                        var val = sizeControlElement[n].value;
                        var elemid = sizeControlElement[n].id;
                        var start = config[elemid][0];
                        var end = config[elemid][1];
                        if(parseInt(val) < parseInt(start) || parseInt(val) > parseInt(end)){
                            isRight = false;
                            errorBox[errorBox.length] = sizeControlElement[n]
                        }else{
                            rightBox[rightBox.length] = sizeControlElement[n];
                        }
                    }

                    if(isRight){
                        submitBtn.disabled = false;
                        for(var m=0; m<sizeControlElement.length; m++){
                            sizeControlElement[m].style.border = "1px solid #7F9DB9";
                        }
                    }else{
                        submitBtn.disabled = true;
                        for(var m=0; m<errorBox.length; m++){
                            errorBox[m].style.border = "1px solid #aa0000";
                        }
                        for(var m=0; m<rightBox.length; m++){
                            rightBox[m].style.border = "1px solid #7F9DB9";
                        }
                    }
                }
            }
        }
    }
}

function insertAfter( newElement, targetElement ){
    var parent = targetElement.parentNode;
    if( parent.lastChild == targetElement ){
        parent.appendChild( newElement, targetElement );
    }else{
        parent.insertBefore( newElement, targetElement.nextSibling );
    };
};
