#set -x
# Phenix 2019-03-27 18:30
# imp_config_vlan.sh
# Set up VLAN with following parameters
# $1 enable voice VLAN 1:enable 0:disable
# $2 voice VLAN ID 0~4095
# $3 data VLAN type 0: follow (VID same as voice VLAN) 1: un-tagged 2: tagged
# $4 data VLAN ID 0~4095

if [ $# -ne 4 ]; then
    echo "Syntax : $0 <Voice Vlan type> <Voice Vlan ID> <Data Vlan type> <Data Vlan ID>"
    exit 1
fi

VOICE_VLAN_TYPE=$1
VOICE_VLAN_ID=$2
DATA_VLAN_TYPE=$3
DATA_VLAN_ID=$4

#pbmp: Port bitmap of VLAN ports.
#ubmp: Port bitmap of VLAN ports whose associated packets will not contain the IEEE 802.1q tag header.
pbmp=0x000
ubmp=0x000

#for X7A, 1:LAN 3:PC 16:CPU
echo "This is X7A"
PORT_PC=3
PORT_LAN=1
PORT_CPU=16
PORT_PC_BITMAP=0x08
PORT_LAN_BITMAP=0x02
PORT_CPU_BITMAP=0x10000

# Initiallize or re-init VLAN
ethtool --init-vlan eth0

#according to VLAN type their should be 2x3=6 cases of VLAN
#voice vlan type=0 and data vlan type != 2, no process need then

#case 0,1
if [ $VOICE_VLAN_TYPE -eq 0 -a $DATA_VLAN_TYPE -ne 2 ];then
  exit 0
fi

#add vlan map

#case 2
if [ $VOICE_VLAN_TYPE -eq 0 -a $DATA_VLAN_TYPE -eq 2 ];then
  if [ $DATA_VLAN_ID -eq "1" ]; then
      let VOICE_VLAN_ID=0
  else
      let VOICE_VLAN_ID=1
  fi

  ethtool --set-untagged-vlan-port eth0 port $PORT_PC  vid $DATA_VLAN_ID
  ethtool --set-untagged-vlan-port eth0 port $PORT_LAN vid $VOICE_VLAN_ID
  ethtool --set-untagged-vlan-port eth0 port $PORT_CPU vid $VOICE_VLAN_ID

  let pbmp=$PORT_CPU_BITMAP+$PORT_LAN_BITMAP
  let ubmp=$PORT_CPU_BITMAP+$PORT_LAN_BITMAP
  ethtool --add-vlan-port eth0 vid $VOICE_VLAN_ID mbrmsk $pbmp untagmsk $ubmp

  let pbmp=$PORT_PC_BITMAP+$PORT_LAN_BITMAP
  let ubmp=$PORT_PC_BITMAP
  ethtool --add-vlan-port eth0 vid $DATA_VLAN_ID mbrmsk $pbmp untagmsk $ubmp
fi


#case 3
if [ $VOICE_VLAN_TYPE -eq 1 -a $DATA_VLAN_TYPE -eq 0 ];then

  let VOICE_VLAN_ID_FILTER=$VOICE_VLAN_ID+1
  if [ $VOICE_VLAN_ID_FILTER -ge 4095 ]; then
      VOICE_VLAN_ID_FILTER=0      
  fi
  
  ethtool --set-untagged-vlan-port eth0 port $PORT_PC vid $VOICE_VLAN_ID
  ethtool --set-untagged-vlan-port eth0 port $PORT_LAN vid $VOICE_VLAN_ID_FILTER
  ethtool --set-untagged-vlan-port eth0 port $PORT_CPU vid $VOICE_VLAN_ID

  let pbmp=$PORT_CPU_BITMAP+$PORT_LAN_BITMAP+$PORT_PC_BITMAP
  let ubmp=$PORT_CPU_BITMAP+$PORT_PC_BITMAP
  ethtool --add-vlan-port eth0 vid $VOICE_VLAN_ID mbrmsk $pbmp untagmsk $ubmp

fi


#case 4
if [ $VOICE_VLAN_TYPE -eq 1 -a $DATA_VLAN_TYPE -eq 1 ];then
  if [ $VOICE_VLAN_TYPE -eq "1"]; then
      DATA_VLAN_ID=0
  else
      DATA_VLAN_ID=1
  fi
  
  ethtool --set-untagged-vlan-port eth0 port $PORT_PC  vid $DATA_VLAN_ID
  ethtool --set-untagged-vlan-port eth0 port $PORT_LAN vid $DATA_VLAN_ID
  ethtool --set-untagged-vlan-port eth0 port $PORT_CPU vid $VOICE_VLAN_ID

  let pbmp=$PORT_CPU_BITMAP+$PORT_LAN_BITMAP
  let ubmp=$PORT_CPU_BITMAP
  ethtool --add-vlan-port eth0 vid $VOICE_VLAN_ID mbrmsk $pbmp untagmsk $ubmp
  
  let pbmp=$PORT_PC_BITMAP+$PORT_LAN_BITMAP
  let ubmp=$PORT_PC_BITMAP+$PORT_LAN_BITMAP
  ethtool --add-vlan-port eth0 vid $DATA_VLAN_ID mbrmsk $pbmp untagmsk $ubmp

fi

#case 5
if [ $VOICE_VLAN_TYPE -eq 1 -a $DATA_VLAN_TYPE -eq 2 ];then

    let VOICE_VLAN_ID_FILTER=$VOICE_VLAN_ID+1
    
  if [ $DATA_VLAN_ID -eq $VOICE_VLAN_ID ]; then
  
    ethtool --set-untagged-vlan-port eth0 port $PORT_PC  vid $VOICE_VLAN_ID
    ethtool --set-untagged-vlan-port eth0 port $PORT_LAN vid $VOICE_VLAN_ID_FILTER
    ethtool --set-untagged-vlan-port eth0 port $PORT_CPU vid $VOICE_VLAN_ID

    let pbmp=$PORT_CPU_BITMAP+$PORT_LAN_BITMAP+$PORT_PC_BITMAP
    let ubmp=$PORT_CPU_BITMAP+$PORT_PC_BITMAP
    ethtool --add-vlan-port eth0 vid $VOICE_VLAN_ID mbrmsk $pbmp untagmsk $ubmp
  else

    if [ $VOICE_VLAN_ID_FILTER -ge 4095 ]; then
      VOICE_VLAN_ID_FILTER=0      
    fi

    if [ $DATA_VLAN_ID -eq $VOICE_VLAN_ID_FILTER ]; then
     let VOICE_VLAN_ID_FILTER=$VOICE_VLAN_ID_FILTER+1
    fi

    if [ $VOICE_VLAN_ID_FILTER -ge 4095 ]; then
      VOICE_VLAN_ID_FILTER=0      
    fi

    ethtool --set-untagged-vlan-port eth0 port $PORT_PC  vid $DATA_VLAN_ID
    ethtool --set-untagged-vlan-port eth0 port $PORT_LAN vid $VOICE_VLAN_ID_FILTER
    ethtool --set-untagged-vlan-port eth0 port $PORT_CPU vid $VOICE_VLAN_ID

    let pbmp=$PORT_CPU_BITMAP+$PORT_LAN_BITMAP
    let ubmp=$PORT_CPU_BITMAP
    ethtool --add-vlan-port eth0 vid $VOICE_VLAN_ID mbrmsk $pbmp untagmsk $ubmp

    let pbmp=$PORT_PC_BITMAP+$PORT_LAN_BITMAP
    let ubmp=$PORT_PC_BITMAP
    ethtool --add-vlan-port eth0 vid $DATA_VLAN_ID mbrmsk $pbmp untagmsk $ubmp

  fi
fi

