/*
 * Decompiled with CFR 0.152.
 */
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class LicenseGenerator {
    private static final byte[] HMAC_KEY = new byte[]{1, 2, 3, 4, 1, 2, 3, 4, 1, 2, 3, 4, 1, 2, 3, 4};
    private static final byte[] HMAC_MSG = new byte[]{70, 117, 106, 105, 116, 115, 117, 33, 1, 1, -128, 40, 0, 0, -1, -1, 70, 117, 106, 105, 116, 115, 117, 33, 1, 1, -128, 40, 0, 0, -1, -1, 70, 117, 106, 105, 116, 115, 117, 33, 1, 1, -128, 40, 0, 0, -1, -1, 70, 117, 106, 105, 116, 115, 117, 33, 1, 1, -128, 40, 0, 0, -1, -1};
    private static final byte[] AES_IV = new byte[]{13, 14, 10, 13, 11, 14, 14, 15, 0, 1, 2, 3, 9, 8, 7, 6};

    public static void main(String[] stringArray) {
        if (stringArray.length < 3) {
            System.out.println("Usage: java LicenseGenerator <serial> <features> <type>");
            System.out.println("Example: java LicenseGenerator 123456789 kvm_media tx");
            return;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        if (HMAC_KEY.length != 16 || HMAC_MSG.length != 64 || AES_IV.length != 16) {
            System.out.println("You are missing the HMAC and AES values");
        } else {
            String string4 = LicenseGenerator.simpleGenerator(string2, string3, string);
            System.out.println(string4);
        }
    }

    private static String simpleGenerator(String string, String string2, String string3) {
        byte[] byArray;
        if (string.equalsIgnoreCase("kvm")) {
            byArray = new byte[]{1, 0, 0, 0};
        } else if (string.equalsIgnoreCase("kvm_media")) {
            byArray = new byte[]{3, 0, 0, 0};
        } else if (string.equalsIgnoreCase("kvm_media_elcm")) {
            if (string2.equalsIgnoreCase("tx")) {
                System.out.println("License may not be valid for TX chassis with eLCM enabled");
            }
            byArray = new byte[]{15, 0, 0, 0};
        } else {
            byArray = new byte[]{0, 0, 0, 0};
        }
        return LicenseGenerator.licenseGenerator(string3, byArray, string2.toLowerCase());
    }

    private static String licenseGenerator(String string, byte[] byArray, String string2) {
        int n = string2.equals("rx") ? -251 : -256;
        byte[] byArray2 = string.getBytes(StandardCharsets.US_ASCII);
        ByteBuffer byteBuffer = ByteBuffer.allocate(28);
        byteBuffer.put("iRMC".getBytes(StandardCharsets.US_ASCII));
        byteBuffer.put(byArray);
        byteBuffer.putInt(n);
        byteBuffer.putInt(LicenseGenerator.spdCRC32(byArray2, 1));
        byte[] byArray3 = byteBuffer.array();
        System.out.println(LicenseGenerator.bytesToHex(byArray3));
        try {
            Mac mac = Mac.getInstance("HmacSHA1");
            SecretKeySpec secretKeySpec = new SecretKeySpec(HMAC_KEY, "HmacSHA1");
            mac.init(secretKeySpec);
            byte[] byArray4 = mac.doFinal(HMAC_MSG);
            byte[] byArray5 = Arrays.copyOf(byArray4, 16);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            SecretKeySpec secretKeySpec2 = new SecretKeySpec(byArray5, "AES");
            IvParameterSpec ivParameterSpec = new IvParameterSpec(AES_IV);
            cipher.init(1, (Key)secretKeySpec2, ivParameterSpec);
            byte[] byArray6 = cipher.doFinal(byArray3);
            String string3 = Base64.getEncoder().encodeToString(byArray6);
            String string4 = string3.replaceAll("=", "");
            return LicenseGenerator.formatLicense(string4);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static int spdCRC32(byte[] byArray, int n) {
        int[] nArray = LicenseGenerator.initLookupTable();
        for (byte by : byArray) {
            n = nArray[(by ^ n >>> 24) & 0xFF] ^ n << 8;
            n &= 0xFFFFFFFF;
        }
        return n;
    }

    private static int[] initLookupTable() {
        int[] nArray = new int[256];
        for (int i = 0; i < 256; ++i) {
            int n = i << 24;
            for (int j = 0; j < 8; ++j) {
                n = n >> 31 != 0 ? n << 1 ^ 0x4C11DB7 : (n <<= 1);
                n &= 0xFFFFFFFF;
            }
            nArray[i] = n;
        }
        return nArray;
    }

    private static String formatLicense(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); i += 4) {
            stringBuilder.append(string, i, Math.min(i + 4, string.length()));
            if (i + 4 >= string.length()) continue;
            stringBuilder.append("-");
        }
        return stringBuilder.toString();
    }

    private static String bytesToHex(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            stringBuilder.append(String.format("%02x", by));
        }
        return stringBuilder.toString();
    }
}

