#!/usr/bin/perl
#
# Copyright Hewlett Packard 2012 - 2014
#
# version = 1.20
# This script analyzes configuration related issues for hosts. 
#
 
use strict;
use warnings;

# Read in input values
my $common      = $ARGV[0];		# inex_common object
my $type        = $ARGV[1];		# Type of configuration objects
my $ptr         = $ARGV[2];		# Hash of configuration objects of type $ARGV[1]
my $syssn       = $ARGV[3];		# Serial Number of the system
my $model       = $ARGV[4];		# Model of the system (F200, V400, etc)
my $version     = $ARGV[5];		# Baselevel currently running
my $baselevel   = $ARGV[6];		# Baselevel currently running
my $patches     = $ARGV[7];		# List of installed patches
my $insploredir = $ARGV[8];		# Directory name containing the decompressed Insplore

# Define local variables, global in this program though
my %local_hash  = ();			# Hash to store local stuff
my $lptr	= \%local_hash;
my $save_debug  = $common->{debug}->{level};

# In order to facilitate debugging and see the structure of the hash, uncomment the following 2 lines. 
# $common->{debug}->{level} = TRACE_MEMORY;
# $common->dump_memory($ptr, "cfganal_host: ptr");

# Report issues using the following method:
# $common->report_cfganal_issue($syssn, $type, $hostid, <column>, "Comments go here", <analysis_code>, $cageid, <analysis_code_p1>, <analysis_code_p2>, ..);

$common->trace(TRACE_ROUTINES, "---> cfganal_host $type, $syssn, $model, $version, $baselevel, $patches");

foreach my $hostid (sort keys(%{$ptr})) { 
	# Your tests per host go here.
}

$common->trace(TRACE_ROUTINES, "<--- cfganal_host");
$common->{debug}->{level} = $save_debug;

return 1;
