#!/usr/bin/perl
#
# Copyright Hewlett Packard 2012 - 2014
#
# version = 1.25-1
# This script analyzes configuration related issues for vvs. 
#
 
use strict;
use warnings;
use Data::Dumper;
    $Data::Dumper::Sortkeys = 1;

# Read in input values
my $common      = $ARGV[0];		# inex_common object
my $type        = $ARGV[1];		# Type of configuration objects
my $ptr         = $ARGV[2];		# Hash of configuration objects of type $ARGV[1]
my $syssn       = $ARGV[3];		# Serial Number of the system
my $model       = $ARGV[4];		# Model of the system (F200, V400, etc)
my $version     = $ARGV[5];		# Baselevel currently running
my $baselevel   = $ARGV[6];		# Baselevel currently running
my $patches     = $ARGV[7];		# List of installed patches
my $insploredir = $ARGV[8];		# Directory name containing the decompressed Insplore

# Define local variables, global in this program though
my %local_hash  = ();			# Hash to store local stuff
my $lptr	= \%local_hash;
my $save_debug  = $common->{debug}->{level};

# In order to facilitate debugging and see the structure of the hash, uncomment the following 2 lines. 
# $common->{debug}->{level} = TRACE_MEMORY;
# $common->dump_memory($ptr, "cfganal_vv: ptr");

# Report issues using the following method:
# $common->report_cfganal_issue($syssn, $type, $vvid, <column>, "Comments go here", <analysis_code>, $cageid, <analysis_code_p1>, <analysis_code_p2>, ..);

$common->trace(TRACE_ROUTINES, "---> cfganal_vv $type, $syssn, $model, $version, $baselevel, $patches");

#printf "CFGANAL-VV: %s\n", scalar(keys %$ptr);
#print Dumper($ptr);

my $ddscnt = 0;
%{$lptr->{cpg}} = ();
%{$lptr->{dds}} = ();
%{$lptr->{vv}} = ();
@{$lptr->{toobig}} = ();

foreach my $vvid (sort keys(%{$ptr})) {
    #print Dumper($ptr->{$vvid});
	#
	# Track the VV id's greater than 32768, this presents problems to RC.
	#
	if ($vvid > 32767) { push(@{$lptr->{toobig}}, $vvid);  }
	#
	# So start checking the VV and its reserved snapshot space...
	#
	check_reserved_snapshot_space ($common, $type, $ptr, $syssn, $model, $version, $baselevel, $patches, $vvid, $lptr);
	check_vv_name_length ($common, $type, $ptr, $syssn, $model, $version, $baselevel, $patches, $vvid, $lptr);
	#
	# Next we will collect VV and its CPG data to make sure that it's
	# adhereing to best practices such that the base and snaps are the same device type.
	# If the VV is a snap or dds, we will skip it. If one of CPGs is undefined, we are
	# not using it so skip it too.
	#
	#
	# If provisioning is undefined, then we can skip it since we won't have enough
	# information to make the decisions we need.
	#
	if (!defined($ptr->{$vvid}->{prov}) || $ptr->{$vvid}->{prov} eq '') { next; }
	#
	# We can ignore snaps and dds.
	#
	if ($ptr->{$vvid}->{prov} !~ m/snp|dds/i)
	{
		if ((defined($ptr->{$vvid}->{cpg}->{user}->{id}) && defined($ptr->{$vvid}->{cpg}->{snap}->{id})) &&
			($ptr->{$vvid}->{cpg}->{user}->{id} ne $ptr->{$vvid}->{cpg}->{snap}->{id})) {
			$lptr->{vv}->{$vvid}->{cpg}->{snap} = $ptr->{$vvid}->{cpg}->{snap}->{id};
			$lptr->{vv}->{$vvid}->{cpg}->{user} = $ptr->{$vvid}->{cpg}->{user}->{id};
		}
	}
	#
	#  We are also gathering Dedupe related information with regards to the CPGS that they are
	#  employed under.
	#
	if (!defined($ptr->{$vvid}->{cpg}->{user}->{id}) || $ptr->{$vvid}->{cpg}->{user}->{id} eq '')
	{
	    $lptr->{cpg}->{null}->{$ptr->{$vvid}->{prov}}->{$vvid} = 1;
	}
	else
	{
	    $lptr->{cpg}->{$ptr->{$vvid}->{cpg}->{user}->{id}}->{$ptr->{$vvid}->{prov}}->{$vvid} = 1;
	}
	#
	# get some more dds specific data...
	# 
	if ($ptr->{$vvid}->{prov} eq 'dds')
	{
	    $ddscnt++;
	    #
	    $lptr->{dds}->{$vvid}->{used} = $ptr->{$vvid}->{size}->{user}->{used};
	    $lptr->{dds}->{$vvid}->{rsvd} = $ptr->{$vvid}->{size}->{user}->{rsvd};
	    $lptr->{dds}->{$vvid}->{util} = 0;
	    if ($ptr->{$vvid}->{size}->{user}->{rsvd}){$lptr->{dds}->{$vvid}->{util} = (($ptr->{$vvid}->{size}->{user}->{used}/$ptr->{$vvid}->{size}->{user}->{rsvd})*100);}
	    #
	}
}
#
#
#
if (scalar(@{$lptr->{toobig}}) > 0)
{
    foreach my $tbvvid (@{$lptr->{toobig}})
    {
	#printf STDERR "TOO BIG VV ID: $tbvvid\n%s\n", Dumper($ptr->{$tbvvid});
	$common->report_cfganal_issue($syssn, $type, $tbvvid, 1, "VV ID greater than 32678, this will prevent this VVs admission\nto an RC group in an OS version less than v3.1.3.", 67, $ptr->{$tbvvid}->{id}, $ptr->{$tbvvid}->{name});
    }
}

#
# Need to check minimum dedup OS version.
# This has changed from 3.2.1.MU2;P11 to 3.2.1.EMU3
#
if ($ddscnt)
{
    if (($version lt "321") ||  # BOY this should never be, but one never knows...
	($version eq "321" && $baselevel lt "292") ||
	($version eq "321" && $baselevel eq "292" && index($patches, "P17") < 0) ) 
    {
	foreach my $ddsid (sort keys %{$lptr->{dds}})
	{
	    $common->report_cfganal_issue($syssn, $type, $ddsid, 10, "Use of \"V3.2.1.EMU3\" is mandated as the minimum version for supporting De-Deuplication, See CFI 6251", 39, $ddsid, $ptr->{$ddsid}->{name}, "V3.2.1.EMU3", "6251");
	}
    }
}


#
# Checking the number of Dedupe related CPGs based on the fact there is a DDS
# per CPG.
#
my $nodecnts = scalar(keys %{$common->{config}->{$syssn}->{nodes}});
if (($nodecnts % 2) != 0 ){$nodecnts++;}
if ($ddscnt > ($nodecnts/2))
{
    $common->report ($syssn, 42, $ddscnt, ($nodecnts/2), $nodecnts); 
}
#print Dumper($lptr);
foreach my $cpgid (sort keys %{$lptr->{cpg}})
{
    if (!exists($lptr->{cpg}->{$cpgid}->{tdvv})){next;}
    #
    # If the VV/DDS has no CPG associated with it, we need to skip it.
    # This is mostly the result of using just data from a config file, not an InSplore.
    #
    if ($cpgid eq 'null'){next;}
    #
    # Okay we have dedupe VV in this cpg, now do we have anything else?
    #
    foreach my $vvtype (sort keys %{$lptr->{cpg}->{$cpgid}})
    {
	if ($vvtype eq 'dds' || $vvtype eq 'tdvv'){next;}
	#
	$common->report_cfganal_issue($syssn, 'cpg', $cpgid, 2, "CPGs should NOT support both dedupe VVs and NON-dedupe VVs!", 43, $common->{config}->{$syssn}->{cpg}->{$cpgid}->{name});
	last;
    }
    #
    # Also check the number of TDVVs in the CPG.
    # We are not to exceed 256 TDVVs/CPG!
    #
    if (scalar(keys %{$lptr->{cpg}->{$cpgid}->{tdvv}}) > 256)
    {
	$common->report_cfganal_issue($syssn, 'cpg', $cpgid, 2, "CPGs should NOT contain more than 256 TDVVs per CPG!", 46, $common->{config}->{$syssn}->{cpg}->{$cpgid}->{name});
    }
    
}
#
#print Dumper($lptr->{dds});
#
# The section is going to conduct a dual check.
# 
#  1. If we have any DDS that is 70% utilized AND the overall SSD space is 80% utilized
#  we will flag this as an issue that requires attention.
#
#  2. If we have any DDS VVs and our overall SSD space utilization is at least 70%
#  we want to flag this as something to monitor.
#  
if (scalar(keys %{$lptr->{dds}}) > 0)
{
    #
    # So let's start with calculating the over all SSD space consumed
    #
    my $ssdcnt = 0;
    my $ssdtotal = 0;
    my $ssdfree = 0;
    
    foreach my $pdid (sort keys %{$common->{config}->{$syssn}->{pd}})
    {
	if (!defined($common->{config}->{$syssn}->{pd}->{$pdid}->{type}) || $common->{config}->{$syssn}->{pd}->{$pdid}->{type} eq '')
	{
	    #print "CFGANAL-VV: PD: $pdid has an uninitialized type value\n";
	    #print Dumper ($common->{config}->{$syssn}->{pd}->{$pdid});
	    next;
	}
	if (uc ($common->{config}->{$syssn}->{pd}->{$pdid}->{type}) ne 'SSD'){next;}
	$ssdcnt++;
	$ssdtotal += $common->{config}->{$syssn}->{pd}->{$pdid}->{capacity}->{raw};
	$ssdfree  += $common->{config}->{$syssn}->{pd}->{$pdid}->{capacity}->{free};
    }
#    printf "SSD: SSDs: %s Total: %s  free: %s  used: %s util: %s\n",
#	$ssdcnt, $ssdtotal/1024, $ssdfree/1024, ($ssdtotal-$ssdfree)/1024, (($ssdfree/$ssdtotal)*100);
    #
    # Since we are already into this section of code, this means we have a DDS present ob the
    # array indicating DeDupe is in use. So, here we can make our check for #2.
    # 
    #
    my $ssdutilization = 100.0 - (($ssdfree/$ssdtotal)*100);
    #
    if ($ssdutilization >= 70.0)
    {
	my $sevlevel = 'MINOR';
	if ($ssdutilization >= 80.0){$sevlevel = 'MAJOR';}
	if ($ssdutilization >= 90.0){$sevlevel = 'CRITICAL';}
	#
	$common->report ($syssn, 45, $ssdcnt, sprintf("% .2f%%", $ssdutilization), $sevlevel);
	#
	if ($ssdutilization >= 80.0)
	{
	    foreach my $vvid (sort keys %{$lptr->{dds}})
	    {
		if ($lptr->{dds}->{$vvid}->{util} < 70.0){next;}
		#
		$common->report ($syssn, 44, sprintf("% .2f%%", $ssdutilization),
				 $ptr->{$vvid}->{name},
				 $vvid,
				 sprintf("% .2f%%", (100.0 - $lptr->{dds}->{$vvid}->{util})));
	    }
	}
    }
}

#
#
#
my %basematches = ( 'NL'   => 'FC|SSD',
		    'FC'   => 'SSD',
		    'SSD'  => 'SSD',
		);
my $mstring = '';
my $cpgmismatch = 0;
foreach my $vvid (sort keys %{$lptr->{vv}})
{
	#
	# Now if the device types are the same, we can skip those...
	#
	if ($common->{config}->{$syssn}->{cpg}->{$lptr->{vv}->{$vvid}->{cpg}->{user}}->{devtype} eq 
		$common->{config}->{$syssn}->{cpg}->{$lptr->{vv}->{$vvid}->{cpg}->{snap}}->{devtype}) {next;}
	#
	# Now check and see if the device type of the snap is faster than the base,
	# if so.. call it out just as an information to point out thatthe snap device is smaller than the base device.
	#
	$mstring = $basematches{$common->{config}->{$syssn}->{cpg}->{$lptr->{vv}->{$vvid}->{cpg}->{user}}->{devtype}};
	if ($common->{config}->{$syssn}->{cpg}->{$lptr->{vv}->{$vvid}->{cpg}->{snap}}->{devtype} =~ m/$mstring/i)
	{
		#printf "FASTER CPGS: VV $vvid (%s)  USR: %s (%s) SNAP: %s (%s)\n",
		#$ptr->{$vvid}->{prov},
		#$common->{config}->{$syssn}->{cpg}->{$lptr->{vv}->{$vvid}->{cpg}->{user}}->{name},
		#$common->{config}->{$syssn}->{cpg}->{$lptr->{vv}->{$vvid}->{cpg}->{user}}->{devtype},
		#$common->{config}->{$syssn}->{cpg}->{$lptr->{vv}->{$vvid}->{cpg}->{snap}}->{name},
		#$common->{config}->{$syssn}->{cpg}->{$lptr->{vv}->{$vvid}->{cpg}->{snap}}->{devtype};
		#
		$common->report_cfganal_issue($syssn, $type, $vvid, 21, "Snap CPG is using a *SMALLER* and faster device than the Base CPG device",
									  51, $vvid, $ptr->{$vvid}->{name},
									  $common->{config}->{$syssn}->{cpg}->{$lptr->{vv}->{$vvid}->{cpg}->{snap}}->{name},
									  $common->{config}->{$syssn}->{cpg}->{$lptr->{vv}->{$vvid}->{cpg}->{snap}}->{devtype},
									  $common->{config}->{$syssn}->{cpg}->{$lptr->{vv}->{$vvid}->{cpg}->{user}}->{name},
									  $common->{config}->{$syssn}->{cpg}->{$lptr->{vv}->{$vvid}->{cpg}->{user}}->{devtype});
	}
	else
	{
		#
		# So here we are with mis-matched device types for the snap and base.
		# We really are concerned with the snap being on a slower device type
		# compared to the base.
		# 
		#$cpgmismatch++;
		#printf "MISMATCH CPGS: VV $vvid (%s)  USR: %s (%s) SNAP: %s (%s)\n",
		#$ptr->{$vvid}->{prov},
		#$common->{config}->{$syssn}->{cpg}->{$lptr->{vv}->{$vvid}->{cpg}->{user}}->{name},
		#$common->{config}->{$syssn}->{cpg}->{$lptr->{vv}->{$vvid}->{cpg}->{user}}->{devtype},
		#$common->{config}->{$syssn}->{cpg}->{$lptr->{vv}->{$vvid}->{cpg}->{snap}}->{name},
		#$common->{config}->{$syssn}->{cpg}->{$lptr->{vv}->{$vvid}->{cpg}->{snap}}->{devtype};
		#
		$common->report_cfganal_issue($syssn, $type, $vvid, 21, "Snap CPG is using a slower device than the Base CPG device, Best Practice violation",
									  50, $vvid, $ptr->{$vvid}->{name},
									  $common->{config}->{$syssn}->{cpg}->{$lptr->{vv}->{$vvid}->{cpg}->{snap}}->{name},
									  $common->{config}->{$syssn}->{cpg}->{$lptr->{vv}->{$vvid}->{cpg}->{snap}}->{devtype},
									  $common->{config}->{$syssn}->{cpg}->{$lptr->{vv}->{$vvid}->{cpg}->{user}}->{name},
									  $common->{config}->{$syssn}->{cpg}->{$lptr->{vv}->{$vvid}->{cpg}->{user}}->{devtype});
	}
}
#
#printf "MISMATCH CPGS: $cpgmismatch\n";
#
$common->trace(TRACE_ROUTINES, "<--- cfganal_vv");
$common->{debug}->{level} = $save_debug;
#print Dumper($common->{config}->{$syssn}->{cpg});

return 1;

sub check_reserved_snapshot_space {
        my ($common, $type, $ptr, $syssn, $model, $version, $baselevel, $patches, $vvid, $lptr) = @_;

	if (exists($ptr->{$vvid}->{tree})) {
	    if (exists($ptr->{$vvid}->{tree}->{child})) {
	        if (exists($ptr->{$vvid}->{tree}->{child}->{ro})) { if ($ptr->{$vvid}->{tree}->{child}->{ro} ne "-") { return; } }	# return if there is a child snapshot 
	        if (exists($ptr->{$vvid}->{tree}->{child}->{rw})) { if ($ptr->{$vvid}->{tree}->{child}->{rw} ne "-") { return; } }	# return if there is a child snapshot
		my ($rsvd_snap, $rsvd_user);
		$rsvd_snap = $ptr->{$vvid}->{size}->{snap}->{rsvd};
		if ($rsvd_snap !~ /^\d+/) { return; }
		$rsvd_user = $ptr->{$vvid}->{size}->{user}->{rsvd};
		if ($rsvd_user !~ /^\d+/) { return; }
		if ($rsvd_snap > 1024) {
	           $common->report_cfganal_issue($syssn, $type, $vvid, 52, "Reserved snapshot space too high, see CFI 5489", 38, $ptr->{$vvid}->{name}, $rsvd_snap, "5489");
		} 
	    }
	}
        return;
}

return 1;

sub check_vv_name_length {
    my ($common, $type, $ptr, $syssn, $model, $version, $baselevel, $patches, $vvid, $lptr) = @_;
    #printf "CFGANAL_VV:VV %s | %s [%s] \n", $vvid, $ptr->{$vvid}->{name}, length($ptr->{$vvid}->{name});
    if (length($ptr->{$vvid}->{name}) > 31) {
	#printf "CFGANAL_VV:VV %s | %s [%s] names exceeds 32 characters!\n", $vvid, $ptr->{$vvid}->{name}, length($ptr->{$vvid}->{name});
	$common->report_cfganal_issue($syssn, $type, $vvid, 2, "VV Name exceeds 31 characters, see CFI_6881", 52, $ptr->{$vvid}->{name}, $vvid, "6881");
    }
    return;
}
