#!/usr/bin/perl
#
# (C) Copyright 2012-2015 Hewlett Packard Enterprise Development LP
#
# version = 1.23
# This script analyzes configuration related issues for a cluster. 
#
 
$| = 1;
use strict;
use warnings;
use Data::Dumper;
use File::Find::Rule;

# Read in input values
my $common      = $ARGV[0];		# inex_common object
my $type        = $ARGV[1];		# Type of configuration objects
my $ptr         = $ARGV[2];		# Hash of configuration objects of type $ARGV[1]
my $syssn       = $ARGV[3];		# Serial Number of the system
my $model       = $ARGV[4];		# Model of the system (F200, V400, etc)
my $version     = $ARGV[5];		# Baselevel currently running
my $baselevel   = $ARGV[6];		# Baselevel currently running
my $patches     = $ARGV[7];		# List of installed patches
my $insploredir = $ARGV[8];		# Directory name containing the decompressed Insplore

# Define local variables, global in this program though
my %local_hash  = ();			# Hash to store local stuff
my $lptr	= \%local_hash;
my $save_debug  = $common->{debug}->{level};

# In order to facilitate debugging and see the structure of the hash, uncomment the following 2 lines. 
# $common->{debug}->{level} = TRACE_MEMORY;
# $common->dump_memory($ptr, "cfganal_cluster: ptr");

# Report issues using the following method:
# $common->report_cfganal_issue($syssn, $type, $clusterid, <column>, "Comments go here", <analysis_code>, $cageid, <analysis_code_p1>, <analysis_code_p2>, ..);

$common->trace(TRACE_ROUTINES, "---> cfganal_cluster $type, $syssn, $model, $version, $baselevel, $patches");

#
# Version check, if 3.2.2.MU1, then P16 MUST be installed. P16 is MANDATORY.
#
if ($version eq "322" && $baselevel eq "326" && (index($patches, "P16") < 0) ) 
{
    #$common->report_cfganal_issue($syssn, $type, $ddsid, 10, "Use of \"V3.2.1.EMU3\" is mandated as the minimum version for supporting De-Deuplication, suggest P18 too, See CFI 6251", 39, $ddsid, $ptr->{$ddsid}->{name}, "V3.2.1.EMU3[+P18 suggested]", "6251");
    $common->report($syssn, 900, $syssn);
}

#
# Go and analyze the necessary data to generate a System Up-Down Repoprt.
#
$common->{dothejob_obj}->analyze_updown ($common, $insploredir, $syssn);

$common->trace(TRACE_ROUTINES, "<--- cfganal_cluster");
$common->{debug}->{level} = $save_debug;

return 1;
