#!/usr/bin/perl
#
# (C) Copyright 2012-2015 Hewlett Packard Enterprise Development LP
#
# version = 1.20
# This script analyzes configuration related issues only visible in events 
#
 
use strict;
use warnings;

my %pd_models = (
   "HMRSK2000GBAS07K"	=> \&analyze_events_MarsK_PDs,
   "HMRSK3000GBAS07K"   => \&analyze_events_MarsK_PDs,
   "HCBRE0450GBAS10K"	=> \&analyze_events_CobraE_PDs,
   "HCBRE0600GBAS10K"	=> \&analyze_events_CobraE_PDs,
   "HCBRE0900GBAS10K"	=> \&analyze_events_CobraE_PDs,
   #
   "DOPE0480S5xnNMRI"   => \&analyze_events_Optimus_PDs,
   "DOPE1920S5xnNMRI"   => \&analyze_events_Optimus_PDs,
   #
   "DOPA0480S5xnNMRI"   => \&analyze_events_Optimus_PDs,
   "DOPA0920S5xnNMRI"   => \&analyze_events_Optimus_PDs,
);

# Read in input values
my $common      = $ARGV[0];		# inex_common object
my $type        = $ARGV[1];		# Type of configuration objects
my $ptr         = $ARGV[2];		# Hash of configuration objects of type $ARGV[1]
my $syssn       = $ARGV[3];		# Serial Number of the system
my $model       = $ARGV[4];		# Model of the system (F200, V400, etc)
my $version     = $ARGV[5];		# Baselevel currently running
my $baselevel   = $ARGV[6];		# Baselevel currently running
my $patches     = $ARGV[7];		# List of installed patches
my $insploredir = $ARGV[8];		# Directory name containing the decompressed Insplore

# Define local variables, global in this program though
my %local_hash  = ();			# Hash to store local stuff
my $lptr	= \%local_hash;
my $save_debug  = $common->{debug}->{level};
my $pdid        = undef;

# In order to facilitate debugging and see the structure of the hash, uncomment the following 2 lines. 
# $common->{debug}->{level} = TRACE_MEMORY;
# $common->dump_memory($common, cfganal_events: common");

# Report issues using the following method:
# $common->report_cfganal_issue($syssn, "pd|ld|vv|..}, <objectid>, <column>, "Comments go here", <analysis_code>, $cageid, <analysis_code_p1>, <analysis_code_p2>, ..);

$common->trace(TRACE_ROUTINES, "---> cfganal_events $type, $syssn, $model, $version, $baselevel, $patches");

%{$lptr->{models}} = ();		# Init the local PD Model hash

foreach $pdid (sort keys(%{$common->{config}->{$syssn}->{pd}})) {
        if (exists($common->{config}->{$syssn}->{pd}->{$pdid}->{vendor}) &&
	    exists($common->{config}->{$syssn}->{pd}->{$pdid}->{vendor}->{model}) &&
	    exists($pd_models{$common->{config}->{$syssn}->{pd}->{$pdid}->{vendor}->{model}})) { 
	    $pd_models{$common->{config}->{$syssn}->{pd}->{$pdid}->{vendor}->{model}}($common, $type, $ptr, $syssn, $model, $version, $baselevel, $patches, $pdid, $common->{config}->{$syssn}->{pd}->{$pdid}->{vendor}->{model}, $lptr); 
	}	
}

$common->trace(TRACE_ROUTINES, "<--- cfganal_events");
$common->{debug}->{level} = $save_debug;

return 1;

sub analyze_events_Optimus_PDs {
        my ($common, $type, $ptr, $syssn, $model, $version, $baselevel, $patches, $pdid, $pdtype, $lptr) = @_;
	
	# See if the drive logged a ASC/ASCQ/Sk 0x31/0x0/0x03
	if (exists($common->{analysis}->{$syssn}->{pd})) {
	    if (exists($common->{analysis}->{$syssn}->{pd}->{ascascqsk})) {
		if (exists($common->{analysis}->{$syssn}->{pd}->{ascascqsk}->{$pdid})) {
		    if (exists($common->{analysis}->{$syssn}->{pd}->{ascascqsk}->{$pdid}->{'0x31'})) {
		        if (exists($common->{analysis}->{$syssn}->{pd}->{ascascqsk}->{$pdid}->{'0x31'}->{'0x0'})) {
		            if (exists($common->{analysis}->{$syssn}->{pd}->{ascascqsk}->{$pdid}->{'0x31'}->{'0x0'}->{'0x03'})) {
				#$common->report_cfganal_issue($syssn, "pd", $pdid, 21, "Not completely formatted, see CFI 4613", 24, $common->{config}->{$syssn}->{pd}->{$pdid}->{id}, "4613");
				$common->report_cfganal_issue($syssn, "pd", $pdid, 1, "Drive needs to be reformated, see CFI 5872 for critical information regarding reformat.", 65,
							      $common->{config}->{$syssn}->{pd}->{$pdid}->{id},
							      $common->{config}->{$syssn}->{pd}->{$pdid}->{vendor}->{model},
							      $common->{config}->{$syssn}->{pd}->{$pdid}->{fw});
                            }
		        }
                    }
		}
	    }
	}

	return;
}


sub analyze_events_MarsK_PDs {
        my ($common, $type, $ptr, $syssn, $model, $version, $baselevel, $patches, $pdid, $pdtype, $lptr) = @_;
	
	# See if the drive logged a ASC/ASCQ/Sk 0x44/0x0/0xb
	if (exists($common->{analysis}->{$syssn}->{pd})) {
	    if (exists($common->{analysis}->{$syssn}->{pd}->{ascascqsk})) {
		if (exists($common->{analysis}->{$syssn}->{pd}->{ascascqsk}->{$pdid})) {
		    if (exists($common->{analysis}->{$syssn}->{pd}->{ascascqsk}->{$pdid}->{'0x44'})) {
		        if (exists($common->{analysis}->{$syssn}->{pd}->{ascascqsk}->{$pdid}->{'0x44'}->{'0x0'})) {
		            if (exists($common->{analysis}->{$syssn}->{pd}->{ascascqsk}->{$pdid}->{'0x44'}->{'0x0'}->{'0x0b'})) {
		                $common->report_cfganal_issue($syssn, "pd", $pdid, 21, "Not completely formatted, see CFI 4613", 24, $common->{config}->{$syssn}->{pd}->{$pdid}->{id}, "4613");
                            }
		        }
                    }
		}
	    }
	}

	return;
}

sub analyze_events_CobraE_PDs {
        my ($common, $type, $ptr, $syssn, $model, $version, $baselevel, $patches, $pdid, $pdtype, $lptr) = @_;
	
	my $reported = undef;
	# See if the drive logged any disk events
	if (exists($common->{analysis}->{$syssn}->{pd})) {
	    if (exists($common->{analysis}->{$syssn}->{pd}->{ascascqsk})) {
		if (exists($common->{analysis}->{$syssn}->{pd}->{ascascqsk}->{$pdid})) {
	            # See if the drive logged a ASC/ASCQ/Sk 0x44/0x0/0xb  Internal Target Error
		    if (exists($common->{analysis}->{$syssn}->{pd}->{ascascqsk}->{$pdid}->{'0x44'})) {
		        if (exists($common->{analysis}->{$syssn}->{pd}->{ascascqsk}->{$pdid}->{'0x44'}->{'0x0'})) {
		            if (exists($common->{analysis}->{$syssn}->{pd}->{ascascqsk}->{$pdid}->{'0x44'}->{'0x0'}->{'0x0b'})) {
		                $common->report_cfganal_issue($syssn, "pd", $pdid, 21, "Head degradation, see CFI 4537", 24, $common->{config}->{$syssn}->{pd}->{$pdid}->{id}, "4537");
		                $reported = 1;
                            }
		        }
                    }
                    unless ($reported) {
	                # See if the drive logged a ASC/ASCQ/Sk 0x1D/0x0/0xE  Miscompare during verify operation
		        if (exists($common->{analysis}->{$syssn}->{pd}->{ascascqsk}->{$pdid}->{'0x1d'})) {
		            if (exists($common->{analysis}->{$syssn}->{pd}->{ascascqsk}->{$pdid}->{'0x1d'}->{'0x0'})) {
		                if (exists($common->{analysis}->{$syssn}->{pd}->{ascascqsk}->{$pdid}->{'0x1d'}->{'0x0'}->{'0x0e'})) {
		                    $common->report_cfganal_issue($syssn, "pd", $pdid, 21, "Head degradation, see CFI 4537", 24, $common->{config}->{$syssn}->{pd}->{$pdid}->{id}, "4537");
		                    $reported = 1;
                                }
		            }
                        }
                    }
		}
	    }
	}

	return;
}