#!/usr/bin/perl
#
# (C) Copyright 2012-2015 Hewlett Packard Enterprise Development LP
#
# version = 1.26
# This script analyzes configuration related issues for lds. 
#
 
use strict;
use warnings;
use Data::Dumper;
    $Data::Dumper::Sortkeys = 1;

# Read in input values
my $common      = $ARGV[0];		# inex_common object
my $type        = $ARGV[1];		# Type of configuration objects
my $ptr         = $ARGV[2];		# Hash of configuration objects of type $ARGV[1]
my $syssn       = $ARGV[3];		# Serial Number of the system
my $model       = $ARGV[4];		# Model of the system (F200, V400, etc)
my $version     = $ARGV[5];		# Baselevel currently running
my $baselevel   = $ARGV[6];		# Baselevel currently running
my $patches     = $ARGV[7];		# List of installed patches
my $insploredir = $ARGV[8];		# Directory name containing the decompressed Insplore

# Define local variables, global in this program though
my %local_hash  = ();			# Hash to store local stuff
my $lptr	= \%local_hash;
my $save_debug  = $common->{debug}->{level};

# In order to facilitate debugging and see the structure of the hash, uncomment the following 2 lines. 
# $common->{debug}->{level} = TRACE_MEMORY;
# $common->dump_memory($ptr, "cfganal_ld: ptr");

# Report issues using the following method:
# $common->report_cfganal_issue($syssn, $type, $ldid, <column>, "Comments go here", <analysis_code>, $cageid, <analysis_code_p1>, <analysis_code_p2>, ..);

$common->trace(TRACE_ROUTINES, "---> cfganal_ld $type, $syssn, $model, $version, $baselevel, $patches");

foreach my $ldid (sort keys(%{$ptr})) {
    #
    # Your tests per ld go here....
    #
    ##
    ## 1. Test for LDs with RAID of 0. Skip those that are media-fail* and checkpdfix_ld*
    ##
    ## If not RAID 0, skip it...
    #if ($common->{config}->{$syssn}->{$type}->{$ldid}->{raid} != 0) {next;}
    ##
    ## Now check the name. If it is not a media-fail or a checkpdfix_ld, skip it...
    ## 
    #if ($common->{config}->{$syssn}->{$type}->{$ldid}->{name} =~ m/^media-fail|checkpdfix_ld|fcacheld/i) {next;}
    ##
    #$common->report_cfganal_issue($syssn, $type, $ldid, 10, "RAID 0 employed with user data! RAID 0 does *NOT* provide any data redundancy/protection!", 56, $common->{config}->{$syssn}->{$type}->{$ldid}->{name}, sprintf ("%d", $ldid));
    #
    # Check for R0...
    #
    &ld_check_r0 ($ptr, $type, $syssn, $model, $version, $baselevel, $patches, $ldid);
    #
    # Check SA lds for use on NL type drives...
    #
    &ld_check_sa_nl  ($ptr, $type, $syssn, $model, $version, $baselevel, $patches, $ldid);
    #
}

$common->trace(TRACE_ROUTINES, "<--- cfganal_ld");
$common->{debug}->{level} = $save_debug;

return 1;

sub ld_check_r0
{
    my ($ptr, $type, $syssn, $model, $version, $baselevel, $patches, $ldid) = @_;
    #
    #
    # If not RAID 0, skip it...
    #
    if ($common->{config}->{$syssn}->{$type}->{$ldid}->{raid} != 0) {return 1;}
    #
    # Now check the name. If it is a media-fail, checkpdfix_ld or fcacheld skip it...
    # 
    if ($common->{config}->{$syssn}->{$type}->{$ldid}->{name} =~ m/^media-fail|checkpdfix_ld|fcacheld/i) {return 1;}
    #
    $common->report_cfganal_issue($syssn, $type, $ldid, 10, "RAID 0 employed with user data! RAID 0 does *NOT* provide any data redundancy/protection!", 56, $common->{config}->{$syssn}->{$type}->{$ldid}->{name}, sprintf ("%d", $ldid));
    #
    return 1;
}

sub ld_check_sa_nl
{
    my ($ptr, $type, $syssn, $model, $version, $baselevel, $patches, $ldid) = @_;
    #
    #
    # If not an SA LD, skip it...
    #
    if ($common->{config}->{$syssn}->{$type}->{$ldid}->{name} !~ m/-sa-/) {return 1;}
    #
    # Now check and see if it is on an NL drive or not, if not we are done...
    # 
    if ($common->{config}->{$syssn}->{$type}->{$ldid}->{device}->{type} ne 'NL') {return 1;}
    #
    $common->report_cfganal_issue($syssn, $type, $ldid, 8, "SA type LDs should not use NL type drives. Better performance achieved using FC.", 70, $common->{config}->{$syssn}->{$type}->{$ldid}->{name}, sprintf ("%d", $ldid));
    #
    return 1;
}
