#!/usr/bin/perl
#
# (C) Copyright 2012-2015 Hewlett Packard Enterprise Development LP
#
# version = 1.26-7
# This script analyzes configuration related issues for memory.
#
 
use strict;
use warnings;
use Data::Dumper;
    $Data::Dumper::Sortkeys = 1;
#use enum qw(ANALYSIS_OK=1 ANALYSIS_UNDETERMINED ANALYSIS_WARNING ANALYSIS_ERROR ANALYSIS_CRITICAL);

# Read in input values
my $common      = $ARGV[0];		# inex_common object
my $type        = $ARGV[1];		# Type of configuration objects
my $ptr         = $ARGV[2];		# Hash of configuration objects of type $ARGV[1]
my $syssn       = $ARGV[3];		# Serial Number of the system
my $model       = $ARGV[4];		# Model of the system (F200, V400, etc)
my $version     = $ARGV[5];		# Baselevel currently running
my $baselevel   = $ARGV[6];		# Baselevel currently running
my $patches     = $ARGV[7];		# List of installed patches
my $insploredir = $ARGV[8];		# Directory name containing the decompressed Insplore

# Define local variables, global in this program though
my %local_hash  = ();			# Hash to store local stuff
my $lptr	= \%local_hash;
my $save_debug  = $common->{debug}->{level};
my $nodeid	= undef;



# In order to facilitate debugging and see the structure of the hash, uncomment the following 2 lines. 
 $common->{debug}->{level} = TRACE_MEMORY;
# $common->dump_memory($ptr, "cfganal_memory: ptr");

# Report issues using the following method:
# $common->report_cfganal_issue($syssn, $type, $nodeid, "<comma seperated list of keys>, "Comments go here", <analysis_code>, $nodeid, <analysis_code_p1>, <analysis_code_p2>, ..);

$common->trace(TRACE_ROUTINES, "---> cfganal_memory $type, $syssn, $model, $version, $baselevel, $patches");

#
# Start here with checking the node memory- I.E. - slab, swap...
#
check_node_memory ($common, $type, $ptr, $syssn, $model, $version, $baselevel, $patches, $insploredir, $lptr, ' ');

$common->trace(TRACE_ROUTINES, "<--- cfganal_memory");
$common->{debug}->{level} = $save_debug;

return 1;

sub check_node_memory {
    my ($common, $type, $ptr, $syssn, $model, $version, $baselevel, $patches, $insploredir, $lptr, $nodeid) = @_;
    #
	$common->trace(TRACE_ROUTINES, "---> cfganal_memory::check_node_memory");

    my ($epoch, $msec, $node, $slabvalue, $memvalue, $nodenr, $slabadjustment, $slabminor, $slabmajor, $swapvalue);
	#
	#
	#
    #printf STDERR "MEMORY ADJUSTMENT::\n%s\n", Dumper($common->{config}->{$syssn}->{nodes});
	my %adjustments = ();
    foreach $node (sort keys %{$common->{config}->{$syssn}->{nodes}})
	{
        #
        # Now check for the flash cache slab data... if it exists add it to the slab adjustment...
        # 
	    if (!exists($common->{config}->{$syssn}->{nodes}->{$node}->{memory}) ||
		    !exists($common->{config}->{$syssn}->{nodes}->{$node}->{memory}->{slab}) ||
		    !exists($common->{config}->{$syssn}->{nodes}->{$node}->{memory}->{slab}->{tpd_fmp_req}) )
	    {
            $adjustments{slab}{$node} = 0.0;
        } else {
            $adjustments{slab}{$node} = ($common->{config}->{$syssn}->{nodes}->{$node}->{memory}->{slab}->{tpd_fmp_req}->{objsize} * $common->{config}->{$syssn}->{nodes}->{$node}->{memory}->{slab}->{tpd_fmp_req}->{active_objs})/(1024*1024*1024);
	    }
        #
        # Check for any huge pages values for adjusting overall memory total...
        #
        if (!exists($common->{config}->{$syssn}->{nodes}->{$node}->{memory}) ||
            !exists($common->{config}->{$syssn}->{nodes}->{$node}->{memory}->{meminfo}) ||
            !exists($common->{config}->{$syssn}->{nodes}->{$node}->{memory}->{meminfo}->{hugepagesize}) )
        {
            $adjustments{memtot}{$node} = 0.0;
        } else {
            $adjustments{memtot}{$node} =  ($common->{config}->{$syssn}->{nodes}->{$node}->{memory}->{meminfo}->{hugepages_total}->{value} * $common->{config}->{$syssn}->{nodes}->{$node}->{memory}->{meminfo}->{hugepagesize}->{value});#/(1024*1024);
        }
	}
			        
    %{$lptr->{Slab}} = ();
    %{$lptr->{Swap}} = ();
	#
	#$common->{analysis}->{$syssn}->{memory}->{$epoch}->{$msec}->{values}->{$key}->{node}->{$common->{analysis}->{$syssn}->{memory}->{$epoch}->{$msec}->{node}} = $value;
	#
    foreach $epoch (keys(%{$common->{analysis}->{$syssn}->{memory}})) {
        foreach $msec (keys(%{$common->{analysis}->{$syssn}->{memory}->{$epoch}})) {
            foreach $nodenr (keys(%{$common->{analysis}->{$syssn}->{memory}->{$epoch}->{$msec}})) {
                #
                $memvalue  = $common->{analysis}->{$syssn}->{memory}->{$epoch}->{$msec}->{$nodenr}->{values}->{MemTotal};#/(1024*1024);       
                #
                # V1.26... new logic for slabs to adjust for the flash cache slab...
                # The Slab value from the events is in KB units, the slab value from the
                # slabinfo file is in bytes and needs to be converted.
                # Everything for slab needs to be converted to GB in the end.
                #
                if (!exists($common->{analysis}->{$syssn}->{memory}->{$epoch}->{$msec}->{$nodenr}) ||
                    !exists($common->{analysis}->{$syssn}->{memory}->{$epoch}->{$msec}->{$nodenr}->{values}) ||
                    !exists($common->{analysis}->{$syssn}->{memory}->{$epoch}->{$msec}->{$nodenr}->{values}->{Slab}) ||
                    !defined($common->{analysis}->{$syssn}->{memory}->{$epoch}->{$msec}->{$nodenr}->{values}->{Slab}) ||
                    $common->{analysis}->{$syssn}->{memory}->{$epoch}->{$msec}->{$nodenr}->{values}->{Slab} eq '' ||
                    $common->{analysis}->{$syssn}->{memory}->{$epoch}->{$msec}->{$nodenr}->{values}->{Slab} <= 0 )
                {
                    $slabvalue = "0.0";
                } else
                {
                    $slabvalue = $common->{analysis}->{$syssn}->{memory}->{$epoch}->{$msec}->{$nodenr}->{values}->{Slab}/(1024*1024);
                }
                #
                $node = $common->{parse_config_node_obj}->generate_id ($nodenr);
                #
                # SLAB...
                # 
                #printf "CFGANAL_MEMORY::CHECK_NODE_MEMORY: NODE: %s [%s]  SLAB Adjustment: %s PRE-Slab %s ", $node, $nodenr,  $adjustments{slab}{$node}, $slabvalue;
                #
                $common->{analysis}->{$syssn}->{memory}->{$epoch}->{$msec}->{$nodenr}->{adjustments}->{Slab}->{adjustment} = $adjustments{slab}{$node};
                $slabvalue -= $adjustments{slab}{$node};
                $common->{analysis}->{$syssn}->{memory}->{$epoch}->{$msec}->{$nodenr}->{adjustments}->{Slab}->{newvalue} = $slabvalue;
                #
                #printf "POST-Slab %s\n", $slabvalue;
                #
                # MEMTOTAL...
                # We have to take into account the memory reserved by UNITY which is going to shrink the memory
                # total for TPD/OS, so we adjust accrdingly for our memory checks!
                #
                #printf "CFGANAL_MEMORY::CHECK_NODE_MEMORY: NODE: %s [%s]  origmem: %s adjustment: %s newmem: %s\n", $node, $nodenr,  $memvalue, $adjustments{memtot}{$node}, ($memvalue-$adjustments{memtot}{$node});
                #
                $common->{analysis}->{$syssn}->{memory}->{$epoch}->{$msec}->{$nodenr}->{adjustments}->{memtot}->{origvalue} = $memvalue;
                $common->{analysis}->{$syssn}->{memory}->{$epoch}->{$msec}->{$nodenr}->{adjustments}->{memory}->{adjustment} = $adjustments{memtot}{$node};
                $memvalue -= $adjustments{memtot}{$node};
                $common->{analysis}->{$syssn}->{memory}->{$epoch}->{$msec}->{$nodenr}->{adjustments}->{memory}->{newvalue} = $memvalue;
                #
                #Now convert to GB from KB..
                #
                $memvalue = $memvalue/(1024 * 1024);
                #
                #
                #
                if (!exists($common->{analysis}->{$syssn}->{memory}->{$epoch}->{$msec}->{$nodenr}->{values}) ||
                    !exists($common->{analysis}->{$syssn}->{memory}->{$epoch}->{$msec}->{$nodenr}->{values}->{SwapTotal}) ||
                    !defined($common->{analysis}->{$syssn}->{memory}->{$epoch}->{$msec}->{$nodenr}->{values}->{SwapTotal}) ||
                    $common->{analysis}->{$syssn}->{memory}->{$epoch}->{$msec}->{$nodenr}->{values}->{SwapTotal} eq '' ||
                    $common->{analysis}->{$syssn}->{memory}->{$epoch}->{$msec}->{$nodenr}->{values}->{SwapTotal} <= 0 )
                {
                    $swapvalue = "0.0";
                } else
                {
                    $swapvalue = sprintf("%.1f",(($common->{analysis}->{$syssn}->{memory}->{$epoch}->{$msec}->{$nodenr}->{values}->{SwapTotal} - $common->{analysis}->{$syssn}->{memory}->{$epoch}->{$msec}->{$nodenr}->{values}->{SwapFree})/$common->{analysis}->{$syssn}->{memory}->{$epoch}->{$msec}->{$nodenr}->{values}->{SwapTotal})*100);
                }
                #
                #printf "CFGANAL_MEMORY::CHECK_NODE_MEMORY: NODE: %s [%s] swap: %s\n", $node, $nodenr,  $swapvalue;
                #
                #
                #
                if ($memvalue < 4) {
                    $slabminor = 1.5;
                    $slabmajor = 1.8
                } else {
                    $slabminor = $memvalue * .35;
                    $slabmajor = $memvalue * .45;
                }
                #
                #
                #printf "CFGANAL_MEMORY::CHECK_NODE_MEMORY: ver: $version mem: $memvalue slab: $slabvalue minor: $slabminor major: $slabmajor status: %s\n", $common->{analysis}->{$syssn}->{memory}->{$epoch}->{$msec}->{alerts}->{Slab};
                #
                if      ($slabvalue < $slabminor) { $common->{analysis}->{$syssn}->{memory}->{$epoch}->{$msec}->{$nodenr}->{alerts}->{Slab} = ANALYSIS_OK; 
                } elsif ($slabvalue < $slabmajor) { $common->{analysis}->{$syssn}->{memory}->{$epoch}->{$msec}->{$nodenr}->{alerts}->{Slab} = ANALYSIS_UNDETERMINED;
                } else                            { $common->{analysis}->{$syssn}->{memory}->{$epoch}->{$msec}->{$nodenr}->{alerts}->{Slab} = ANALYSIS_WARNING;
                }
                $common->{analysis}->{$syssn}->{memory}->{$epoch}->{$msec}->{$nodenr}->{alerts}->{Swap} = ANALYSIS_OK;
                if ($swapvalue > 25.0) { 
                    if ($swapvalue > 50.0) { $common->{analysis}->{$syssn}->{memory}->{$epoch}->{$msec}->{$nodenr}->{alerts}->{Swap} = ANALYSIS_WARNING;
                    } else                 { $common->{analysis}->{$syssn}->{memory}->{$epoch}->{$msec}->{$nodenr}->{alerts}->{Swap} = ANALYSIS_UNDETERMINED;
                    }
                } 
                if ($common->{analysis}->{$syssn}->{memory}->{$epoch}->{$msec}->{$nodenr}->{alerts}->{Slab} ne ANALYSIS_OK) {
                    if (!(exists($lptr->{Slab}->{$nodenr}))) {
                        $lptr->{Slab}->{$nodenr}->{$common->{analysis}->{$syssn}->{memory}->{$epoch}->{$msec}->{$nodenr}->{alerts}->{Slab}} = 0;
                    } elsif (!(exists($lptr->{Slab}->{$nodenr}->{$common->{analysis}->{$syssn}->{memory}->{$epoch}->{$msec}->{$nodenr}->{alerts}->{Slab}}))) {
                        $lptr->{Slab}->{$nodenr}->{$common->{analysis}->{$syssn}->{memory}->{$epoch}->{$msec}->{$nodenr}->{alerts}->{Slab}} = 0;
                    }
                    $lptr->{Slab}->{$nodenr}->{$common->{analysis}->{$syssn}->{memory}->{$epoch}->{$msec}->{$nodenr}->{alerts}->{Slab}} += 1;
                }
                #
                if ($common->{analysis}->{$syssn}->{memory}->{$epoch}->{$msec}->{$nodenr}->{alerts}->{Swap} ne ANALYSIS_OK) {
                    if (!(exists($lptr->{Swap}->{$nodenr}))) {
                        $lptr->{Swap}->{$nodenr}->{$common->{analysis}->{$syssn}->{memory}->{$epoch}->{$msec}->{$nodenr}->{alerts}->{Swap}} = 0;
                    } elsif (!(exists($lptr->{Swap}->{$nodenr}->{$common->{analysis}->{$syssn}->{memory}->{$epoch}->{$msec}->{$nodenr}->{alerts}->{Swap}}))) {
                        $lptr->{Swap}->{$nodenr}->{$common->{analysis}->{$syssn}->{memory}->{$epoch}->{$msec}->{$nodenr}->{alerts}->{Swap}} = 0;
                    }
                    $lptr->{Swap}->{$nodenr}->{$common->{analysis}->{$syssn}->{memory}->{$epoch}->{$msec}->{$nodenr}->{alerts}->{Swap}} += 1;
                }
            }
 	    }
	}
    #
	foreach $node (sort keys(%{$lptr->{Slab}})) {
	    foreach my $value (sort keys(%{$lptr->{Slab}->{$node}})) {
                if ($value eq ANALYSIS_UNDETERMINED) { $common->report($syssn, 1004, $node, $lptr->{Slab}->{$node}->{$value}); } else { $common->report($syssn, 1005, $node, $lptr->{Slab}->{$node}->{$value}); } 
	    }
	}
	foreach $node (sort keys(%{$lptr->{Swap}})) {
	    foreach my $value (sort keys(%{$lptr->{Swap}->{$node}})) {
             if ($value eq ANALYSIS_UNDETERMINED) { $common->report($syssn, 1007, $node, $lptr->{Swap}->{$node}->{$value}); } else { $common->report($syssn, 1008, $node, $lptr->{Swap}->{$node}->{$value}); } 
	    }
	}
			
	$common->trace(TRACE_ROUTINES, "<--- cfganal_memory::check_node_memory: 1 (success)");
	#
	# Remove the SLAB data structure, it is no longer necessary at this time. V1.26-6.
	# Remove the MEMINFO data structure, it is no longer necessary at this time. V1.26-7.
    # 
	foreach $node (sort keys %{$common->{config}->{$syssn}->{nodes}})
	{
	    if (exists($common->{config}->{$syssn}->{nodes}->{$node}->{memory}) &&
		    exists($common->{config}->{$syssn}->{nodes}->{$node}->{memory}->{slab}) )
	    {
            #if (DEVELOPMENT_VERSION) { printf STDERR "INEX_ANALYSIS_MEMORY::Dump of Slab Memory: common->config->$syssn->nodes->$node->memory->slab:\n%s\n", Dumper($common->{config}->{$syssn}->{nodes}->{$node}->{memory}->{slab}); }
            delete $common->{config}->{$syssn}->{nodes}->{$node}->{memory}->{slab};
	    }
        #
        if (exists($common->{config}->{$syssn}->{nodes}->{$node}->{memory}) &&
		    exists($common->{config}->{$syssn}->{nodes}->{$node}->{memory}->{meminfo}) )
	    {
            delete $common->{config}->{$syssn}->{nodes}->{$node}->{memory}->{meminfo};
        }
	}

	return 1;
    #
} #End of check_node_memory