﻿//(C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
define([], function() {"use strict";
    return {
        menu : "设置",
        development : {
            title : "开发设置",
            "short-title" : "开发",
            refresh_interval : "刷新间隔",
            ms : "毫秒",
            max_master_items : "主窗格中的最大项数",
            experimental_features : "实验性功能",
            "routing-log-level" : "路由日志级别",
            edit : {
                title : "编辑开发设置",
                success : "更新了开发设置"
            }
        },
        appliance : {
            title : "设备",
            overview : {
                hostname: "主机名",
                ipaddr: "设备 IP 地址",
                ipaddr2: "部署 IP 地址",
                networkInterfaces:"网络接口",
                version: "版本",
                model: "型号",
                datetime: "日期/时间",
                snmp: "SNMP 陷阱目标"
            },
            general: {
                title: "常规",
                hostname: "设备主机名",
                model: "型号",
                serial: "序列号",
                version: "固件版本",
                date: "固件日期"
            },
            IPv4: {
                title: "IPv4",
                address: {
                    "1node": "IP 地址",
                    "2node": "浮动 IP 地址"
                },
                address2: {
                    "1node": "第二 IP 地址"
                },
                addrtype: {
                    "1node": "地址分配",
                    "2node": "固定地址分配"
                },
                node1: "节点 1 固定 IP 地址",
                node2: "节点 2 固定 IP 地址",
                subnet: "子网掩码或 CIDR",
                gateway: "网关地址"
            },

            DNS: {
                title: "DNS",
                preferred: "首选 DNS 服务器",
                alternate: "备用 DNS 服务器"
            },
            timeandlanguage: {
                title: "时间和语言",
                currentdatetime: "当前日期/时间",
                timezone: "时区",
                ntpserver: "网络时间服务器",
                locale: "区域设置",
                ntpnotconfigured:"未配置"
            },
            backup: {
                title: "备份",
                created: "已创建",
                started: "已开始",
                failed: "失败",
                downloaded: "已下载",
                filename: "文件名",
                none: "无",
                never: "从未",
                progress: "正在进行",
                cancelprogress: "正在停止备份",
                error : "错误",
                resolution : "解决方法",
                by: "{0}，根据 {1}"
            },
            snmp: {
                title: "SNMP",
                trapdestination: "陷阱目标",
                trapport: "陷阱端口",
                communitystring: "团体字符串",
                addtrapdestination: "添加陷阱目标",
                port: "端口",
                addMsg : "添加目标 {0}",
                deleteMsg : "删除目标 {0}",
                error : "无法添加目标 {0}。",
                validateHostAddress: "输入有效的主机名或 IP 地址",
                validatePortNumber: "输入 1 到 65535 之间的端口",
                notificationMessage: "无法添加陷阱目标，请更正指示的问题。",
                none: "无",
                retrieveDestinationsfailure: "未能检索陷阱目标。",
                updateMsg : "更新完成。",
                publicStr: "public",
                validateCommunityString: "输入团体字符串",
                addCSMsgSuccess: "已添加团体字符串 {0}。",
                globalcommunitystring: "读取团体字符串",
                communitystringnote:"SNMP 读取团体字符串应用于所有受控服务器硬件、电源设备和机箱。",
                learnmore:"了解更多信息...",
                unableToAddTrapDestination:"无法添加陷阱目标",
                trapforwarding:"陷阱转发",
                notrapdestinations:"无陷阱目标",
                specifyanotherdestination:"请指定另外的陷阱目标。",
                unabletoconfiguredestination:"无法配置陷阱目标 [",
                isdestinationconfigured:"]，因为它已配置。"
            },
            IPv6: {
                title: "IPv6",
                address: {
                    "1node": "IP 地址",
                    "2node": "浮动 IP 地址"
                },
                 address2: {
                    "1node": "第二 IP 地址"
                },
                addrtype: {
                    "1node": "地址分配",
                    "2node": "固定地址分配"
                },
                node1: "节点 1 固定 IP 地址",
                node2: "节点 2 固定 IP 地址",
                subnet: "子网掩码或 CIDR",
                gateway: "网关地址"
            },
            platform : {
                vm : "虚拟机"
            },
            addrType: {
                STATIC: "手动",
                DHCP: "DHCP",
                UNCONFIGURE: "关闭"
            },
            fromDHCP: "来自 DHCP",
            updateLink : "更新设备",
            host : {
                name : "主机名",
                ip : "IP 地址"
            },
            version : "版本",
            hardware : "硬件",
            applianceVersion : "设备版本",
            update : {
                title : "更新设备",
                upload : "上载",
                remove : "删除",
                file : "文件",
                cancelUpdate : "取消更新",
                usersWarning : "<span id='cic-settings-update-usersWarning'>{0} 个其他用户</span>登录到设备。更新设备可能会导致他们丢失任何正在进行的工作。",
                cancelUpload : "取消上载",
                performUpdate : "执行更新",
                releaseNotes : "发行说明",
                currentStatus: "当前状态:",
                updateStatus: "完成了 {0}%",
                progress : "更新",
                failureMessage : "设备更新失败。设备将重新启动并恢复到其更新前状态。请关闭浏览器并在重新启动完成后再次登录。",
                progressInfo : "当更新完成时，浏览器将重新连接。如果您愿意，还可以关闭此浏览器，并在之后再次登录。",
                progressTime : "剩余 {0} 分钟",
                progressTimeOneMinute : "剩余 {0} 分钟",
                installUpdate : "安装更新",
                uploadInstall : "上载并安装",
                uploadOnly : "仅上载",
                uploadTime : "剩余 {0}",
                checktext : "请访问 hp.com 以获得最新",
                check : "更新",
                uploading : "上载",
                applyWarning : "更新将导致服务临时中断，估计持续 {0} 分钟。",
                applyWarningOtherUsers : "更新开始后将锁定这些用户，并且这些用户可能会丢失其工作。",
                applyContinue : "是否继续更新?",
                applyUpdate: "是，更新",
                updateAppliance : "更新设备",
                applyBoxUsersLoggedIn : "另有 {0} 个用户已登录。" ,
                applyBoxOneUserLoggedIn : "{0} 已登录到设备。",
                applianceReboot : "设备即将重新启动。",
                applianceUpdateFailed : "无法更新设备",
                uploadFileStop : "是否停止上载文件 {0}?",
                uploadFileStopWarning : "注意:将丢弃迄今为止传输的任何数据。",
                uploadStop : "停止上载",
                uploadDelete : "删除 {0}",
                uploadFileDeleteWarning : "是否确实要删除 {0}?",
                uploadFileFormatWarning : "文件格式无效。",
                uploadFileDiskSpaceWarning : "空间不足。请确保有足够的空间，然后再继续。",
                healthWarning : {
                    MEMORY_ERROR : "内存不足，无法继续上载。只有 {0} 内存可用。",
                    MEMORY_WARNING : "内存不足。只有 {0} 内存可用。",
                    CPU_ERROR : "CPU 低，无法开始上载。{0} 个 CPU 内核可用。",
                    CPU_WARNING : "CPU 低。{0} 个 CPU 内核可用。",
                    DISK_ERROR : "空间不足，无法继续上载。只有 {0} 空间可用。",
                    DISK_WARNING : "空间不足。只有 {0} 空间可用。"
                },
                uploadStopButton : "是，停止上载",
                uploadDeleteButton : "是，删除",
                uploadWarningConditions  : "错误/警告情况",
                eulaNotification : "上载完成后，将显示最终用户许可协议",
                uploadingNotification : "正在上载",
                uploadedNotification : "更新",
                acceptEULA : "查看 EULA",
                installEULANotification : "要安装更新，您必须先同意 EULA 条款。",
                usersLoggedInAnd : " 和",
                uploadValidating : "正在验证",
                updateMessage : "此文件已做好安装准备。安装可能需要一些时间。安装后，设备将根据需要自动重新引导。",
                continueUpdate : "继续",
                startUpdate : "更新"
            }
        },
        network : {
            panel: {
                hostname: "常规",
                nics: "网络",
                ipv4: "IPv4",
                dns: "DNS",
                ipv6: "IPv6",
                timeandlanguage: "时间和语言",
				errors: "错误"
            },
            "short-title" : "网络",
            dhcpWarning : "除非使用 DHCP 保留，否则不支持 DHCP 分配设备 IP 地址。" ,
            dualStackWarning : "当配置 IPv6 时，确保手动指定的或由 DHCP 提供的 DNS 服务器支持 IPv4 和 IPv6 名称解析。",
            datetimeWarning : "更改设备会话的当前日期和时间将使影响所有已登录的用户和当前正在设备中运行的作业过期或影响它们，因此应用更改后必须重新引导设备。" ,
            datetimeRebootWarning : "设备将按照手动日期时间设置重新引导。",
            timezoneWarning : "重新启动设备后将反映时区更改。" ,
            localeWarning : "只有在重新引导设备后才会反映区域设置更改。" ,
            dhcpDisallowed : "不允许使用 DHCP 配置",
            gatewayWarning : "如果需要从其它子网访问设备，则指定网关地址。" ,
            collapsibleWarning : "如果您为此网络接口输入了任何数据，请保持该行展开，直到您按“确定”为止。如果在按“确定”之前该行折叠，则您输入的数据将不被保存。" ,
            deploymentIPWarning : "Insight Control server provisioning 建议您不要更改部署 IP 地址，即使在共享和独立模式之间更改也是如此。始终保持部署 IP 地址相同，根据需要修改设备 IP。",
            dialog : {
                action : "正在应用网络设置。",
                certwarn : "如果浏览器提示您接受证书，则请照做。",
                redirect : "浏览器将很快重定向到新的设置。",
                browserwarn :"某些浏览器安全设置可能会影响错误处理。如果设备变得无法访问，则请查阅印刷版设备文档以了解恢复操作。",
                altairftswarn : "应用设置后，设备重新引导前会有短暂的延迟。整个过程需要约 15 分钟。请不要在重新引导完成前尝试使用设备，即使出现主菜单也是如此。",
                altaireditappliancewarn : "如果您在共享和独立模式之间切换，您的设备将自动关闭，以便让您重新配置设备的网络设置。当设备关闭后，重新配置网络连接以与新设置匹配，并重新打开设备的电源以完成重新配置。"
            },
            error : {
                get : {
                    msg:  "无法检索网络设置。",
                    res : "请查阅印刷版设备文档以了解恢复操作。"
                },
                set : {
                    timeout : {
                        msg : "无法自动与设备重新连接。",
                        res : "使用设备的控制台，检查“活动”屏幕有无可能的原因，并使用“设置”屏幕来确定设备的当前 IP 地址。",
                        resDhcp : "网络配置已从静态更改为 DHCP。无法通过主机名访问设备。请确认主机名或 IP 地址可访问，打开一个新浏览器，然后连接到新的主机名或 IP 地址。"
                    },
                    ftsinprogress : {
                        msg : "正在进行另一个设备网络配置。"
                    },
                    unknown : {
                        msg : "发生了错误。无法正确地应用所有网络设置。",
                        res : "请重新启动设备。如果重新启动设备后未应用网络设置，请与 HP 支持联系。"
                    }
                }
            },
            fields : {
              alias: "与设备接口共享",
              independent: "独立",
                addrselector: {
                    full: "地址分配",
                    short: "地址"
                },
                ipv6switch : "IPv6",
                ipv6state : {
                    on : "ON",
                    off : "OFF"
                },
                certificatechain: "Certificate chain (optional)",
                rabbitmqlistner: "RabbitMQ 在此网卡上侦听。",
                postgresqllistner: "PostgreSQL 在此网卡上侦听。",
                certificates: "证书",
                importrabbitmq: "RabbitMQ", 
                importpostgresql: "PostgreSQL",
                catrootcertificate: "CA 根证书",
                messaging: "消息传递",
                database: "数据库",
                servercertificate: "服务器证书",
                privatekey: "私钥",
                cacertificate: "CA 证书",
                webserver: "Web 服务器",
                webservercertificates: "Web 服务器证书",
                services: " 服务",
                listnermessage  : "允许服务在此网卡上侦听。",
                restartwarn : "导入证书时将有临时服务中断。",
                privatekeywarn: "Provide a valid RSA key.",
                certificate: "证书",
                compliantcert: "Provide X.509 compliant certificate.",
                
                dns1 : {
                    full : "首选 DNS 服务器",
                    short : "首选"
                },
                dns2 : {
                    full : "备用 DNS 服务器",
                    short : "备用"
                },
                manualdatetime : {
                    full : "手动",
                    synchronizeWithHost : "与 VM 主机同步"
                },
                syncwithserver : {
                    full : "与时间服务器同步"
                },
                ntpserver : {
                    full : "网络时间服务器",
                    recommended : "推荐"
                },
                currentdatetime : {
                    full : "当前日期和时间"
                },
                currentdatetimelabel : {
                    full : "当前日期和时间"
                },
                timezone : {
                    full : "时区"
                },
                locale : {
                    full : "默认语言/区域设置"
                },
                gateway : {
                    both : "网关",
                    full : "网关地址",
                    short : "网关"
                },
                hostname : {
                    full : "设备主机名",
                    short : "名称"
                },
                ipaddr : {
                    short : "IP 地址",
                    applianceip : "设备 IP",
                    fromDHCP : "来自 DHCP",
                    node1 : {
                        full : "节点 1 固定 IP 地址",
                        short : "节点 1"
                    },
                    node2 : {
                        full : "节点 2 固定 IP 地址",
                        short : "节点 2"
                    },
                    "one-node" : {
                        both : "IP 地址",
                        full : "IP 地址",
                        short : "IP 地址"
                    },
                    "two-node" : {
                        both : "浮动 IP 地址",
                        full : "设备浮动 IP 地址",
                        short : "浮动 IP 地址"
                    }
                },
                ipaddr2 : {
                    short : "第二 IP 地址",
                    deploymentip : "部署 IP",
                    node1 : {
                        full : "节点 1 第二固定 IP 地址"
                    },
                    node2 : {
                        full : "节点 2 第二固定 IP 地址"
                    }
                },
                iptype : {
                    ipv4 : "IPv4 配置",
                    ipv6 : "IPv6 配置",
                    "one-node" : " ",
                    short : "配置",
                    "two-node" : {
                        fixed : "固定 IP 地址分配",
                        floating : "浮动 IP 地址分配"
                    }
                },
                proxy : {
                    short : "Web 代理"
                },
                slaac : "SLAAC IP 地址",
                usage : "用法",
                appliance : "设备",
                deployment : "部署",
                management : "管理",
                subnet : {
                    both : "子网",
                    full : "子网掩码或 CIDR",
                    short : "子网"
                }
            },
            headings : {
                appliance : "设备",
                dns : "DNS",
                ha : "高可用性",
                ipv6 : "IPv6"
            },
            iptype : {
                dhcp : "DHCP",
                manual : "手动",
                off : "关闭",
                unassign : "取消分配",
                dhcpv6 : "DHCPv6"
            },
            notify : {
                sourceName : "设备网络",
                set : {
                    parameterError : "参数无效。请更正任何错误后继续。",
                    verify : "正在验证网络设置...",
                    start : "正在应用网络设置。如果手动更改了设备的日期和时间，请重新启动设备。",
                    success : "配置已保存。",
                    error : "无法应用设置。",
                    warning :"验证期间遇到了警告。",
                    warning_resolution:"如仍要继续，请单击“确定”。",
                    multi_nic_fts_error:"主要网卡和部署网卡必须在首次设备设置期间设置。"
                }
            },
            "slaac-ip-address" : "SLAAC IP 地址",
            title : "设备联网",
            "dns-info" : "DNS",
            validator : {
                dns : {
                    ipv4_only : "请输入 DNS 服务器的有效 IPv4 地址。",
                    ipv4_ipv6 : "请输入 DNS 服务器的有效 IPv4 或 IPv6 地址。"
                },
                "gateway-ipv4" : "请输入有效的 IPv4 网关地址。",
                "gateway-ipv6" : "请输入有效的 IPv6 网关地址。",
                hostname : {
                    fqdn_optional : "请输入有效的主机名或完全限定域名。",
                    fqdn_required : "请输入有效的完全限定域名。"
                },
                ntpserver : {
                    ipv4 : "请输入 NTP 服务器的有效 IPv4 地址。",
                    ipv4_v6 : "请输入 NTP 服务器的有效 IPv4/v6 地址。",
                    ipv4_dns : "请输入 NTP 服务器的有效 IPv4 地址或主机名。",
                    ntp_fqdn_required : "请输入 NTP 服务器的有效 IP 地址或主机名。",
                    set_date_time_manually : "请手动设置日期/时间"
                },
                currentdatetime : {
                    datetime_required : "请使用日期选取器选择有效的日期和时间。",
                    datetime_format_resolution : "请确保将日期/时间的格式设置为 yyyy-mm-dd hh:mm:ss。"
               },
                timezone : {
                     timezone_required : "请选择有效的时区。"
                },
                locale : {
                    locale_required : "请选择有效的区域设置。"

               },
               usage : "请输入有效的网络接口名称。",
                ipv4 : "请输入有效的 IPv4 地址。",
                ipv6 : "请输入有效的 IPv6 地址。",
                "mask-ipv4" : "请输入有效的 IPv4 网络掩码，或 0 至 32 之间的 CIDR 位数。",
                "mask-ipv6" : "请输入有效的 IPv6 网络掩码，或 0 至 128 之间的 CIDR 位数。"
            },
            edit : {
              title : "编辑设备"
            }
        },
        authn : {
            title : "Authentication（身份验证）",
            "short-title" : "Authentication（身份验证）",
            allow_local : "允许本地登录",
            default_provider : "默认目录",
            providers : "提供方",
            get_failed : "未能检索一个或多个身份验证设置。",
            providers_not_set : "未设置",
            enabled : "已启用",
            disabled : "已禁用",
            local : "本地",
            default_directory : " (默认)",
            failed_get_global_settings : "未能检索全局设置。",
            failed_set_default_provider : "未能设置默认提供方。",
            refresh_and_verify_provider : "请刷新页面并确认存在所寻找的提供方。",
            auth_settings_error : "身份验证设置错误:",
            failed_get_provider_info : "未能获得提供方信息",
            plus_more : "还有 {0} 个",
            enable_local_login : "已启用",
            explain_login_provider : "要禁用本地登录，必须使用其它身份验证服务进行登录。",
            edit : {
              title : "编辑身份验证",
              success : "更新了身份验证设置",
              add_authn_service : "添加目录",
              service_name : "目录名",
              remove : "删除",
              verify : "验证身份",
              protocol : "协议",
              baseDN : "基本 DN",
              directory_servers : "目录服务器",
              add_server : "添加服务器",
              host_name : "主机名",
              default_dir_error : "不允许本地登录。请选择 LOCAL 以外的选项用于默认目录。",
              default_dir_delete_error : "无法删除默认目录。请更改默认目录，然后重试。",
              default_dir_delete_error2 : "无法删除目录，其设置与默认目录相同!",
              directory_server_required_error : "需要至少一个目录服务器。",
              baseDN_required_error : "所有三个值均为必填。",
              host_name_error : "请提供主机名。",
              save_failure : "未能完成添加操作，因为缺少一个或多个所需的项或其无效。请输入缺少的数据，然后重试。",
              failure_resolution : "请更正错误，然后重试。",
              delete_directory_errormessage : "属于某个目录的用户无法删除或编辑该目录。",
              directory_server_duplicate_error : "目录服务名称不得重复。",
              default_dir_change_common_msg : "Changing the default directory can allow users unauthorized access to OpenStack resources.",
              default_dir_change_warning_msg : "Ensure that the original and new directories do not use the same user name to identify different individuals.",
              default_dir_change_confirm_msg : "Do you want to change the default directory?",
              default_dir_update_yes : "Yes,change",
              default_dir_change_title : "Change Default Directory",
              search_ctx_update_warning_msg : "Ensure that the original and new search context do not use the same user name to identify different individuals.",
              search_ctx_update_common_msg : "Changing the search context can allow users unauthorized access to OpenStack resources.",
              search_ctx_update_confirm_msg : "Do you want to change the search context?",
              search_ctx_update_title : "Change Search Context"
            },
            addDirectory : {
                title : "添加目录",
                directory_name : "目录",
                directory_type : "目录类型",
                search_context : "搜索上下文",
                search_context_uid : "搜索上下文(UID)",
                search_context_org : "搜索上下文(组织)",
                search_context_top : "搜索上下文(顶级域)",
                credentials_title : "凭证",
                credentials_text : "(用于验证服务器连接，将不保存)",
                username : "用户名",
                password : "密码",
                directory_servers : "目录服务器",
                add_directory_server : "添加目录服务器",
                success_notification : "更新目录",
                add_success : "添加目录 {0}",
                remove_server_success : "删除了 {0}",
                invalid_naming_attribute : "值不正确。请根据 AD/LDAP 服务器配置输入 CN 或 UID。",
                max_search_context : "最多可以指定 {0}个搜索上下文。",
                help_example : "示例",
                help_field1 : "字段1",
                help_field2 : "字段2",
                help_field3 : "字段3",
                certificate_placeholder : "将密钥粘贴到此处",
                disable_multirdn : "Incorrect value. '+' is not allowed."
            },
            addServer : {
                title : "添加目录服务器",
                host_name : "IP 地址或主机名",
                ssl_port : "目录服务器端口",
                certificate : "目录服务器证书",
                success : "更改:目录服务器为 {0}",
                table_column_server : "服务器",
                table_column_certificate : "证书",
                certificate_state_yes : "是",
                duplicate_host : "主机名或 IP 地址重复。请指定其它目录服务器。",
                invalid_host : "主机名或 IP 地址无效。",
                invalid_port : "端口号无效 - 必须为数字值。",
                invalid_port_range : "端口号范围无效。(范围:0 至 65535)。",
                invalid_certificate : "输入的证书似乎不是 X.509 证书。请输入有效的 AD/LDAP 服务器证书。"
                }
        },
        overview : {
            title : "设置"
        },
        auditlogs : {
            download : "下载审核日志"
        },
        edit : {
            title : "编辑设置",
            saved : "已保存设置。"
                },
        supportdump : {
            title : "创建支持转储",
            error_creating_dump : "创建转储时出错",
            error_creating_dump_message : "创建支持转储失败。重试。",
            error_downloading_dump : "下载转储时出错",
            error_downloading_dump_message : "下载支持转储失败。很可能是一个新的支持转储请求已经启动。",
            createtitle : "创建支持转储",
            create_button : "是，创建",
            creating_dump : "创建支持转储",
            create_dump : "创建支持转储可能需要几分钟时间，然后将自动开始下载文件。同时仍可正常使用 UI。",
            dump_created : "成功创建了转储",
            encryption_label :"启用支持转储加密",
            create_prompt : "是否要立即创建支持转储?"

        },
        factoryReset: {
            title: "将设备重置为出厂默认设置",
            factoryResetAction : "出厂重置",
            warning: "此操作将擦除设备上的所有数据、日志和设置。",
            partialResetOption : "重置为出厂默认设置，同时保留设备网络设置",
            paritalResetInfo : "在设备网络设置相同的同一环境中重用设备时很有用。",
            fullResetOption : "整个设备通过出厂重置变为默认设置",
            fullResetInfo : "在设备网络设置不同的其它环境中改变设备用途时很有用。",
            fullResetWarning : "如果因出厂重置而更改了网络设置，则浏览器可能会丢失与设备的连接。如果发生这种情况，则请打开新浏览器连接到设备的新地址，或使用设备控制台上的展台界面。",
            startFailure : " 出厂重置未能开始。",
            ok: "正常"
        },
        shutdown: {
            title:"关闭设备",
            shutdownAction: "关闭",
            warning:"关机将使所有用户断开连接并中断所有正在进行的任务。",
            start_prompt : "是否继续关机?",
            ok: "是，关机。" ,
            errorMsg : "无法执行关机。"
        },
        restart: {
            title:"重新启动设备",
            shutdownAction: "重新启动",
            warning:"重新启动将使所有用户断开连接并中断所有正在进行的任务。",
            start_prompt : "是否继续重新启动?",
            ok: "是，重新启动。" ,
            errorMsg : "无法执行重新启动。"
        },
        restore: {
            kiloBytes: "KB",
            megaBytes: "MB",
            gigaBytes: "GB",
            title: "从备份进行还原",
            uploadingTitle : "正在上载",
            validatingTitle : "正在验证",
            restorePendingTitle : "还原",
            restoreAction : "从备份进行还原",
            backupFileTitle : "备份文件",
            useUploadedFile : "选择备份文件",
            useStagedFile : "从备份文件还原",
            uploadAndRestore : "上载并还原",
            uploadOnly : "仅上载",
            aFileIsRequired : "必须选择文件。",
            uploadFileFormatWarning : "文件格式无效。",
            uploadInProgress : "正在上传。",
            uploadHMSRemaining: "还剩 {0} 小时 {1} 分钟 {2} 秒",
            uploadMSRemaining: "还剩 {0} 分钟 {1} 秒",
            uploadStop : "停止上载",
            uploadStopWarning : "停止上载将丢弃迄今为止传输的任何数据。一旦上载完成，您将能够从上载的文件还原。",
            validationInProgress : "正在进行验证。",
            backupIsReady : "此备份已就绪。",
            noBackupStaged : "还未上载任何文件。",
            restoreFromBackup : "还原",
            restoreFromBackupConfirmationWarning : "在开始还原过程之前，请确保您理解所有含义。",
            restoreFromBackupConfirmationCheckbox : "我已阅读并理解所有含义。",
            restoreFromBackupConfirmationRequired : "必需。",
            restoreFromBackupConfirmationPrompt : "是否继续从备份进行还原?",
            yesRestoreFromBackup : "是，还原",
            fileNameLabel : "文件",
            createdDateLabel: "已创建",
            versionLabel : "版本",
            sizeLabel : "大小",
            sizeData : "{0} {1}",
            uploading : "正在上载文件",
            stopUpload : "停止上载",
            uploadStopped : "已停止上载",
            closeUpload : "关闭",
            uploaded : "已上载文件",
            validating : "正在验证文件 – 这可能需要一段时间",
            validated : "已验证文件",
            stopRestore: "停止还原",
            restoreCanceled : "已取消还原",
            uploadProgressUnknowable : "正在上载并验证文件 – 这可能需要一段时间",
            backupTooBigErrMsg : "备份太大，无法上载。",
            backupTooBigResolutionMsg : "请选择小于 {0} GB 的备份。",
            restoreWarningSummary: "从备份还原是中断性行为。",
            restoreWarningDetails: "任何正在使用设备的用户都将注销并且其工作将丢失。",
            restoreStarted : "正在从备份进行还原...",
            uploadOverwritten : "另一个备份操作删除了已上载的备份。",
            retryUpload : "请重试上载备份。",
            uploadFailed : "备份上载未能完成。",
            retryOrSelectAlternate : "请重试或选择一个替代备份。",
            backupIsCompatible : "该文件是兼容的。",
            uploadActivity : "上载",
            uploadError : "上载错误",
            validationFailure : '验证失败',
            restoreModeStartError : '无法启动还原',
            restoreActivity : '还原'
        },
        backup: {
            backupAction : "创建备份",
            backupDownloadAction: "下载备份",
            backupDownloadLinkLabel: "下载最新备份",
            unableToStartBackup: "无法开始备份。",
            backupDidNotComplete: "备份未完成。",
            errorGettingBackupProgress: "无法获得备份进度信息。",
            unableToDownloadBackup: "无法下载备份。",
            uploadedBackup: "无法下载已上载的备份。",
            noBackup: "不存在任何备份。",
            backupInProgress: "已在进行备份。",
            waitForBackupToComplete: "请等到备份完毕，然后重试该操作。",
            createBackupAndRetry: "请创建备份，然后重试该操作。",
            errorCancellingBackup: "无法停止备份。",
            backupCreateDetails: "备份由 {0} 启动。",
            backupDownloadSummary: "下载备份",
            backupDownloadDetails: "由 {1} 请求下载备份 {0}。",
            completedDetails: "备份完毕，已准备好下载。\n\n备份 {0} 由 {1} 创建。",
            canceledDetails: "已停止备份。",
            backupSourceName: "设备",
            backupStopLinkLabel: "停止备份",
            backupStopDialogTitle: "停止备份",
            backupStopButtonLabel: "是，停止备份",
            backupStopConfirmMessage: "是否继续停止备份?"
        },
        security : {
          title : "安全性",
          overview : {
            cert_title : "证书",
            common_name : "证书公用名(CN)",
            valid_until : "有效期截止日期",
            expires_in : "(在 {0} 天后到期)",
            expires_message : "设备证书在 {0} 天后到期。",
            expires_detail_message : "证书在 {0} 到期，距现在还有 {1} 天。",
            expires_resolution : "使用 {0} 或 {1} 导入新证书。",
            auth_title : "Authentication（身份验证）",
            local_login : "本地登录",
            default_directory : "默认目录",
            directories : "目录",
            add_directory : "添加目录"
            },
            publickey : {
                title : "密钥",
                download_location_msg : "可从 {0} 获得最新 HP 公钥。",
                uploaded : "上载了 HP 公钥",
                display_content : "显示内容",
                paste_message : "将密钥粘贴到此处",
                key_message : "此密钥用于验证所有修补程序和更新的真伪。"
            },
            firmwarebundle : {
                optiontext : "更新固件使用的是",
                http : "HTTP – 更快",
                https: "HTTPS – 更安全",
                displayText: "此设置控制用于在更新服务器硬件的固件时使用的 iLO 虚拟介质安装的协议。<a href=\"doc#/cic/enclosure/add/learnmore\" target=\"hphelp\">了解更多信息...</a>"
            },
            edit_security_title: "编辑安全性",
            panel: {
                authentication : "Authentication（身份验证）",
                hp_public_key : "HP 公钥",
                firmware_bundle : "固件软件包"
            },
            more :{
                directories : "目录",
            authn :{
              active_directory : "Active Directory",
              open_ldap : "OpenLDAP",
                directory_type : "目录类型",
                naming_attribute: "命名属性",
                search_context : "搜索上下文",
                directory_servers : "目录服务器",
                no_directories : "无目录"
             }
            },
            edit_authn : {
              edit_directory_title : "编辑目录",
              edit_directoryserver_title : "编辑目录服务器",
              delete_title : "删除 {0}",
              delete_message : "是否确实要删除 {0}?是否继续删除?",
              delete_yes :"是，删除"
            }
        },
        certificate : {
            title : "证书设置",
            csr_attributes : "证书签名请求属性",
            unstr_name : "无结构名称",
            selfsigned : {
              create_action_title : "创建自签名证书",
              create_title : "创建自签名证书",
              required_information : "必需的信息",
              optional_information : "可选的信息",
              create_success : "创建了自签名证书。",
              create_error : "无法创建自签名证书。",
              create_action : "创建",
              get_action : "检索",
              source_object : "自签名证书",
              get_error : "无法检索当前的自签名证书。",
              update_button : "是，更新",
              cancel_button : "取消",
              dialog : {
              title : "更新证书",
                update : "正在应用更新...",
                certwarn : "浏览器刷新时，可能需要接受浏览器证书警告。",
                restartwarn : "警告:更新证书将需要重新启动设备 Web 服务器。可能会临时中断服务，估计持续 30 秒。",
                reconnectmsg :"系统再次可用时，您将自动重新连接。",
                continue_update : "是否继续更新?",
                usersLoggedIn : "另有 {0} 个用户已登录",
                oneUserLoggedIn : "另有 1 个用户已登录",
                remaining : "剩余 {0} 秒"
              },
              error : {
                timeout : {
                  msg : "重新启动 Web 服务器后，无法再访问该设备。",
                  res : "请验证此浏览器与设备的网络地址之间的连接。请查阅印刷版设备文档以了解其它恢复操作。"
                },
                unknown : {
                    msg : "无法创建自签名证书。",
                    res : "请重新启动设备。如果在重新启动设备后无法创建自签名证书，请与 HP 支持联系。"
                },
                support_dump_link : "创建支持转储",
                support_dump_link_message : "如果问题仍然存在，请 {0} 并与授权的支持代表联系寻求帮助。"
              }
            },
            country : "国家/地区",
            state : "省/直辖市/自治区(ST)",
            locality : "市或地区(L)",
            org : "组织名称(O)",
            cn : "公用名(CN)",
            ou : "组织单位",
            alt_name : "可选名称",
            contact : "联系人",
            email : "电子邮件地址",
            surname : "姓氏",
            given_name : "名字",
            initials : "姓名首字母",
            dn : "DN 限定符",
            explain_comma_list : "请输入可选名称的逗号分隔列表(如主机名、IP 地址)。CN 是必需的可选名称，如果此处未提供，则将自动添加它。",
            hostname_regen_cert_warn    : "如果更改主机名，则需要生成新的 SSL 证书，以便安全地与浏览器进行通信。",
            hostname_regen_cert_warn_csr    : "如果更改主机名，则需要生成新的 SSL 证书，以便安全地与浏览器进行通信。还需要另外生成一个 CSR，然后获得新签名的 SSL 证书并将其导入设备。",
            ipaddress_regen_cert_warn    : "如果更改 IP 地址，则需要生成新的 SSL 证书，以便安全地与浏览器进行通信。",
            ipaddress_regen_cert_warn_csr    : "如果更改 IP 地址，则需要生成新的 SSL 证书，以便安全地与浏览器进行通信。还需要另外生成一个 CSR，然后获得新签名的 SSL 证书并将其导入设备。",
            hostname_cn_mistmatch    : "证书的主机名与公用名不同。这种情况需要生成新的 SSL 证书，以便安全地与浏览器进行通信。",
            hostname_cn_mistmatch_csr    : "证书的主机名与公用名不同。这种情况需要生成新的 SSL 证书，以便安全地与浏览器进行通信。还需要另外生成一个 CSR，然后获得新签名的 SSL 证书并将其导入设备。",
            validator : {
              host_or_ip_required : "请指定有效的主机名或 IP 地址。",
              max_length : "输入的字符不要超过 {0} 个。",
              max_length_no_cn : "系统自动将 CN 添加到此字段，但这样做将超出 {0} 的最大大小限制。请留出足够的空间以容纳 CN。",
              matchpasswd : "密码必须匹配。",
              passwdvalidation : "密码不应包含 < > ; , \" ' & \\ / | + := 和空格中的任意一项。"

            },
            more_title : "证书",
            required_information : "必需的信息",
            optional_information : "可选的信息",
            common_name : "证书公用名(CN)",
            issued_by : "颁发者",
            valid_from : "有效期起始日期",
            valid_until : "有效期截止日期",
            serial_number : "序列号",
            version : "版本",
            md5_fingerprint : "MD5 指纹",
            sha1_fingerprint : "SHA1 指纹",
            cert_sign_req_attr : "证书签名请求属性",
            unstructured_name : "无结构名称",
            csr : {
              create_action_title : "创建证书签名请求",
              create_title : "创建证书签名请求",
              create_action : "创建",
              source_object : "证书签名请求",
              required_information : "必需的信息",
              optional_information : "可选的信息",
              create_success : "创建了证书签名请求。",
              create_error : "无法创建证书签名请求。",
              get_error : "无法检索当前证书。",
              ok_button : "正常",
                cancel_button : "取消",
                challenge_password : "质询密码",
                confirm_password : "确认密码",
                dialog : {
                  base64_save : "可以使用以下 base64 编码数据从证书服务器中请求证书。请复制下方的数据，然后用这些数据制作证书请求。收到证书后，请使用“设置”页中的“操作->导入证书”菜单项导入该证书。"
                },
                error : {
                  support_dump_link : "创建支持转储",
                  support_dump_link_message : "如果问题仍然存在，请 {0} 并与授权的支持代表联系寻求帮助。"
                }
            },
            signedimport : {
              import_success : "导入了设备证书。",
              import_action_title : "导入证书",
              import_title : "导入证书",
              import_action: "导入",
              import_paste : "粘贴证书以将其导入设备。",
              certificate : "证书",
              dialog : {
                  importing : "正在导入证书...",
                  certwarn : "浏览器刷新时，可能需要接受浏览器证书警告。",
                  restartwarn : "警告:导入新证书将需要重新启动设备 Web 服务器。可能会临时中断服务，估计持续 30 秒。",
                  reconnectmsg :"系统再次可用时，您将自动重新连接。",
                  usersLoggedIn : "另有 {0} 个用户已登录",
                  oneUserLoggedIn : "另有 1 个用户已登录",
                  remaining : "剩余 {0} 秒"
              },
              error : {
                unknown : {
                  msg : "无法导入签名证书。",
                  res : "请重新启动设备。如果在重新启动设备后无法导入签名证书，请与 HP 支持联系。"
                }
              }
            },
            truststore : {
                self_signed_warn : "安全证书不受信任，因为它是自签名的。",
                issue_untrusted_warn : "安全证书是由不被信任的实体签名的。",
                invalid_warn : "所提供的安全证书不在有效期内。",
                hostname_not_found_warn : "来自此网站的安全证书是针对不同网站的地址签名的。",
                connection_untrusted_warn : "此连接不受信任。",
                issued_to : "颁发对象",
                issued_by : "颁发者",
                valid_from : "有效期起始日期",
                to : "to",
                retrieve_cert_error : "无法检索证书。",
                retrieve_cert_resolution : "解决方法:重试注册。",
                header : "信任证书",
                variableheader : "信任证书 {0}",
                certificate_information : "证书",
                details : "详细信息",
                trust_confirm : "是否继续信任证书?",
                trust_confirm_multiple : "是否继续信任证书?",
                ca_info : "证书颁发机构",
                not_auth : "未授权您执行此操作",
                not_auth_resol : "请检查您的凭证，然后重试注册。",
                version : "版本",
                serial_number : "序列号",
                common_name : "主题( CN, O, L, S, C)",
                issuer : "颁发者",
                alternative_name : "主题可选名称",
                sha1_fingerprint : "SHA1 指纹",
                md5_fingerprint : "MD5 指纹",
                signature_algorithm : "签名算法",
                public_key : "公钥",
                revoked_msg : "已经吊销安全证书",
                revoked_resol : "确认主机地址正确无误，然后重试注册",
                close : "关闭",
                ok_trust : "是，信任证书",
                cancel_trust : "不，不信任",
                upload_ca_cert : "上载主机的 CA 证书，然后继续注册。",
                invalid_chain : "安全证书不受信任，因为证书链无效。",
                invalid_chain_resol : "更正主机中的证书链，然后重试注册",
                ca_certificate : "CA 证书",
                ca_cert_header : "添加 CA 证书",
                ca_cert_upload_error : "无法添加证书",
                verifying : "正在验证...",
                ca_cert_upload_error_detail : "证书无效。请提供有效的证书。",
                upload_ca_reason : "{0} 的安全证书不受信任，因为颁发者未知。",
                required : "必需"
            }
        },
        supportaccess : {
            service_unavailable : "无法获取支持访问。",
            error : "无法编辑支持访问。",
            update : "更新",
            source_object : "服务访问",
            success : "成功更新了服务访问。",
            failure : "未能更新服务访问。"
        },
        eula : {
            config : {
                appliance_name : "虚拟设备",
                end_user_title : "许可证",
                eula_title : "最终用户许可协议",
                agree_button : "同意",
                disagree_button : "不同意",
                yesdisagree_button : "是，不同意",
                confirmation_dialog_advice : "如果您不同意最终用户许可协议的条款，则无法继续。",
                end_user_support_title : "支持",
                application_support : "应用程序支持",
                warning : "警告",
                written_offer : "正式文件",
                enabled : "已启用",
                disabled : "已禁用",
                support : "支持",
                license : "许可证",
                support_access_enabled : "已授权服务访问",
                edit_appliance_support_access : "编辑服务访问",
                agree_disagree_message : "如果您同意许可条款，请单击“同意”。否则，单击“不同意”。",
                content_directory: "/ui-js/pages/fs/license",
                upgrade_content_directory: "/ui-js/pages/upgrade",
                eula_content_file : "eula_content.html",
                support_access_file : "support_access_and_written_offer.html"
            }
        },
        license : {
            config : {
                add_license : "添加许可证",
                add_license_title : "添加许可证",
                license_key: "许可证密钥",
                licensing_portal : "HP 许可门户",
                verifying_license : "正在验证许可证密钥...",
                successMsg : "添加许可证",
                error : {
                      msg : "无法添加许可证:"
                  }
            },
            summary : {
                add : "添加",
                no_licenses : "无许可证",
                license : "许可证",
                licensed : "已许可服务器",
                licensed_instance_required : "无 {0} 许可证的实例",
                compliance : "用量",
                license_required : "{0} {1} required",
                licensed_total_nodes : "已许可 {0} {1}",
                available_license : "{0} {1} available",
                peak_usage : "{0} 峰值用量",
                total_license : "{0} 许可证总计",
                type : {
                    node : "个节点",
                    node_plural : "个节点",
                    instance : "个实例",
                    instance_plural : "个实例",
                    vm : "个 vm",
                    vm_plural : "个 vm",
                    server : "个服务器",
                    server_plural : "个服务器",
                    license : "license",
                    license_plural : "licenses"
                }
            },
            notification :{
                title : "需要更多许可证",
                details : "请添加更多 {0} 许可证以保证合规性。",
                license_ok : "所有服务器都已许可"
            }
        }

    };
});
