// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
define(['hp/core/Router',
        'hp/core/UrlFragment'],
function (router, urlFragment) { "use strict";

    var ApplianceUpdateRoutes = ( function() {

        var PAGE_CONTAINER = '#hp-page-container';
        var AUTH_CATEGORY = 'appliance';

        function ApplianceUpdateRoutes() {

            var registered = false;

            this.register = function () {

                if (registered) {
                    return;
                }
                registered = true;

                router.map('update install', '/appliance-update', {
                    menu: {
                        simpleBanner: true
                    },
                    container: PAGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!fsPages/settings/appliance/updateandinstall.html',
                            'fs/view/settings/appliance/ApplianceUpdateAndInstallView'],
                        function (page, view) {
                            result.loadIfManageable(page, view, AUTH_CATEGORY);
                        });
                    }
                });


            };
        }

        return new ApplianceUpdateRoutes();
    }());

    return ApplianceUpdateRoutes;
});
