// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
define([], function() {"use strict";

    var AuthNSettings = ( function() {

        function AuthNSettings() {

            var allowLocalLogin, defaultProvider, providerInfos = null;

            this.getAllowLocalLogin = function() {
                return allowLocalLogin;
            };

            this.setAllowLocalLogin = function(value) {
                allowLocalLogin = value;
            };

            this.getDefaultProvider = function() {
                return defaultProvider;
            };

            this.setDefaultProvider = function(value) {
                defaultProvider = value;
            };

            this.getProviderInfos = function() {
                return providerInfos;
            };

            this.setProviderInfos = function(value) {
                providerInfos = value;
            };

            this.getProviderInfoById = function (loginDomain) {
                if (providerInfos !== null) {
                    for (var i = 0; i < providerInfos.length; i++) {
                        if (providerInfos[i].loginDomain === loginDomain) {
                            return providerInfos[i];
                        }
                    }
                }
                return null;
            };

            this.clear = function () {
                allowLocalLogin = null;
                defaultProvider = null;
                providerInfos = null;
            };
        }

        return new AuthNSettings();
    }());

    return AuthNSettings;

});
