// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
define(['hp/core/Router','hp/core/UrlFragment'],
function (router, urlFragment) { "use strict";

    var BackupRoutes = ( function() {

        var CONFIRM_CONTAINER = '#hp-dialog-container';
        var AUTH_CATEGORY = 'backups';

        function BackupRoutes() {

            var registered = false;

            this.register = function () {

                if (registered) {
                    return;
                }
                registered = true;
                
                router.map('settings backup stop', '/settings/backup/stop' + urlFragment.viewPatternTerminal, {
                    container: CONFIRM_CONTAINER,
                    enter: function (location, result) {
                        require(['text!fsPages/settings/backup/backup_stop.html',
                            'fs/view/settings/backup/BackupStopView'],
                        function (page, view) {
                            result.loadIfManageable(page, view, AUTH_CATEGORY);
                        });
                    }
                });
            };
        }

        return new BackupRoutes();
    }());

    return BackupRoutes;
});
