// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
define(['hp/model/Resource',
        'fs/services/settings/CertificateService',
        'fs/services/users/UserService',
        'hp/model/Session',
        'jquery'],
    function(Resource, certificateService, userService, session) {"use strict";
    var CertificateResource = ( function() {
        function CertificateResource() {

            // derive from Resource
            Resource.call(this, 'appliance');
            var self =  this;

            var otherLoggedInUsersList = [];

            function getOtherUsersLoggedIn(loggedInUsersData) {
                var userSet = {};

                if (loggedInUsersData.count > 0) {
                    var currentUser = session.getUser();
                    for ( var i = 0; i < loggedInUsersData.members.length; i++) {
                        // TODO: change this to a scrollable list
                        var loggedInUser = loggedInUsersData.members[i].username;
                        // creating a set to avoid duplicate elements.
                        if (!userSet[loggedInUser]) {
                            userSet[loggedInUser] = true;
                            if (loggedInUser !== currentUser) {
                                otherLoggedInUsersList.push(loggedInUser);
                            }
                        }
                    }
                }
            }

            function onUsersLoggedInListSuccess(data) {
                getOtherUsersLoggedIn(data);
                self.fire('usersLoggedInSuccess', data);
            }

            function onUsersLoggedInListError(errorInfo) {
                self.fire('usersLoggedInError', errorInfo);
            }

            this.clearLoggedInUsersList = function() {
                otherLoggedInUsersList = [];
            };

            this.usersLoggedIn = function(data) {
                userService.usersLoggedIn({
                    success : onUsersLoggedInListSuccess,
                    error : onUsersLoggedInListError
                });
            };

            this.setOtherUsersLoggedInList = function(list) {
                otherLoggedInUsersList = list;
            };

            this.getOtherUsersLoggedInList = function() {
                return otherLoggedInUsersList;
            };
        }

        return new CertificateResource();

    }());

    return CertificateResource;

});
