// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
define(['hp/core/Router', 'hp/core/UrlFragment'],
function (router, urlFragment) { "use strict";

    var CertificateRoutes = ( function() {

        var CHANGE_CONTAINER = '#hp-change-page-container';
        var AUTH_CATEGORY = 'appliance';

        function CertificateRoutes() {

            var registered = false;

            this.register = function () {

                if (registered) {
                    return;
                }
                registered = true;

                router.map('settings create certificate', '/settings/add/appliance_certificate(/.*|$)', {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!fsPages/settings/certificate/createSelfSignedCertificate.html',
                            'fs/view/settings/certificate/CertificateSelfSignedCreateView'],
                        function (page, view) {
                            result.loadIfManageable(page, view, AUTH_CATEGORY);
                        });
                    }
                });
                router.map('settings create csr', '/settings/add/appliance_csr(/.*|$)', {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!fsPages/settings/certificate/createCSR.html',
                            'fs/view/settings/certificate/CSRCreateView'],
                        function (page, view) {
                            result.loadIfManageable(page, view, AUTH_CATEGORY);
                        });
                    }
                });
                router.map('settings import cert', '/settings/add/appliance_import_certificate(/.*|$)', {
                    container: CHANGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!fsPages/settings/certificate/importCertificate.html',
                            'fs/view/settings/certificate/CertificateImportView'],
                        function (page, view) {
                            result.loadIfManageable(page, view, AUTH_CATEGORY);
                        });
                    }
                });

                router.filter('certificate filter', '^.*', {
                    check: function (location, result) {
                        require(['hp/model/Session'],
                        function (session) {
                            var redirectToSesstingsOverview = session.getProperty("navToSettingsOverview");
                            if (redirectToSesstingsOverview != null && redirectToSesstingsOverview === "true")
                            {
                                var notPersistent = false;
                                session.setProperty("navToSettingsOverview",null,notPersistent);
                                result.redirectTo('/settings');
                            }
                            result.proceed();
                        });
                    }
                });
            };
        }

        return new CertificateRoutes();
    }());

    return CertificateRoutes;
});
