// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
define(['hp/core/Router','hp/core/UrlFragment', 'fs/view/settings/license/LicenseNotifier'],
function (router, urlFragment, licenseNotifier) { "use strict";

    var LicenseRoutes = ( function() {

        var SHOW_CONTAINER = '#hp-settings-show .hp-details-show-view';
        var AUTH_CATEGORY = 'appliance';
        var LICENSES_AUTH_CATEGORY = 'licenses';
        var CHANGE_CONTAINER = '#hp-change-page-container';
        var DIALOG_CONTAINER = '#hp-dialog-container';

        function LicenseRoutes() {
            var registered = false;
            var notInitialized = true;

            this.registerNotifier = function () {
            // Check if it's a valid session and initialize the notifier
                router.filter('license filter', '^.*',  {
                    check: function (location, result) {
                        if (notInitialized  && $('#hp-body-div').hasClass('hp-sessioned'))
                        {
                            licenseNotifier.init();
                            notInitialized = false;
                        }
                        result.proceed();
                    }
                });

            };

            this.register = function () {
                if (registered) {
                    return;
                }
                registered = true;

                router.map('settings show license *',
                    '/settings/show/license/general' + urlFragment.viewPatternTerminal, {
                    container: SHOW_CONTAINER,
                    enter: function(location, result) {
                        require(['text!fsPages/settings/license/more.html',
                            'fs/view/settings/license/LicenseMoreView'],
                        function(page, view) {
                            result.loadIfViewable(page, view, LICENSES_AUTH_CATEGORY);
                        });
                    }
                });

                router.map('adding license key', '/settings/add/license(/.*|$)', {
                    container: DIALOG_CONTAINER,
                    enter: function (location, result) {
                        require(['text!fsPages/settings/license/addLicense.html',
                            'fs/view/settings/license/AddLicenseView'],
                        function (page, view) {
                            result.loadIfManageable(page, view, LICENSES_AUTH_CATEGORY);
                        });
                    }
                });

                router.map('settings show eulapage *',
                    '/settings/show/license/eulapage' + urlFragment.viewPatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function(location, result) {
                        require(['text!fsPages/settings/license/eulapage.html',
                            'fs/view/settings/license/LicenseEulaView'],
                        function(page, view) {
                            result.loadIfViewable(page, view, AUTH_CATEGORY);
                        });
                    }
                });

                router.map('settings show writtenoffer *',
                    '/settings/show/license/writtenoffer' + urlFragment.viewPatternTerminal, {
                    container: CHANGE_CONTAINER,
                    enter: function(location, result) {
                        require(['text!fsPages/settings/license/writtenoffer.html',
                            'fs/view/settings/license/LicenseWrittenofferView'],
                        function(page, view) {
                            result.loadIfViewable(page, view, AUTH_CATEGORY);
                        });
                    }
                });
            };
        }

        return new LicenseRoutes();

    }());

    return LicenseRoutes;

});