// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
define(['hp/core/Router'],
function (router) { "use strict";

    var RestoreRoutes = ( function() {

        var CONFIRM_CONTAINER = '#hp-dialog-container';
        var FULL_PAGE_CONTAINER = '#hp-page-container';
        var AUTH_CATEGORY = 'appliance';

        function RestoreRoutes() {

            var registered = false;

            this.register = function () {

                if (registered) {
                    return;
                }
                registered = true;
                
                router.map('settings restore appliance', '/settings/restore/appliance$', {
                    container: CONFIRM_CONTAINER,
                    enter: function (location, result) {
                        require(['text!fsPages/settings/restore/restoreAttendedDialog.html',
                            'fs/view/settings/restore/UploadThenRestoreView'],
                        function (page, view) {
                            result.loadIfManageable(page, view, AUTH_CATEGORY);
                        });
                    }
                });
  /*              
                router.map('settings restore applianceUploadOnly', '/settings/restore/applianceUploadOnly$', {
                    container: CONFIRM_CONTAINER,
                    enter: function (location, result) {
                        require(['text!fsPages/settings/restore/restoreUploadDialog.html',
                            'fs/view/settings/restore/UploadOnlyView'],
                        function (page, view) {
                            result.loadIfManageable(page, view, AUTH_CATEGORY);
                        });
                    }
                });
   */             
                router.map('applianceUploadAndRestore', '/applianceUploadAndRestore$', {
                    container: FULL_PAGE_CONTAINER,
                    enter: function (location, result) {
                        require(['text!fsPages/settings/restore/restoreUnattendedPage.html',
                            'fs/view/settings/restore/UploadAndRestoreView'],
                        function (page, view) {
                            result.loadIfManageable(page, view, AUTH_CATEGORY);
                        });
                    }
                });
            };
        }

        return new RestoreRoutes();
    }());

    return RestoreRoutes;
});
