// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
define(['hp/core/Router'],
function (router) { "use strict";

    var SupportDumpRoutes = ( function() {

        var CONFIRM_CONTAINER = '#hp-dialog-container';
        var AUTH_CATEGORY = 'appliance';

        function SupportDumpRoutes() {

            var registered = false;

            this.register = function () {

                if (registered) {
                    return;
                }
                registered = true;

                router.map('settings support dump', '/settings/support/createSupportDump(/.*|$)', {
                    container: CONFIRM_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpPages/settings/support/create.html',
                            'hp/view/settings/support/SupportDumpCreateView'],
                        function (page, view) {
                            result.loadIfViewable(page, view, AUTH_CATEGORY);
                        });
                    }
                });

                /*if /createSupportDump link is used, parent page for create support dump dialog will be blank.
                 * TODO:The parent page should not change when create support dump dialog pops up. */
                router.map('support dump', '/createSupportDump(/.*|$)', {
                    container: CONFIRM_CONTAINER,
                    enter: function (location, result) {
                        require(['text!hpPages/settings/support/create.html',
                            'hp/view/settings/support/SupportDumpCreateView'],
                        function (page, view) {
                            result.loadIfViewable(page, view, AUTH_CATEGORY);
                        });
                    }
                });
            };
        }

        return new SupportDumpRoutes();
    }());

    return SupportDumpRoutes;
});
