// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
define(['hp/core/EventDispatcher', 'hp/services/REST'],
function(EventDispatcher, REST) { "use strict";
    var TrapDestinations = (function() {

        function TrapDestinations() {
            // Derive from EventDispatcher
            EventDispatcher.call(this);

            var self = this;

            this.addDestination = function(destination)
            {
                self.fire("destinationAdded", destination);
            };
            
            this.getTrapDestinations = function(handlers) {
                REST.getURI('/rest/appliance/trap-destinations?start=0&count=-1&sort=resourceURI:ascending', handlers);
            };
            
            this.deleteTrapDestination = function(uri, handlers)
            {
                REST.deleteURI(uri, handlers);    
            };
            
            this.addTrapDestination = function(uri, trapDestination, handlers){
                REST.postObject(uri, trapDestination,
                    handlers);
            };
        }

        return new TrapDestinations();
    }());
    return TrapDestinations;
});
