// (C) Copyright 2020 Hewlett-Packard Enterprise Company, L.P.
/**
 * @type {StatusRestoreRoutes}
 */
define(['hp/core/Router'],
function (router) { "use strict";

    var StatusRestoreRoutes = ( function() {

        var CONTAINER = '#hp-page-container';

        function StatusRestoreRoutes() {

            var registered = false;
            var needToReportRestoreError = true;
            
            function proceedToLogin(result) {
                // Check for restore error the next time
                // we go to the login page
                needToReportRestoreError = true;
                result.proceed();
            }

            function restoreErrorFilter(session, restore, result) {
                if (!needToReportRestoreError) {
                    proceedToLogin(result);
                } else {
                    restore.getRestoreFailureStatus( {
                        success : function(restoreResult) {
                            if (restoreResult && !restoreResult.restoreFailed) {
                                proceedToLogin(result);
                            } else {
                                // After we report the error, 
                                // we don't need to report it again
                                needToReportRestoreError = false;
                                result.redirectTo('/restore-error');
                            }
                        },
                        error : function(errorInfo) {
                            // Assume no restore error to report
                            proceedToLogin(result);
                        }
                    });
                }
            }

            this.register = function () {

                if (registered) {
                    return;
                } 
                registered = true;

                router.map('restore error', '^/restore-error(/.*|$)', {
                    menu: {
                        simpleBanner: true
                    },
                    container: CONTAINER,
                    enter: function (location, result) {
                        require(['text!fsPages/status/restoreError.html',
                            'fs/view/status/StatusRestoreErrorView'],
                        function (page, view) {
                            result.load(page, view);
                        });
                    }
                });

                router.filter('restore error filter', '^/login(/.*|$)', {
                    check: function (location, result) {
                        require(['hp/model/Session',
                            'fs/services/restore/RestoreService'],
                        function (session, restore) {
                            restoreErrorFilter(session, restore, result);
                        });
                    }
                });
            };
            
        }

        return new StatusRestoreRoutes();
    }());

    return StatusRestoreRoutes;
});
